/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.criterion.ElementNamedCriterion;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.response.AbstractPointAtAnimation;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Vector3d;

public class LookAtAnimation
extends AbstractPointAtAnimation {
    public final BooleanProperty onlyAffectYaw = new BooleanProperty(this, "onlyAffectYaw", Boolean.FALSE);

    private Model getHead(Transformable subject) {
        Element[] heads = subject.search(new ElementNamedCriterion("head", true));
        if (heads.length > 0 && heads[0] instanceof Model) {
            return (Model)heads[0];
        }
        return null;
    }

    public class RuntimeLookAtAnimation
    extends AbstractPointAtAnimation.RuntimeAbstractPointAtAnimation {
        Direction m_direction;
        double m_turnAmount;
        double m_turnAmountPrev;
        Transformable m_subjectTrans;

        public RuntimeLookAtAnimation() {
            super(LookAtAnimation.this);
            this.m_direction = null;
            this.m_turnAmount = 0.0;
            this.m_turnAmountPrev = 0.0;
            this.m_subjectTrans = null;
        }

        @Override
        public void prologue(double t) {
            this.m_target = LookAtAnimation.this.target.getReferenceFrameValue();
            if (this.m_target == null) {
                throw new SimulationPropertyException(Messages.getString("character_value_must_not_be_null_"), this.getCurrentStack(), LookAtAnimation.this.target);
            }
            super.prologue(t);
            this.m_turnAmountPrev = 0.0;
            if (this.m_subject == this.m_target) {
                throw new SimulationPropertyException(Messages.getString("subject_and_character_values_must_not_be_the_same_"), this.getCurrentStack(), LookAtAnimation.this.subject);
            }
            if (!this.m_subject.equals(LookAtAnimation.this.subject.getTransformableValue())) {
                this.m_subjectTrans = LookAtAnimation.this.subject.getTransformableValue();
                Matrix33 targetMatrix = this.m_subjectTrans.calculatePointAt(this.m_target, this.m_offset, this.m_upGuide, this.m_asSeenBy, true);
                Matrix33 subjectMatrix = this.m_subjectTrans.getOrientationAsAxes();
                Vector3 targetForward = targetMatrix.getRow(2);
                Vector3 subjectForward = subjectMatrix.getRow(2);
                double cosAngle = subjectForward.dot(targetForward) / (targetForward.length() * subjectForward.length());
                cosAngle = Math.acos(cosAngle);
                if ((cosAngle /= Math.PI * 2) > 0.25) {
                    this.m_turnAmount = cosAngle - 0.25;
                    Vector3 targetPos = this.m_target.getPosition(this.m_subjectTrans);
                    this.m_direction = targetPos.x < 0.0 ? Direction.LEFT : Direction.LEFT;
                } else {
                    this.m_turnAmount = 0.0;
                }
            }
        }

        @Override
        public void update(double t) {
            super.update(t);
            if (this.m_turnAmount > 0.0) {
                double delta = this.m_turnAmount * this.getPortion(t) - this.m_turnAmountPrev;
                this.m_subjectTrans.rotateRightNow(this.m_direction.getTurnAxis(), delta, this.m_subjectTrans);
                this.m_turnAmountPrev += delta;
            }
        }

        @Override
        protected boolean onlyAffectYaw() {
            Model head = LookAtAnimation.this.getHead(LookAtAnimation.this.subject.getTransformableValue());
            return head == null;
        }

        @Override
        protected ReferenceFrame getTarget() {
            ReferenceFrame targetRef = LookAtAnimation.this.target.getReferenceFrameValue();
            if (targetRef instanceof Transformable) {
                Model head = LookAtAnimation.this.getHead((Transformable)targetRef);
                if (head != null) {
                    return head;
                }
                return LookAtAnimation.this.target.getReferenceFrameValue();
            }
            return LookAtAnimation.this.target.getReferenceFrameValue();
        }

        @Override
        protected Transformable getSubject() {
            Model head = LookAtAnimation.this.getHead(LookAtAnimation.this.subject.getTransformableValue());
            if (head != null) {
                return head;
            }
            return LookAtAnimation.this.subject.getTransformableValue();
        }

        @Override
        protected Vector3d getOffset() {
            ReferenceFrame targetRef = LookAtAnimation.this.target.getReferenceFrameValue();
            if (targetRef instanceof Transformable) {
                Model head = LookAtAnimation.this.getHead((Transformable)targetRef);
                if (head != null) {
                    return head.getBoundingBox().getCenter();
                }
                return LookAtAnimation.this.target.getReferenceFrameValue().getBoundingBox().getCenter();
            }
            return LookAtAnimation.this.target.getReferenceFrameValue().getBoundingBox().getCenter();
        }
    }
}

