/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.criterion.ElementNameContainsCriterion;
import edu.cmu.cs.stage3.alice.core.property.DirectionProperty;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.response.OrientationAnimation;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Quaternion;

public class LookDirectionAnimation
extends OrientationAnimation {
    public final DirectionProperty lookDirection = new DirectionProperty(this, "lookDirection", Direction.FORWARD);
    public final NumberProperty amount = new NumberProperty(this, "amount", new Double(0.2));

    public class RuntimeLookDirectionAnimation
    extends OrientationAnimation.RuntimeOrientationAnimation {
        Transformable head;
        Direction m_lookDirection;
        Quaternion initialQuat;
        Quaternion targetQuat;

        public RuntimeLookDirectionAnimation() {
            super(LookDirectionAnimation.this);
            this.head = null;
            this.m_lookDirection = null;
            this.initialQuat = null;
            this.targetQuat = null;
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            this.m_lookDirection = LookDirectionAnimation.this.lookDirection.getDirectionValue();
            this.findHead();
            if (this.head != null) {
                this.m_subject = this.head;
            }
            this.initialQuat = this.head.getOrientationAsQuaternion((ReferenceFrame)this.head.getParent());
            this.targetQuat = null;
        }

        @Override
        public void update(double t) {
            if (this.targetQuat == null) {
                this.targetQuat = this.getTargetQuaternion();
            }
            Quaternion q = Quaternion.interpolate(this.initialQuat, this.targetQuat, this.getPortion(t));
            this.head.setOrientationRightNow(q, (ReferenceFrame)this.head.getParent());
        }

        @Override
        public Quaternion getTargetQuaternion() {
            Quaternion quat = this.head.getOrientationAsQuaternion((ReferenceFrame)this.head.getParent());
            Matrix33 orient = new Matrix33();
            double amt = LookDirectionAnimation.this.amount.doubleValue();
            if (!this.m_lookDirection.equals(Direction.FORWARD)) {
                if (this.m_lookDirection.equals(Direction.UP)) {
                    orient.rotateX(-1.0 * amt * Math.PI);
                } else if (this.m_lookDirection.equals(Direction.DOWN)) {
                    orient.rotateX(amt * Math.PI);
                } else if (this.m_lookDirection.equals(Direction.LEFT)) {
                    orient.rotateY(amt * Math.PI);
                } else if (this.m_lookDirection.equals(Direction.RIGHT)) {
                    orient.rotateY(-1.0 * amt * Math.PI);
                }
            }
            quat.setMatrix33(orient);
            return quat;
        }

        public void findHead() {
            Element[] heads = this.m_subject.search(new ElementNameContainsCriterion("head"));
            if (heads.length > 0) {
                this.head = (Transformable)heads[0];
            }
        }
    }
}

