/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.response.TransformAnimation;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationListener;
import edu.cmu.cs.stage3.math.Quaternion;

public abstract class OrientationAnimation
extends TransformAnimation {

    public abstract class RuntimeOrientationAnimation
    extends TransformAnimation.RuntimeTransformAnimation
    implements AbsoluteTransformationListener {
        protected Quaternion m_quaternion0;
        private Quaternion m_quaternion1;

        protected abstract Quaternion getTargetQuaternion();

        @Override
        public void absoluteTransformationChanged(AbsoluteTransformationEvent absoluteTransformationEvent) {
            this.markTargetQuaternionDirty();
        }

        protected void markTargetQuaternionDirty() {
            this.m_quaternion1 = null;
        }

        protected boolean affectQuaternion() {
            return true;
        }

        protected void setSubject(Transformable newSubject) {
            this.m_subject = newSubject;
            if (this.m_subject != null) {
                this.m_quaternion0 = this.m_subject.getOrientationAsQuaternion(this.m_asSeenBy);
            }
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            if (this.m_asSeenBy == null) {
                this.m_asSeenBy = this.m_subject.vehicle.getReferenceFrameValue();
            }
            if (this.affectQuaternion()) {
                this.m_quaternion0 = this.m_subject.getOrientationAsQuaternion(this.m_asSeenBy);
                this.markTargetQuaternionDirty();
            }
            this.m_asSeenBy.addAbsoluteTransformationListener(this);
        }

        @Override
        public void update(double t) {
            super.update(t);
            if (this.affectQuaternion()) {
                if (this.m_quaternion1 == null) {
                    this.m_quaternion1 = this.getTargetQuaternion();
                }
                Quaternion q = Quaternion.interpolate(this.m_quaternion0, this.m_quaternion1, this.getPortion(t));
                this.m_subject.setOrientationRightNow(q, this.m_asSeenBy);
            }
        }

        @Override
        public void epilogue(double t) {
            super.epilogue(t);
            if (this.m_asSeenBy != null) {
                this.m_asSeenBy.removeAbsoluteTransformationListener(this);
            }
        }
    }
}

