/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.property.DirectionProperty;
import edu.cmu.cs.stage3.alice.core.property.TransformableProperty;
import edu.cmu.cs.stage3.alice.core.response.AbstractBodyPositionAnimation;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.util.HowMuch;
import javax.vecmath.Vector3d;

public class SitAnimation
extends AbstractBodyPositionAnimation {
    public final TransformableProperty target = new TransformableProperty((Element)this, "target", null);
    public final DirectionProperty side = new DirectionProperty(this, "side", Direction.FORWARD);

    public class RuntimeSitAnimation
    extends AbstractBodyPositionAnimation.RuntimeAbstractBodyPositionAnimation {
        Transformable m_target;
        private Vector3d m_positionBegin;
        private Vector3d m_positionEnd;

        public RuntimeSitAnimation() {
            super(SitAnimation.this);
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            this.m_target = SitAnimation.this.target.getTransformableValue();
            this.m_positionBegin = this.m_subject.getPosition(this.m_subject.getWorld());
            this.m_positionEnd = null;
            if (this.m_target == null) {
                throw new SimulationPropertyException(String.valueOf(this.m_subject.name.getStringValue()) + " " + Messages.getString("needs_something_or_someone_to_sit_on_"), null, SitAnimation.this.target);
            }
            if (this.m_target == this.m_subject) {
                throw new SimulationPropertyException(String.valueOf(this.m_subject.name.getStringValue()) + " " + Messages.getString("can_t_sit_on_") + this.m_target.name.getStringValue() + ".", this.getCurrentStack(), SitAnimation.this.target);
            }
            if (this.m_subject.isAncestorOf(this.m_target)) {
                throw new SimulationPropertyException(String.valueOf(this.m_subject.name.getStringValue()) + " " + Messages.getString("can_t_sit_on_a_part_of_itself"), this.getCurrentStack(), SitAnimation.this.target);
            }
            this.findLegs();
            this.getInitialOrientations();
            this.setFinalOrientations();
        }

        @Override
        public void update(double t) {
            super.update(t);
            if (this.m_positionEnd == null) {
                this.m_positionEnd = this.getPositionEnd();
            }
            this.m_subject.setPositionRightNow(MathUtilities.interpolate(this.m_positionBegin, this.m_positionEnd, this.getPortion(t)), ReferenceFrame.ABSOLUTE);
            this.setOrientation(this.rightUpper, this.rightUpperInitialOrient, this.rightUpperFinalOrient, this.getPortion(t));
            if (!this.m_target.name.getStringValue().equals("ground")) {
                this.setOrientation(this.rightLower, this.rightLowerInitialOrient, this.rightLowerFinalOrient, this.getPortion(t));
            }
            this.setOrientation(this.leftUpper, this.leftUpperInitialOrient, this.leftUpperFinalOrient, this.getPortion(t));
            if (!this.m_target.name.getStringValue().equals("ground")) {
                this.setOrientation(this.leftLower, this.leftLowerInitialOrient, this.leftLowerFinalOrient, this.getPortion(t));
            }
            this.adjustHeight();
        }

        @Override
        protected void adjustHeight() {
            if (this.m_target == null || this.m_target.name.getStringValue().equals("ground")) {
                super.adjustHeight();
            }
        }

        @Override
        protected Quaternion getTargetQuaternion() {
            Matrix33 orient = this.m_target.getOrientationAsAxes(this.m_target.getWorld());
            if (SitAnimation.this.side.getDirectionValue().equals(Direction.BACKWARD)) {
                orient.rotateY(Math.PI);
            } else if (SitAnimation.this.side.getDirectionValue().equals(Direction.LEFT)) {
                orient.rotateY(-1.5707963267948966);
            } else if (SitAnimation.this.side.getDirectionValue().equals(Direction.RIGHT)) {
                orient.rotateY(1.5707963267948966);
            }
            if (this.m_target.name.getStringValue().equals("ground")) {
                Matrix44 currentTrans = this.m_subject.getTransformation(this.m_subject.getWorld());
                this.m_subject.standUpRightNow();
                orient = this.m_subject.getOrientationAsAxes(this.m_subject.getWorld());
                this.m_subject.setTransformationRightNow(currentTrans, this.m_subject.getWorld());
            }
            return orient.getQuaternion();
        }

        protected Vector3d getPositionEnd() {
            if (this.m_target != null) {
                Vector3d centerTopFace = this.m_target.getBoundingBox(this.m_target).getCenterOfTopFace();
                Vector3d endPos = this.m_target.getBoundingBox(this.m_target.getWorld()).getCenterOfTopFace();
                Vector3[] forwardAndUp = this.m_target.getOrientationAsForwardAndUpGuide(this.m_target.getWorld());
                if (this.leftUpper != null && this.leftLower == null || this.m_target.name.getStringValue().equals("ground")) {
                    double xOffset = this.m_subject.getBoundingBox().getCenter().x;
                    double yOffset = this.leftUpper.getPosition((ReferenceFrame)this.m_subject).y;
                    double zStart = 0.0;
                    double depthSeat = this.leftUpper.getBoundingBox(this.leftUpper).getHeight() * 2.0 / 3.0;
                    if (SitAnimation.this.side.getDirectionValue().equals(Direction.BACKWARD) || SitAnimation.this.side.getDirectionValue().equals(Direction.FORWARD)) {
                        if (depthSeat > this.m_target.getBoundingBox(this.m_target).getDepth()) {
                            depthSeat = this.m_target.getBoundingBox(this.m_target).getDepth();
                        }
                        if (SitAnimation.this.side.getDirectionValue().equals(Direction.BACKWARD)) {
                            zStart = this.m_target.getBoundingBox((ReferenceFrame)this.m_target).getCenterOfBackFace().z;
                            depthSeat *= -1.0;
                        } else {
                            zStart = this.m_target.getBoundingBox((ReferenceFrame)this.m_target).getCenterOfFrontFace().z;
                        }
                        endPos = new Vector3d(centerTopFace.x - xOffset, centerTopFace.y - yOffset, zStart - depthSeat);
                        endPos = this.m_target.getPosition(endPos, this.m_target.getWorld());
                    } else if (SitAnimation.this.side.getDirectionValue().equals(Direction.LEFT) || SitAnimation.this.side.getDirectionValue().equals(Direction.RIGHT)) {
                        if (depthSeat > this.m_target.getBoundingBox(this.m_target).getWidth()) {
                            depthSeat = this.m_target.getBoundingBox(this.m_target).getWidth();
                        }
                        if (SitAnimation.this.side.getDirectionValue().equals(Direction.RIGHT)) {
                            zStart = this.m_target.getBoundingBox((ReferenceFrame)this.m_target).getCenterOfRightFace().x;
                        } else {
                            zStart = this.m_target.getBoundingBox((ReferenceFrame)this.m_target).getCenterOfLeftFace().x;
                            depthSeat *= -1.0;
                        }
                        endPos = new Vector3d(zStart - depthSeat, centerTopFace.y - yOffset, centerTopFace.z - xOffset);
                        endPos = this.m_target.getPosition(endPos, this.m_target.getWorld());
                    }
                    if (this.m_target.name.getStringValue().equals("ground")) {
                        endPos = this.m_subject.getPosition(this.m_subject.getWorld());
                        endPos.y -= depthSeat;
                    }
                    return endPos;
                }
                if (this.leftUpper != null && this.leftLower != null) {
                    double depthSeat = this.leftUpper.getBoundingBox(this.leftUpper, HowMuch.INSTANCE).getHeight() - this.leftLower.getBoundingBox(this.leftLower, HowMuch.INSTANCE).getDepth() / 2.0;
                    depthSeat *= 0.6666666666666666;
                    double xOffset = this.m_subject.getBoundingBox().getCenter().x;
                    double yOffset = this.leftUpper.getPosition((ReferenceFrame)this.m_subject).y;
                    double zStart = 0.0;
                    if (SitAnimation.this.side.getDirectionValue().equals(Direction.BACKWARD) || SitAnimation.this.side.getDirectionValue().equals(Direction.FORWARD)) {
                        if (depthSeat > this.m_target.getBoundingBox(this.m_target).getDepth()) {
                            depthSeat = this.m_target.getBoundingBox(this.m_target).getDepth();
                        }
                        if (SitAnimation.this.side.getDirectionValue().equals(Direction.BACKWARD)) {
                            zStart = this.m_target.getBoundingBox((ReferenceFrame)this.m_target).getCenterOfBackFace().z;
                            depthSeat *= -1.0;
                        } else {
                            zStart = this.m_target.getBoundingBox((ReferenceFrame)this.m_target).getCenterOfFrontFace().z;
                        }
                        endPos = new Vector3d(centerTopFace.x - xOffset, centerTopFace.y - yOffset, zStart - depthSeat);
                        endPos = this.m_target.getPosition(endPos, this.m_target.getWorld());
                    } else if (SitAnimation.this.side.getDirectionValue().equals(Direction.LEFT) || SitAnimation.this.side.getDirectionValue().equals(Direction.RIGHT)) {
                        if (depthSeat > this.m_target.getBoundingBox(this.m_target).getWidth()) {
                            depthSeat = this.m_target.getBoundingBox(this.m_target).getWidth();
                        }
                        if (SitAnimation.this.side.getDirectionValue().equals(Direction.RIGHT)) {
                            zStart = this.m_target.getBoundingBox((ReferenceFrame)this.m_target).getCenterOfRightFace().x;
                        } else {
                            zStart = this.m_target.getBoundingBox((ReferenceFrame)this.m_target).getCenterOfLeftFace().x;
                            depthSeat *= -1.0;
                        }
                        endPos = new Vector3d(zStart - depthSeat, centerTopFace.y - yOffset, centerTopFace.z - xOffset);
                        endPos = this.m_target.getPosition(endPos, this.m_target.getWorld());
                    }
                    return endPos;
                }
                return endPos;
            }
            return this.m_positionBegin;
        }

        public void setFinalOrientations() {
            this.rightUpperFinalOrient = new Matrix33();
            this.leftUpperFinalOrient = new Matrix33();
            this.rightLowerFinalOrient = new Matrix33();
            this.leftLowerFinalOrient = new Matrix33();
            this.rightUpperFinalOrient.rotateX(-1.5707963267948966);
            this.leftUpperFinalOrient.rotateX(-1.5707963267948966);
            this.rightLowerFinalOrient.rotateX(1.5707963267948966);
            this.leftLowerFinalOrient.rotateX(1.5707963267948966);
        }
    }
}

