/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Sound;
import edu.cmu.cs.stage3.alice.core.event.ExpressionEvent;
import edu.cmu.cs.stage3.alice.core.event.ExpressionListener;
import edu.cmu.cs.stage3.alice.core.event.SoundEvent;
import edu.cmu.cs.stage3.alice.core.event.SoundListener;
import edu.cmu.cs.stage3.alice.core.media.SoundMarker;
import edu.cmu.cs.stage3.alice.core.property.ElementProperty;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.ReferenceFrameProperty;
import edu.cmu.cs.stage3.alice.core.property.SoundProperty;
import edu.cmu.cs.stage3.media.DataSource;
import edu.cmu.cs.stage3.media.Player;
import java.util.Vector;

public class SoundResponse
extends Response {
    public final ReferenceFrameProperty subject = new ReferenceFrameProperty((Element)this, "subject", null);
    public final SoundProperty sound = new SoundProperty((Element)this, "sound", null);
    public final ElementProperty fromMarker = new ElementProperty((Element)this, "fromMarker", null, SoundMarker.class);
    public final ElementProperty toMarker = new ElementProperty((Element)this, "toMarker", null, SoundMarker.class);
    public final NumberProperty volumeLevel = new NumberProperty(this, "volumeLevel", new Double(1.0));
    public final NumberProperty rate = new NumberProperty(this, "rate", new Double(1.0));
    public final NumberProperty pan = new NumberProperty(this, "pan", new Double(0.0));
    private Vector soundListeners = new Vector();
    private SoundListener[] soundListenerArray = null;

    @Override
    protected Number getDefaultDuration() {
        return null;
    }

    public void addSoundListener(SoundListener soundListener) {
        if (!this.soundListeners.contains(soundListener)) {
            this.soundListeners.addElement(soundListener);
            this.soundListenerArray = null;
        }
    }

    public void removeSoundListener(SoundListener soundListener) {
        this.soundListeners.removeElement(soundListener);
        this.soundListenerArray = null;
    }

    public SoundListener[] getSoundListeners() {
        if (this.soundListenerArray == null) {
            this.soundListenerArray = new SoundListener[this.soundListeners.size()];
            this.soundListeners.copyInto(this.soundListenerArray);
        }
        return this.soundListenerArray;
    }

    private void fireSoundListeners(double time, double duration, DataSource ds) {
        SoundEvent e = new SoundEvent(this, new Double(time), ds, new Double(duration));
        int i = 0;
        while (i < this.soundListeners.size()) {
            SoundListener l = (SoundListener)this.soundListeners.elementAt(i);
            l.SoundStarted(e);
            ++i;
        }
    }

    public class RuntimeSoundResponse
    extends Response.RuntimeResponse {
        private Player m_player = null;
        private Expression m_volumeLevelExpression = null;
        private Expression m_rateExpression = null;
        private Expression m_panExpression = null;
        private ExpressionListener m_volumeLevelExpressionListener = new ExpressionListener(){

            @Override
            public void expressionChanged(ExpressionEvent e) {
                RuntimeSoundResponse.this.updateVolumeLevel(e.getExpression());
            }
        };
        private ExpressionListener m_rateExpressionListener = new ExpressionListener(){

            @Override
            public void expressionChanged(ExpressionEvent e) {
                RuntimeSoundResponse.this.updateRate(e.getExpression());
            }
        };
        private double m_prevMediaTime;
        private double m_timeout;

        private void updateVolumeLevel(Number n) {
            if (this.m_player != null) {
                this.m_player.setVolumeLevel(n.floatValue());
            }
        }

        private void updateVolumeLevel(Expression expression) {
            Object value;
            if (expression != null && (value = expression.getValue()) instanceof Number) {
                this.updateVolumeLevel((Number)value);
            }
        }

        private void updateRate(Number n) {
            if (this.m_player != null) {
                this.m_player.setRate(n.floatValue());
            }
        }

        private void updateRate(Expression expression) {
            Object value;
            if (expression != null && (value = expression.getValue()) instanceof Number) {
                this.updateRate((Number)value);
            }
        }

        @Override
        public void prologue(double t) {
            DataSource dataSourceValue;
            super.prologue(t);
            Sound soundValue = SoundResponse.this.sound.getSoundValue();
            if (soundValue != null && (dataSourceValue = soundValue.dataSource.getDataSourceValue()) != null) {
                this.m_player = dataSourceValue.acquirePlayer();
                SoundResponse.this.fireSoundListeners(t, this.m_player.getDuration(), dataSourceValue);
                AuthoringTool.pauseSound(this.m_player);
            }
            this.m_volumeLevelExpression = null;
            Object o = SoundResponse.this.volumeLevel.get();
            if (o instanceof Expression) {
                this.m_volumeLevelExpression = (Expression)o;
                this.m_volumeLevelExpression.addExpressionListener(this.m_volumeLevelExpressionListener);
                this.updateVolumeLevel(this.m_volumeLevelExpression);
            } else {
                this.updateVolumeLevel((Number)o);
            }
            this.m_rateExpression = null;
            o = SoundResponse.this.rate.get();
            if (o instanceof Expression) {
                this.m_rateExpression = (Expression)o;
                this.m_rateExpression.addExpressionListener(this.m_rateExpressionListener);
                this.updateRate(this.m_rateExpression);
            } else {
                this.updateRate((Number)o);
            }
            this.m_prevMediaTime = 0.0;
            this.m_timeout = Double.NaN;
        }

        @Override
        public void epilogue(double t) {
            if (this.m_volumeLevelExpression != null) {
                this.m_volumeLevelExpression.removeExpressionListener(this.m_volumeLevelExpressionListener);
            }
            if (this.m_rateExpression != null) {
                this.m_rateExpression.removeExpressionListener(this.m_rateExpressionListener);
            }
            Sound soundValue = SoundResponse.this.sound.getSoundValue();
            if (this.m_player != null) {
                this.m_player.stop();
                this.m_player.setIsAvailable(true);
                this.m_player = null;
            }
            super.epilogue(t);
        }

        @Override
        public double getTimeRemaining(double t) {
            if (this.m_player != null) {
                double endMediaTime;
                double currMediaTime = this.m_player.getCurrentTime();
                double duration = SoundResponse.this.duration.doubleValue();
                if (Double.isNaN(duration)) {
                    endMediaTime = this.m_player.getEndTime();
                    if (Double.isNaN(endMediaTime)) {
                        endMediaTime = this.m_player.getDuration();
                    }
                } else {
                    endMediaTime = duration;
                }
                double mediaTimeRemaining = endMediaTime - currMediaTime;
                double elapsedTime = this.getTimeElapsed(t);
                if (this.m_prevMediaTime != currMediaTime) {
                    this.m_timeout = elapsedTime + mediaTimeRemaining;
                    this.m_prevMediaTime = currMediaTime;
                }
                if (!Double.isNaN(this.m_timeout) && elapsedTime > this.m_timeout) {
                    mediaTimeRemaining = 0.0;
                }
                return mediaTimeRemaining;
            }
            return 0.0;
        }

        @Override
        public double getDuration() {
            double dur = super.getDuration();
            if (dur == 0.0) {
                return Double.NaN;
            }
            return dur;
        }
    }
}

