/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.camera.SymmetricPerspectiveCamera;
import edu.cmu.cs.stage3.alice.core.property.DirectionProperty;
import edu.cmu.cs.stage3.alice.core.response.AbstractWalkAnimation;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationListener;
import edu.cmu.cs.stage3.math.Matrix33;
import javax.vecmath.Vector3d;

public class WalkOffscreen
extends AbstractWalkAnimation {
    public final DirectionProperty exitDirection = new DirectionProperty(this, "exit direction", Direction.RIGHT);
    double turnLength = 0.25;

    @Override
    protected void propertyChanged(Property property, Object value) {
        super.propertyChanged(property, value);
        if (property.equals(this.duration)) {
            if (!Double.isNaN((Double)value)) {
                this.turnLength = this.duration.doubleValue() > 2.0 ? 0.5 : this.duration.doubleValue() / 5.0;
            }
        } else if (property.equals(this.stepSpeed) && !Double.isNaN((Double)value)) {
            this.turnLength = 0.5;
        }
    }

    public class RuntimeWalkOffScreen
    extends AbstractWalkAnimation.RuntimeAbstractWalkAnimation
    implements AbsoluteTransformationListener {
        private Matrix33 m_orient0;
        private Matrix33 m_orient1;
        private boolean firstOver1 = true;
        protected Camera camera = null;
        protected double cameraAngle = 0.0;
        protected double distanceToCenter = 0.0;
        protected double distanceToMove = 0.0;
        double timePerStep = -1.0;
        double stepLength = -1.0;
        double numberOfSteps = -1.0;
        double currentPos = 0.0;
        double boundingBoxDepth = -1.0;

        @Override
        public void absoluteTransformationChanged(AbsoluteTransformationEvent absoluteTransformationEvent) {
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            this.findCamera();
            this.getActualStepLength();
            this.m_orient0 = this.subject.getOrientationAsAxes(this.camera);
            this.m_orient1 = new Matrix33();
            if (WalkOffscreen.this.exitDirection.getDirectionValue().equals(Direction.LEFT)) {
                this.m_orient1.setForwardUpGuide(new Vector3d(-1.0, 0.0, 0.0), this.m_orient0.getRow(1));
            } else {
                this.m_orient1.setForwardUpGuide(new Vector3d(1.0, 0.0, 0.0), this.m_orient0.getRow(1));
            }
        }

        protected double getActualStepLength() {
            if (this.stepLength == -1.0) {
                this.stepLength = this.getStepLength();
                if (this.stepLength == 0.0) {
                    this.stepLength = 1.0;
                }
            }
            if (this.numberOfSteps == -1.0) {
                this.numberOfSteps = Math.round(this.distanceToMove / this.stepLength);
            }
            return this.distanceToMove / this.numberOfSteps;
        }

        @Override
        public double getTimeRemaining(double t) {
            double walkTime = WalkOffscreen.this.duration.doubleValue() - WalkOffscreen.this.turnLength;
            double totalTime = walkTime + WalkOffscreen.this.turnLength;
            if (Double.isNaN(walkTime)) {
                walkTime = this.numberOfSteps / WalkOffscreen.this.stepSpeed.doubleValue();
                totalTime = walkTime + WalkOffscreen.this.turnLength;
            }
            return totalTime - this.getTimeElapsed(t);
        }

        @Override
        protected double getPortion(double t) {
            double duration = this.getDuration();
            if (Double.isNaN(duration)) {
                duration = this.numberOfSteps / WalkOffscreen.this.stepSpeed.doubleValue() + WalkOffscreen.this.turnLength;
            }
            return this.m_style.getPortion(Math.min(this.getTimeElapsed(t), duration), duration);
        }

        @Override
        public void update(double t) {
            if (this.getTimeElapsed(t) <= WalkOffscreen.this.turnLength) {
                double portion = this.m_style.getPortion(Math.min(this.getTimeElapsed(t), WalkOffscreen.this.turnLength), WalkOffscreen.this.turnLength);
                Matrix33 q = Matrix33.interpolate(this.m_orient0, this.m_orient1, portion);
                this.subject.setOrientationRightNow(q, (ReferenceFrame)this.camera);
            } else {
                double portionOfStep;
                int stepNumber;
                if (this.firstOver1) {
                    Matrix33 q = Matrix33.interpolate(this.m_orient0, this.m_orient1, this.m_style.getPortion(Math.min(this.getTimeElapsed(WalkOffscreen.this.turnLength), WalkOffscreen.this.turnLength), WalkOffscreen.this.turnLength));
                    this.subject.setOrientationRightNow(q, (ReferenceFrame)this.camera);
                    this.firstOver1 = false;
                }
                if (this.timePerStep == -1.0) {
                    this.timePerStep = !Double.isNaN(WalkOffscreen.this.duration.doubleValue()) ? (WalkOffscreen.this.duration.doubleValue() - WalkOffscreen.this.turnLength) / this.numberOfSteps : 1.0 / WalkOffscreen.this.stepSpeed.doubleValue();
                }
                if ((stepNumber = (int)Math.ceil((this.getTimeElapsed(t) - WalkOffscreen.this.turnLength) * (1.0 / this.timePerStep)) - 1) == -1) {
                    stepNumber = 0;
                }
                if ((double)stepNumber == this.numberOfSteps) {
                    --stepNumber;
                }
                if ((portionOfStep = (this.getTimeElapsed(t) - WalkOffscreen.this.turnLength - (double)stepNumber * this.timePerStep) / this.timePerStep) > 1.0) {
                    portionOfStep = 1.0;
                }
                boolean lastStep = false;
                if ((double)stepNumber == this.numberOfSteps - 1.0) {
                    lastStep = true;
                }
                if (stepNumber % 2 == 0) {
                    this.stepRight(portionOfStep, lastStep);
                } else {
                    this.stepLeft(portionOfStep, lastStep);
                }
                double portion = (this.getTimeElapsed(t) - WalkOffscreen.this.turnLength) / (this.getTimeElapsed(t) - WalkOffscreen.this.turnLength + this.getTimeRemaining(t));
                double targetDistance = this.distanceToMove * portion;
                WalkOffscreen.this.subject.getTransformableValue().moveRightNow(Direction.FORWARD, targetDistance - this.currentPos);
                this.currentPos += targetDistance - this.currentPos;
            }
            super.update(t);
        }

        protected void findCamera() {
            if (this.camera == null) {
                Element camElement = this.subject.getWorld().getChildNamed("Camera");
                if (camElement != null) {
                    this.camera = (Camera)camElement;
                }
                this.camera.addAbsoluteTransformationListener(this);
            }
            if (this.boundingBoxDepth == -1.0) {
                this.boundingBoxDepth = this.subject.getBoundingBox().getDepth();
            }
            this.cameraAngle = 0.0;
            if (this.camera instanceof SymmetricPerspectiveCamera) {
                this.cameraAngle = ((SymmetricPerspectiveCamera)this.camera).horizontalViewingAngle.doubleValue();
            }
            if (this.cameraAngle != 0.0) {
                double hypot = this.subject.getPosition((ReferenceFrame)this.camera).z;
                this.distanceToCenter = hypot * Math.sin(this.cameraAngle / 2.0);
            }
            this.distanceToMove = WalkOffscreen.this.exitDirection.getDirectionValue().equals(Direction.LEFT) ? this.distanceToCenter + 1.5 * this.boundingBoxDepth + this.subject.getPosition((ReferenceFrame)this.camera).x : this.distanceToCenter + 1.5 * this.boundingBoxDepth - this.subject.getPosition((ReferenceFrame)this.camera).x;
        }
    }
}

