/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response.visualization.model;

import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.response.visualization.model.ModelVisualizationWithItemAnimation;
import edu.cmu.cs.stage3.alice.core.visualization.ModelVisualization;
import edu.cmu.cs.stage3.math.HermiteCubic;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;

public class SetItem
extends ModelVisualizationWithItemAnimation {

    public class RuntimeSetItem
    extends ModelVisualizationWithItemAnimation.RuntimeModelVisualizationWithItemAnimation {
        private Quaternion m_quaternion0;
        private Quaternion m_quaternion1;
        private HermiteCubic m_xHermite;
        private HermiteCubic m_yHermite;
        private HermiteCubic m_zHermite;
        private ModelVisualization m_subject;
        private Model m_value;

        public RuntimeSetItem() {
            super(SetItem.this);
        }

        @Override
        public void prologue(double t) {
            this.m_subject = SetItem.this.subject.getModelVisualizationValue();
            this.m_value = SetItem.this.item.getModelValue();
            Model prev = this.m_subject.getItem();
            if (prev != null && prev != this.m_value) {
                prev.visualization.set(null);
            }
            if (this.m_value != null) {
                this.m_value.visualization.set(null);
                Matrix44 transformation0 = this.m_value.getTransformation(this.m_subject);
                Matrix44 transformation1 = new Matrix44(this.m_subject.getTransformationFor(this.m_value));
                this.m_quaternion0 = transformation0.getAxes().getQuaternion();
                this.m_quaternion1 = transformation1.getAxes().getQuaternion();
                double dx = transformation0.m30 - transformation1.m30;
                double dy = transformation0.m31 - transformation1.m31;
                double dz = transformation0.m32 - transformation1.m32;
                double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                double s = distance / 2.0;
                this.m_xHermite = new HermiteCubic(transformation0.m30, transformation1.m30, transformation0.m20 * s, transformation1.m20 * s);
                this.m_yHermite = new HermiteCubic(transformation0.m31, transformation1.m31, transformation0.m21 * s, transformation1.m21 * s);
                this.m_zHermite = new HermiteCubic(transformation0.m32, transformation1.m32, transformation0.m22 * s, transformation1.m22 * s);
            }
            super.prologue(t);
        }

        @Override
        public void update(double t) {
            super.update(t);
            if (this.m_value != null) {
                double portion = this.getPortion(t);
                double x = this.m_xHermite.evaluate(portion);
                double y = this.m_yHermite.evaluate(portion);
                double z = this.m_zHermite.evaluate(portion);
                this.m_value.setPositionRightNow(x, y, z, this.m_subject);
                Quaternion q = Quaternion.interpolate(this.m_quaternion0, this.m_quaternion1, this.getPortion(t));
                this.m_value.setOrientationRightNow(q, (ReferenceFrame)this.m_subject);
            }
        }

        @Override
        public void epilogue(double t) {
            super.epilogue(t);
            this.m_subject.setItem(this.m_value);
        }
    }
}

