/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.util;

import edu.cmu.cs.stage3.math.BezierCubic;
import edu.cmu.cs.stage3.math.BezierQuadratic;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class Polynomial {
    public static void evaluatePolynomial(edu.cmu.cs.stage3.math.Polynomial xPolynomial, edu.cmu.cs.stage3.math.Polynomial yPolynomial, double z, Point3d[] positions, Vector3d[] normals) {
        if (positions.length != normals.length) {
            throw new RuntimeException();
        }
        double dt = 1.0 / (double)(positions.length - 1);
        double t = 0.0;
        int i = 0;
        while (i < positions.length) {
            double xt = xPolynomial.evaluate(t);
            double yt = yPolynomial.evaluate(t);
            if (positions[i] == null) {
                positions[i] = new Point3d();
            }
            positions[i].x = xt;
            positions[i].y = yt;
            positions[i].z = z;
            double dxdt = xPolynomial.evaluateDerivative(t);
            double dydt = yPolynomial.evaluateDerivative(t);
            if (normals[i] == null) {
                normals[i] = new Vector3d();
            }
            normals[i].x = -dydt;
            normals[i].y = dxdt;
            normals[i].z = 0.0;
            t += dt;
            ++i;
        }
    }

    public static void evaluateBezierQuadratic(Point2d p0, Point2d p1, Point2d p2, double z, Point3d[] positions, Vector3d[] normals) {
        Polynomial.evaluatePolynomial(new BezierQuadratic(p0.x, p1.x, p2.x), new BezierQuadratic(p0.y, p1.y, p2.y), z, positions, normals);
    }

    public static void evaluateBezierCubic(Point2d p0, Point2d p1, Point2d p2, Point2d p3, double z, Point3d[] positions, Vector3d[] normals) {
        Polynomial.evaluatePolynomial(new BezierCubic(p0.x, p1.x, p2.x, p3.x), new BezierCubic(p0.y, p1.y, p2.y, p3.y), z, positions, normals);
    }
}

