/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.visualization;

import edu.cmu.cs.stage3.alice.core.Collection;
import edu.cmu.cs.stage3.alice.core.Geometry;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.TextureMap;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.Visualization;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.math.Box;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public abstract class CollectionOfModelsVisualization
extends Visualization {
    private Vector m_bins = new Vector();
    private Variable m_itemsVariable = null;
    private static final Font s_font = new Font("Serif", 0, 32);

    @Override
    public void unhook(Model model) {
        int i = this.indexOf(model, 0);
        if (i != -1) {
            this.set(i, null);
        }
    }

    protected String getItemsName() {
        return "items";
    }

    private Variable getItemsVariable() {
        if (this.m_itemsVariable == null) {
            this.m_itemsVariable = (Variable)this.getChildNamed(this.getItemsName());
        }
        return this.m_itemsVariable;
    }

    public Collection getItemsCollection() {
        return (Collection)this.getItemsVariable().value.getValue();
    }

    public Model[] getItems() {
        return (Model[])this.getItemsCollection().values.getArrayValue();
    }

    public void setItems(Model[] items) {
        this.getItemsCollection().values.set(items);
    }

    private Model getPrototype() {
        return (Model)this.getChildNamed("BinPrototype");
    }

    private int getBinCount() {
        return this.m_bins.size();
    }

    private Model getBinAt(int i) {
        return (Model)this.m_bins.get(i);
    }

    private void setBinAt(int i, Model bin) {
        if (this.m_bins.size() == i) {
            this.m_bins.addElement(bin);
        } else {
            if (this.m_bins.size() < i) {
                this.m_bins.ensureCapacity(i + 1);
            }
            this.m_bins.set(i, bin);
        }
    }

    private static TextureMap getEmptyTextureMap(Model bin) {
        return (TextureMap)bin.getChildNamed("EmptyTexture");
    }

    private static TextureMap getFilledTextureMap(Model bin) {
        return (TextureMap)bin.getChildNamed("FilledTexture");
    }

    private static void decorateTextureMap(TextureMap skin, int i) {
        Image originalImage;
        if (skin != null && (originalImage = skin.image.getImageValue()) instanceof BufferedImage) {
            BufferedImage originalBufferedImage = (BufferedImage)originalImage;
            BufferedImage image = new BufferedImage(originalBufferedImage.getWidth(), originalBufferedImage.getHeight(), 2);
            Graphics g = ((Image)image).getGraphics();
            g.drawImage(originalImage, 0, 0, null);
            g.setFont(s_font);
            String s = Integer.toString(i);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D r = fm.getStringBounds(s, g);
            g.setColor(Color.black);
            g.drawString(s, 80, (int)(20.0 - r.getX() + r.getHeight()));
            g.dispose();
            skin.image.set(image);
            skin.touchImage();
        }
    }

    private void synchronize(Model[] curr) {
        int binCount = this.getBinCount();
        int i = binCount - 1;
        while (i >= curr.length) {
            Model binI = this.getBinAt(i);
            binI.vehicle.set(null);
            this.m_bins.remove(binI);
            --i;
        }
        Model prototype = this.getPrototype();
        if (prototype != null) {
            int i2 = binCount;
            while (i2 < curr.length) {
                Class[] share = new Class[]{Geometry.class};
                String name = "Sub" + i2;
                Model binI = (Model)this.getChildNamed(name);
                if (binI == null) {
                    binI = (Model)prototype.HACK_createCopy(name, this, -1, share, null);
                    CollectionOfModelsVisualization.decorateTextureMap(CollectionOfModelsVisualization.getEmptyTextureMap(binI), i2);
                    CollectionOfModelsVisualization.decorateTextureMap(CollectionOfModelsVisualization.getFilledTextureMap(binI), i2);
                }
                this.setBinAt(i2, binI);
                ++i2;
            }
            binCount = this.getBinCount();
            i2 = 0;
            while (i2 < binCount) {
                Model binI = this.getBinAt(i2);
                binI.vehicle.set(this);
                binI.setPositionRightNow(-(prototype.getWidth() * (double)i2), 0.0, 0.0);
                if (curr[i2] != null) {
                    curr[i2].vehicle.set(binI);
                    curr[i2].visualization.set(this);
                    curr[i2].setTransformationRightNow(this.getTransformationFor(curr[i2], i2), this);
                    binI.diffuseColorMap.set(CollectionOfModelsVisualization.getFilledTextureMap(binI));
                } else {
                    binI.diffuseColorMap.set(CollectionOfModelsVisualization.getEmptyTextureMap(binI));
                }
                ++i2;
            }
            Model rightBracket = (Model)this.getChildNamed("RightBracket");
            if (rightBracket != null) {
                rightBracket.setPositionRightNow(-(prototype.getWidth() * ((double)binCount - 0.5)), 0.0, 0.0);
            }
        }
    }

    public Model get(int i) {
        return (Model)this.getItemsCollection().values.get(i);
    }

    public void set(int i, Model model) {
        this.getItemsCollection().values.set(i, model);
    }

    public int indexOf(Model model, int from) {
        return this.getItemsCollection().values.indexOf(model, from);
    }

    public int lastIndexOf(Model model, int from) {
        return this.getItemsCollection().values.lastIndexOf(model, from);
    }

    public boolean contains(Model model) {
        return this.getItemsCollection().values.contains(model);
    }

    public int size() {
        return this.getItemsCollection().values.size();
    }

    public boolean isEmpty() {
        return this.getItemsCollection().values.isEmpty();
    }

    @Override
    protected void loadCompleted() {
        super.loadCompleted();
        Collection collection = this.getItemsCollection();
        if (collection != null) {
            collection.values.addPropertyListener(new PropertyListener(){

                @Override
                public void propertyChanging(PropertyEvent propertyEvent) {
                }

                @Override
                public void propertyChanged(PropertyEvent propertyEvent) {
                    CollectionOfModelsVisualization.this.synchronize((Model[])propertyEvent.getValue());
                }
            });
            this.synchronize(this.getItems());
        } else {
            System.err.println("WARNING: collection is null " + this);
        }
    }

    public Matrix4d getTransformationFor(Model model, int i) {
        Box box;
        Vector3d v;
        Model prototype = this.getPrototype();
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        if (model != null && (v = (box = model.getBoundingBox()).getCenterOfBottomFace()) != null) {
            v.negate();
            m.m30 = v.x;
            m.m31 = v.y;
            m.m32 = v.z;
        }
        m.m30 -= prototype.getWidth() * (double)i;
        return m;
    }
}

