/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.visualization;

import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.TextureMap;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.Visualization;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.math.Box;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public class ModelVisualization
extends Visualization {
    private Variable m_itemVariable = null;

    @Override
    public void unhook(Model model) {
        if (this.getItem() == model) {
            this.setItem(null);
        }
    }

    private TextureMap getEmptyTextureMap() {
        return (TextureMap)this.getChildNamed("EmptyTexture");
    }

    private TextureMap getFilledTextureMap() {
        return (TextureMap)this.getChildNamed("FilledTexture");
    }

    private Variable getItemVariable() {
        if (this.m_itemVariable == null) {
            this.m_itemVariable = (Variable)this.getChildNamed("Item");
        }
        return this.m_itemVariable;
    }

    public Model getItem() {
        return (Model)this.getItemVariable().value.getValue();
    }

    public void setItem(Model value) {
        this.getItemVariable().value.set(value);
    }

    private void synchronize(Model curr) {
        Model prev = this.getItem();
        if (prev != null && prev != curr) {
            prev.visualization.set(null);
        }
        if (curr != null) {
            curr.setTransformationRightNow(this.getTransformationFor(curr), this);
            curr.vehicle.set((Object)this, true);
            curr.visualization.set(this);
            this.diffuseColorMap.set(this.getFilledTextureMap());
        } else {
            this.diffuseColorMap.set(this.getEmptyTextureMap());
        }
    }

    @Override
    protected void loadCompleted() {
        super.loadCompleted();
        Variable item = this.getItemVariable();
        if (item != null) {
            item.value.addPropertyListener(new PropertyListener(){

                @Override
                public void propertyChanging(PropertyEvent propertyEvent) {
                }

                @Override
                public void propertyChanged(PropertyEvent propertyEvent) {
                    ModelVisualization.this.synchronize((Model)propertyEvent.getValue());
                }
            });
            this.synchronize(this.getItem());
        }
    }

    public Matrix4d getTransformationFor(Model model) {
        Box box;
        Vector3d v;
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        if (model != null && (v = (box = model.getBoundingBox()).getCenterOfBottomFace()) != null) {
            v.negate();
            m.m30 = v.x;
            m.m31 = v.y;
            m.m32 = v.z;
        }
        return m;
    }
}

