/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.gallery;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.geometry.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.progress.ProgressCancelException;
import edu.cmu.cs.stage3.progress.ProgressObserver;
import edu.cmu.cs.stage3.util.HowMuch;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class ModelFixer {
    private static Vector3d getDirection(Vertex3d vertexA, Vertex3d vertexB, Vertex3d vertexC) {
        Vector3d ba = new Vector3d();
        Vector3d bc = new Vector3d();
        ba.sub((Tuple3d)vertexA.position, (Tuple3d)vertexB.position);
        bc.sub((Tuple3d)vertexC.position, (Tuple3d)vertexB.position);
        ba.normalize();
        bc.normalize();
        Vector3d result = new Vector3d();
        result.cross(bc, ba);
        return result;
    }

    private static Vector3d[] getCalculatedNormals(edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray indexedTriangleArray, ProgressObserver progressObserver) throws ProgressCancelException {
        Vector3d[] result = null;
        int triangleCount = indexedTriangleArray.getTriangleCount();
        if (triangleCount > 0) {
            Vertex3d[] vertices = indexedTriangleArray.getVertices();
            result = new Vector3d[vertices.length];
            int[] counts = new int[vertices.length];
            int i = 0;
            while (i < counts.length) {
                counts[i] = 0;
                result[i] = new Vector3d();
                ++i;
            }
            int[] indices = indexedTriangleArray.getIndices();
            if (progressObserver != null) {
                progressObserver.progressBegin(triangleCount);
            }
            int index = 0;
            int t = 0;
            while (t < triangleCount) {
                int a = indices[index++];
                int b = indices[index++];
                int c = indices[index++];
                Vector3d normal = ModelFixer.getDirection(vertices[a], vertices[b], vertices[c]);
                normal.normalize();
                result[a].add((Tuple3d)normal);
                result[b].add((Tuple3d)normal);
                result[c].add((Tuple3d)normal);
                int n = a;
                counts[n] = counts[n] + 1;
                int n2 = b;
                counts[n2] = counts[n2] + 1;
                int n3 = c;
                counts[n3] = counts[n3] + 1;
                if (progressObserver != null) {
                    progressObserver.progressUpdate(t, null);
                }
                ++t;
            }
            int i2 = 0;
            while (i2 < result.length) {
                result[i2].scale(1.0 / (double)counts[i2]);
                ++i2;
            }
        }
        return result;
    }

    public static void calculateNormals(IndexedTriangleArray ita, ProgressObserver progressObserver) throws ProgressCancelException {
        ita.setNormals(ModelFixer.getCalculatedNormals(ita.getSceneGraphIndexedTriangleArray(), progressObserver));
    }

    public static void calculateNormals(Element element, HowMuch howMuch, ProgressObserver macroProgressObserver, ProgressObserver microProgressObserver) throws ProgressCancelException {
        block9: {
            IndexedTriangleArray[] itas = (IndexedTriangleArray[])element.getDescendants(IndexedTriangleArray.class, howMuch);
            if (itas == null || itas.length <= 0) break block9;
            if (macroProgressObserver != null) {
                int i;
                macroProgressObserver.progressBegin(itas.length);
                Vector3d[][] normalsArray = new Vector3d[itas.length][];
                try {
                    i = 0;
                    while (i < itas.length) {
                        normalsArray[i] = ModelFixer.getCalculatedNormals(itas[i].getSceneGraphIndexedTriangleArray(), microProgressObserver);
                        ++i;
                    }
                }
                finally {
                    macroProgressObserver.progressEnd();
                }
                i = 0;
                while (i < itas.length) {
                    itas[i].setNormals(normalsArray[i]);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < itas.length) {
                    ModelFixer.calculateNormals(itas[i], microProgressObserver);
                    ++i;
                }
            }
        }
    }

    public static void calculateNormals(IndexedTriangleArray ita) {
        try {
            ModelFixer.calculateNormals(ita, null);
        }
        catch (ProgressCancelException pce) {
            throw new Error();
        }
    }

    public static void calculateNormals(Element element, HowMuch howMuch) {
        try {
            ModelFixer.calculateNormals(element, howMuch, null, null);
        }
        catch (ProgressCancelException pce) {
            throw new Error();
        }
    }
}

