/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.gallery.modeleditor;

import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.TextureMap;
import edu.cmu.cs.stage3.alice.core.util.IndexedTriangleArrayCounter;
import edu.cmu.cs.stage3.alice.gallery.modeleditor.IconManager;
import edu.cmu.cs.stage3.util.HowMuch;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class ElementTreeCellRenderer
extends DefaultTreeCellRenderer {
    ElementTreeCellRenderer() {
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.closedIcon = this.leafIcon = IconManager.lookupIcon(value);
        this.openIcon = this.leafIcon;
        Component component = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof TextureMap) {
            TextureMap tm = (TextureMap)value;
            BufferedImage image = (BufferedImage)tm.getSceneGraphTextureMap().getImage();
            StringBuffer sb = new StringBuffer();
            sb.append(image.getWidth());
            sb.append('x');
            sb.append(image.getHeight());
            this.setToolTipText(sb.toString());
        } else if (value instanceof Model) {
            Model model = (Model)value;
            IndexedTriangleArrayCounter itaCounter = new IndexedTriangleArrayCounter();
            model.visit(itaCounter, HowMuch.INSTANCE_AND_PARTS);
            StringBuffer sb = new StringBuffer();
            sb.append("vertices: ");
            sb.append(itaCounter.getVertexCount());
            sb.append("; triangles: ");
            sb.append(itaCounter.getIndexCount() / 3);
            this.setToolTipText(sb.toString());
        } else {
            this.setToolTipText(null);
        }
        return component;
    }
}

