/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.gallery.modeleditor;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.geometry.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.core.question.userdefined.Component;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class ElementTreeModel
implements TreeModel {
    private Element m_root;
    private Vector m_treeModelListeners = new Vector();

    ElementTreeModel() {
    }

    private Object[] getPath(Element element) {
        Vector<Element> v = new Vector<Element>();
        while (element != this.m_root.getParent()) {
            v.insertElementAt(element, 0);
            element = element.getParent();
        }
        return v.toArray();
    }

    private boolean isAccepted(Element e) {
        if (e instanceof IndexedTriangleArray) {
            return false;
        }
        if (e instanceof Response) {
            return e instanceof UserDefinedResponse;
        }
        return !(e instanceof Component);
    }

    private void fireTreeStructureChanged(Object[] path) {
        TreeModelEvent e = new TreeModelEvent((Object)this, path);
        Enumeration enum0 = this.m_treeModelListeners.elements();
        while (enum0.hasMoreElements()) {
            TreeModelListener l = (TreeModelListener)enum0.nextElement();
            l.treeStructureChanged(e);
        }
    }

    public void setRoot(Element root) {
        this.m_root = root;
        this.fireTreeStructureChanged(this.getPath(this.m_root));
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.m_treeModelListeners.addElement(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.m_treeModelListeners.removeElement(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        Element parentElement = (Element)parent;
        int i = 0;
        int lcv = 0;
        while (lcv < parentElement.getChildCount()) {
            Element childAtLCV = parentElement.getChildAt(lcv);
            if (this.isAccepted(childAtLCV)) {
                if (i == index) {
                    return childAtLCV;
                }
                ++i;
            }
            ++lcv;
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        Element parentElement = (Element)parent;
        int i = 0;
        int lcv = 0;
        while (lcv < parentElement.getChildCount()) {
            Element childAtLCV = parentElement.getChildAt(lcv);
            if (this.isAccepted(childAtLCV)) {
                ++i;
            }
            ++lcv;
        }
        return i;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        Element parentElement = (Element)parent;
        int i = 0;
        int lcv = 0;
        while (lcv < parentElement.getChildCount()) {
            Element childAtLCV = parentElement.getChildAt(lcv);
            if (childAtLCV == child) {
                return i;
            }
            if (this.isAccepted(childAtLCV)) {
                ++i;
            }
            ++lcv;
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.m_root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void removeDescendant(Element descendant) {
        Object[] path = this.getPath(descendant.getParent());
        descendant.removeFromParent();
        this.fireTreeStructureChanged(path);
    }
}

