/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.gallery.modeleditor;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Pose;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.UnresolvablePropertyReferencesException;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.camera.SymmetricPerspectiveCamera;
import edu.cmu.cs.stage3.alice.core.decorator.PivotDecorator;
import edu.cmu.cs.stage3.alice.core.light.DirectionalLight;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.alice.gallery.modeleditor.ElementTree;
import edu.cmu.cs.stage3.alice.gallery.modeleditor.ElementTreeCellEditor;
import edu.cmu.cs.stage3.alice.gallery.modeleditor.ElementTreeCellRenderer;
import edu.cmu.cs.stage3.alice.gallery.modeleditor.ElementTreeModel;
import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.DefaultRenderTargetFactory;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTargetFactory;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Sphere;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;

public class ModelEditor
extends JFrame {
    private World m_world;
    private SymmetricPerspectiveCamera m_camera;
    private RenderTarget m_renderTarget;
    private PivotDecorator m_pivotDecorator;
    private ElementTree m_tree;
    private ElementTreeModel m_treeModel;
    private int m_treeMouseEventModifiers = 0;
    private JButton m_prev;
    private JButton m_next;
    private JTextField m_modeledBy;
    private JTextField m_paintedBy;
    private JButton m_revert;
    private JCheckBox m_forceWireframe;
    private JFileChooser m_fileChooser;
    private File m_file;
    private boolean m_isDirty;

    public static void main(String[] args) {
        ModelEditor modelEditor = new ModelEditor();
        modelEditor.setLocation(0, 0);
        modelEditor.setSize(1280, 1000);
        DefaultRenderTargetFactory drtf = new DefaultRenderTargetFactory();
        modelEditor.init(drtf);
        if (args.length > 0) {
            modelEditor.onFileOpen(new File(args[0]));
        } else {
            modelEditor.onFileOpen();
        }
        modelEditor.setVisible(true);
        modelEditor.m_tree.requestFocus();
    }

    public ModelEditor() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ModelEditor.this.onFileExit();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenuItem fileOpenMenuItem = new JMenuItem("Open...");
        fileOpenMenuItem.setMnemonic(79);
        fileOpenMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelEditor.this.onFileOpen();
            }
        });
        JMenuItem fileSaveMenuItem = new JMenuItem("Save");
        fileSaveMenuItem.setMnemonic(83);
        fileSaveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelEditor.this.onFileSave();
            }
        });
        JMenuItem fileExitMenuItem = new JMenuItem("Exit...");
        fileExitMenuItem.setMnemonic(88);
        fileExitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelEditor.this.onFileExit();
            }
        });
        JMenu actionMenu = new JMenu("Action");
        actionMenu.setMnemonic(65);
        JMenuItem actionNextMenuItem = new JMenuItem("Next");
        actionNextMenuItem.setMnemonic(78);
        actionNextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelEditor.this.onNext();
            }
        });
        JMenuItem actionPrevMenuItem = new JMenuItem("Previous");
        actionPrevMenuItem.setMnemonic(80);
        actionPrevMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelEditor.this.onPrev();
            }
        });
        this.setJMenuBar(menuBar);
        menuBar.add(fileMenu);
        fileMenu.add(fileOpenMenuItem);
        fileMenu.add(fileSaveMenuItem);
        fileMenu.add(fileExitMenuItem);
        menuBar.add(actionMenu);
        actionMenu.add(actionNextMenuItem);
        actionMenu.add(actionPrevMenuItem);
        this.m_treeModel = new ElementTreeModel();
        this.m_treeModel.setRoot(new Model(){});
        this.m_tree = new ElementTree(this.m_treeModel);
        ElementTreeCellRenderer cellRenderer = new ElementTreeCellRenderer();
        final ElementTreeCellEditor cellEditor = new ElementTreeCellEditor((JTree)this.m_tree, cellRenderer);
        this.m_tree.setCellRenderer(cellRenderer);
        this.m_tree.setCellEditor(cellEditor);
        this.m_tree.setEditable(true);
        this.m_tree.setScrollsOnExpand(true);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this.m_tree);
        toolTipManager.setLightWeightPopupEnabled(false);
        cellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                Element element = (Element)ModelEditor.this.m_tree.getLastSelectedPathComponent();
                String nameValue = (String)cellEditor.getCellEditorValue();
                if (!element.name.getStringValue().equals(nameValue)) {
                    element.name.set(nameValue);
                    ModelEditor.this.setIsDirty(true);
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath treePath = e.getPath();
                ModelEditor.this.onSelect((Element)ModelEditor.this.m_tree.getLastSelectedPathComponent());
            }
        });
        this.m_tree.addMouseListener(new MouseAdapter(){
            private JPopupMenu m_popupMenu;
            private Element m_element;

            private void handlePopup(MouseEvent e) {
                if (this.m_popupMenu == null) {
                    this.m_popupMenu = new JPopupMenu();
                    JMenuItem menuItem = new JMenuItem("Delete");
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PropertyReference[] propertyReferences = ModelEditor.this.m_world.getPropertyReferencesTo(m_element);
                            if (propertyReferences.length > 0) {
                                StringBuffer sb = new StringBuffer();
                                sb.append("Cannot delete " + m_element.getTrimmedKey() + ".  The following properties reference it:\n");
                                int i = 0;
                                while (i < propertyReferences.length) {
                                    Property property = propertyReferences[i].getProperty();
                                    sb.append("    ");
                                    sb.append(property.getOwner().getTrimmedKey());
                                    sb.append('[');
                                    sb.append(property.getName());
                                    sb.append("] = ");
                                    Object value = property.getValue();
                                    if (value instanceof Element) {
                                        sb.append(((Element)value).getTrimmedKey());
                                    } else {
                                        sb.append(value);
                                    }
                                    sb.append('\n');
                                    ++i;
                                }
                                JOptionPane.showMessageDialog(ModelEditor.this, sb.toString());
                            } else {
                                int result = JOptionPane.showConfirmDialog(ModelEditor.this, "Would you like to delete: " + m_element.getTrimmedKey());
                                if (result == 0) {
                                    ModelEditor.this.m_treeModel.removeDescendant(m_element);
                                    ModelEditor.this.setIsDirty(true);
                                }
                            }
                            m_element = null;
                        }
                    });
                    this.m_popupMenu.add(menuItem);
                }
                TreePath path = ModelEditor.this.m_tree.getClosestPathForLocation(e.getX(), e.getY());
                this.m_element = (Element)path.getLastPathComponent();
                if (this.m_element != null) {
                    this.m_popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handlePopup(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ModelEditor.this.m_treeMouseEventModifiers = e.getModifiers();
                if (e.isPopupTrigger()) {
                    this.handlePopup(e);
                }
                ModelEditor.this.onSelect((Element)ModelEditor.this.m_tree.getLastSelectedPathComponent());
            }
        });
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setToggleClickCount(0);
        this.m_prev = new JButton();
        this.m_prev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelEditor.this.onPrev();
            }
        });
        this.m_next = new JButton();
        this.m_next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelEditor.this.onNext();
            }
        });
        this.m_modeledBy = new JTextField();
        this.m_modeledBy.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ModelEditor.this.onModeledByChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ModelEditor.this.onModeledByChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ModelEditor.this.onModeledByChange();
            }
        });
        this.m_paintedBy = new JTextField();
        this.m_paintedBy.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ModelEditor.this.onPaintedByChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ModelEditor.this.onPaintedByChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ModelEditor.this.onPaintedByChange();
            }
        });
        this.m_revert = new JButton("Revert");
        this.m_revert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelEditor.this.onRevert();
            }
        });
        this.m_revert.setEnabled(false);
        this.m_forceWireframe = new JCheckBox("Force Wireframe");
        this.m_forceWireframe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelEditor.this.onForceWireframe(ModelEditor.this.m_forceWireframe.isSelected());
            }
        });
        this.m_fileChooser = new JFileChooser();
    }

    public void init(RenderTargetFactory renderTargetFactory) {
        this.m_world = new World();
        this.m_world.atmosphereColor.set(new Color(0.75, 0.75, 1.0));
        this.m_world.ambientLightBrightness.set(new Double(0.2));
        this.m_renderTarget = new RenderTarget();
        this.m_renderTarget.commit(renderTargetFactory);
        class CameraOrbiter
        implements MouseListener,
        MouseMotionListener {
            private int m_prevX;

            CameraOrbiter() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                final int x = e.getX();
                final int y = e.getY();
                new Thread(){

                    @Override
                    public void run() {
                        PickInfo pickInfo = ModelEditor.this.m_renderTarget.pick(x, y, false, true);
                        if (pickInfo.getCount() > 0) {
                            System.err.println(pickInfo.getVisualAt(0).getBonus());
                        } else {
                            System.err.println("null");
                        }
                    }
                }.run();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.m_prevX = e.getX();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int x = e.getX();
                ModelEditor.this.m_camera.rotateRightNow(MathUtilities.getYAxis(), 0.001 * (double)(x - this.m_prevX), ModelEditor.this.getModel());
                this.m_prevX = x;
            }
        }
        CameraOrbiter cameraOrbiter = new CameraOrbiter();
        this.m_renderTarget.addMouseListener(cameraOrbiter);
        this.m_renderTarget.addMouseMotionListener(cameraOrbiter);
        DirectionalLight sun = new DirectionalLight();
        sun.vehicle.set(this.m_world);
        this.m_world.addChild(sun);
        sun.setOrientationRightNow(0.0, -1.0, 0.0, 0.0, 0.0, 1.0);
        this.m_camera = new SymmetricPerspectiveCamera();
        this.m_camera.verticalViewingAngle.set(new Double(0.5));
        this.m_camera.vehicle.set(this.m_world);
        this.m_camera.renderTarget.set(this.m_renderTarget);
        this.m_camera.name.set("Camera");
        this.m_world.addChild(this.m_camera);
        Model ground = new Model();
        ground.name.set("Ground");
        this.m_world.addChild(ground);
        this.m_pivotDecorator = new PivotDecorator();
        JPanel westPanel = new JPanel();
        westPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        westPanel.add((Component)this.m_prev, gbc);
        gbc.gridwidth = 0;
        westPanel.add((Component)this.m_next, gbc);
        gbc.weighty = 1.0;
        JScrollPane scrollPane = new JScrollPane(this.m_tree, 20, 30);
        westPanel.add((Component)scrollPane, gbc);
        gbc.weighty = 0.0;
        gbc.gridwidth = -1;
        westPanel.add((Component)new JLabel("modeled by: "), gbc);
        gbc.gridwidth = 0;
        westPanel.add((Component)this.m_modeledBy, gbc);
        gbc.gridwidth = -1;
        westPanel.add((Component)new JLabel("painted by: "), gbc);
        gbc.gridwidth = 0;
        westPanel.add((Component)this.m_paintedBy, gbc);
        gbc.gridwidth = 0;
        westPanel.add((Component)this.m_revert, gbc);
        westPanel.add((Component)this.m_forceWireframe, gbc);
        JSplitPane splitPane = new JSplitPane(1, westPanel, this.m_renderTarget.getAWTComponent());
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(splitPane);
    }

    public void setIsDirty(boolean isDirty) {
        if (this.m_isDirty != isDirty) {
            this.m_isDirty = isDirty;
            this.m_revert.setEnabled(this.m_isDirty);
            this.updateTitle();
        }
    }

    public Model getModel() {
        return (Model)this.m_treeModel.getRoot();
    }

    private void expandTree() {
        int i = 0;
        while (i < this.m_tree.getRowCount()) {
            this.m_tree.expandRow(i);
            ++i;
        }
        this.m_tree.invalidate();
    }

    private void releasePreviousModel() {
        Model prevModel = this.getModel();
        if (prevModel != null) {
            prevModel.vehicle.set(null);
            prevModel.setParent(null);
        }
    }

    public void setModel(Model model) {
        this.m_treeMouseEventModifiers = 0;
        this.m_treeModel.setRoot(model);
        this.expandTree();
        this.m_tree.setSelectionInterval(0, 0);
        this.m_tree.requestFocus();
        if (model != null) {
            model.setParent(this.m_world);
            model.vehicle.set(this.m_world);
            this.m_camera.getAGoodLookAtRightNow(model);
            Sphere sphere = model.getBoundingSphere();
            double radius = sphere.getRadius();
            this.m_camera.nearClippingPlaneDistance.set(new Double(0.1));
            this.m_camera.farClippingPlaneDistance.set(new Double(radius * 2.0 + this.m_camera.getDistanceTo(model)));
            this.m_camera.moveRightNow(0.0, 0.0, -this.m_camera.nearClippingPlaneDistance.doubleValue());
            String modeledBy = (String)model.data.get("modeled by");
            if (modeledBy != null) {
                this.m_modeledBy.setText(modeledBy);
            } else {
                this.m_modeledBy.setText("");
            }
            String paintedBy = (String)model.data.get("painted by");
            if (paintedBy != null) {
                this.m_paintedBy.setText(paintedBy);
            } else {
                this.m_paintedBy.setText("");
            }
            this.onForceWireframe(this.m_forceWireframe.isSelected());
        } else {
            this.m_modeledBy.setText("");
            this.m_paintedBy.setText("");
        }
    }

    private boolean isContinueAppropriateAfterCheckingForSave() {
        if (this.m_isDirty) {
            int option = JOptionPane.showConfirmDialog(this, "Changes have been made.  Would you like to save before continuing?", "Check for save", 1, -1);
            switch (option) {
                case 0: {
                    this.onFileSave();
                    return true;
                }
                case 1: {
                    return true;
                }
                case -1: 
                case 2: {
                    return false;
                }
            }
            throw new Error();
        }
        return true;
    }

    private void updateTitle() {
        StringBuffer sb = new StringBuffer("Model editor: ");
        if (this.m_isDirty) {
            sb.append("*");
        }
        sb.append(this.m_file.getPath());
        this.setTitle(sb.toString());
    }

    private File[] getSiblingFiles() {
        File directory = this.m_file.getParentFile();
        return directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".a2c");
            }
        });
    }

    private void setFile(File file) {
        this.m_file = file;
        this.updateTitle();
        File[] siblingFiles = this.getSiblingFiles();
        int n = siblingFiles.length;
        int i = 0;
        while (i < n) {
            if (siblingFiles[i].equals(this.m_file)) {
                if (i == 0) {
                    this.m_prev.setEnabled(false);
                    this.m_prev.setText("<< { None }");
                } else {
                    this.m_prev.setEnabled(true);
                    this.m_prev.setText("<< " + siblingFiles[i - 1].getName());
                    this.m_prev.setActionCommand(siblingFiles[i - 1].getPath());
                }
                if (i == n - 1) {
                    this.m_next.setEnabled(false);
                    this.m_next.setText("{ None } >>");
                } else {
                    this.m_next.setEnabled(true);
                    this.m_next.setText(String.valueOf(siblingFiles[i + 1].getName()) + " >>");
                    this.m_next.setActionCommand(siblingFiles[i + 1].getPath());
                }
            }
            ++i;
        }
    }

    private void onPrev() {
        if (this.isContinueAppropriateAfterCheckingForSave()) {
            this.open(new File(this.m_prev.getActionCommand()));
        }
    }

    private void onNext() {
        if (this.isContinueAppropriateAfterCheckingForSave()) {
            this.open(new File(this.m_next.getActionCommand()));
        }
    }

    private void onRevert() {
        this.open(this.m_file);
    }

    private void onModeledByChange() {
        this.getModel().data.put("modeled by", this.m_modeledBy.getText());
        this.setIsDirty(true);
    }

    private void onPaintedByChange() {
        this.getModel().data.put("painted by", this.m_paintedBy.getText());
        this.setIsDirty(true);
    }

    private void negativeAppearance(Model model) {
        Appearance sgAppearance = model.getSceneGraphAppearance();
        sgAppearance.setShadingStyle(ShadingStyle.SMOOTH);
        sgAppearance.setOpacity(0.25);
        int i = 0;
        while (i < model.parts.size()) {
            this.negativeAppearance((Model)model.parts.get(i));
            ++i;
        }
    }

    private void positiveAppearance(Model model) {
        Appearance sgAppearance = model.getSceneGraphAppearance();
        TextureMap sgTextureMap = null;
        if (model.diffuseColorMap.getTextureMapValue() != null) {
            sgTextureMap = model.diffuseColorMap.getTextureMapValue().getSceneGraphTextureMap();
        }
        sgAppearance.setDiffuseColorMap(sgTextureMap);
        sgAppearance.setShadingStyle(model.shadingStyle.getShadingStyleValue());
        sgAppearance.setOpacity(model.opacity.doubleValue());
        int i = 0;
        while (i < model.parts.size()) {
            this.positiveAppearance((Model)model.parts.get(i));
            ++i;
        }
    }

    private void textureMapAppearance(Model model, edu.cmu.cs.stage3.alice.core.TextureMap textureMap) {
        Appearance sgAppearance = model.getSceneGraphAppearance();
        if ((this.m_treeMouseEventModifiers & 2) != 0) {
            sgAppearance.setDiffuseColorMap(textureMap.getSceneGraphTextureMap());
        } else if (model.diffuseColorMap.get() != textureMap) {
            sgAppearance.setDiffuseColorMap(null);
        }
        int i = 0;
        while (i < model.parts.size()) {
            this.textureMapAppearance((Model)model.parts.get(i), textureMap);
            ++i;
        }
    }

    private void onSelect(Element element) {
        this.positiveAppearance(this.getModel());
        if (element instanceof Model) {
            if (this.getModel() != element) {
                this.negativeAppearance(this.getModel());
                this.positiveAppearance((Model)element);
            }
            this.m_pivotDecorator.setTransformable((Model)element);
        } else if (element instanceof edu.cmu.cs.stage3.alice.core.TextureMap) {
            this.textureMapAppearance(this.getModel(), (edu.cmu.cs.stage3.alice.core.TextureMap)element);
        }
        this.m_pivotDecorator.setIsShowing(element instanceof Model);
    }

    private void onForceWireframe(Model model, boolean forceWireframe) {
        Appearance sgAppearance = model.getSceneGraphAppearance();
        FillingStyle fillingStyle = forceWireframe ? FillingStyle.WIREFRAME : model.fillingStyle.getFillingStyleValue();
        sgAppearance.setFillingStyle(fillingStyle);
        int i = 0;
        while (i < model.parts.size()) {
            this.onForceWireframe((Model)model.parts.get(i), forceWireframe);
            ++i;
        }
    }

    private void onForceWireframe(boolean forceWireframe) {
        this.onForceWireframe(this.getModel(), forceWireframe);
    }

    /*
     * Unable to fully structure code
     */
    private void open(File file) {
        block4: {
            this.setFile(file);
            try {
                this.releasePreviousModel();
                model = (Model)Element.load(file, (Element)this.m_world);
                this.setModel(model);
                this.hardenPoses();
                this.setIsDirty(false);
            }
            catch (UnresolvablePropertyReferencesException upre) {
                propertyReferences = upre.getPropertyReferences();
                i = 0;
                ** while (i < propertyReferences.length)
            }
lbl-1000:
            // 1 sources

            {
                System.err.println(propertyReferences[i]);
                ++i;
                continue;
lbl16:
                // 1 sources

                break block4;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void onFileOpen() {
        this.onFileOpen(null);
    }

    private void onFileOpen(File file) {
        if (file == null) {
            if (this.m_file != null) {
                this.m_fileChooser.setCurrentDirectory(this.m_file.getParentFile());
            }
        } else if (file.isDirectory()) {
            this.m_fileChooser.setCurrentDirectory(file);
        } else {
            this.open(file);
            return;
        }
        this.m_fileChooser.setDialogType(0);
        this.m_fileChooser.setFileSelectionMode(0);
        this.m_fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".a2c");
            }

            @Override
            public String getDescription() {
                return "Alice Character (*.a2c)";
            }
        });
        this.m_fileChooser.setPreferredSize(new Dimension(500, 300));
        this.m_fileChooser.rescanCurrentDirectory();
        if (this.m_fileChooser.showDialog(this, null) == 0) {
            this.open(this.m_fileChooser.getSelectedFile());
        }
        this.m_tree.requestFocus();
    }

    private void onFileSave() {
        try {
            this.softenPoses();
            this.getModel().store(this.m_file);
            this.setIsDirty(false);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void onFileExit() {
        if (this.isContinueAppropriateAfterCheckingForSave()) {
            System.exit(0);
        }
    }

    private void hardenPoses() {
        Pose[] poses = (Pose[])this.getModel().getDescendants(Pose.class);
        int i = 0;
        while (i < poses.length) {
            poses[i].HACK_harden();
            ++i;
        }
    }

    private void softenPoses() {
        Pose[] poses = (Pose[])this.getModel().getDescendants(Pose.class);
        int i = 0;
        while (i < poses.length) {
            poses[i].HACK_soften();
            ++i;
        }
    }
}

