/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.moviemaker;

import edu.cmu.cs.stage3.alice.core.Clock;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.clock.FixedFrameRateClock;
import edu.cmu.cs.stage3.alice.player.DefaultPlayer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RenderTargetEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RenderTargetListener;
import edu.cmu.cs.stage3.image.ImageIO;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class MovieMaker
extends DefaultPlayer {
    private String m_directoryPath;
    private String m_fileName;
    private NumberFormat m_numberFormat;
    private String m_extension;
    private int m_index;

    public MovieMaker(Class rendererClass, String directoryPath, String fileName, String localizedPattern, String extension) {
        super(rendererClass);
        this.m_directoryPath = directoryPath;
        this.m_fileName = fileName;
        this.m_numberFormat = NumberFormat.getInstance();
        if (this.m_numberFormat instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)this.m_numberFormat;
            df.applyLocalizedPattern(localizedPattern);
        }
        this.m_extension = extension;
        this.m_index = 0;
    }

    @Override
    protected Clock newClock() {
        return new FixedFrameRateClock(30);
    }

    @Override
    protected int getDesiredFrameWidth() {
        return 648;
    }

    @Override
    protected int getDesiredFrameHeight() {
        return 514;
    }

    private void getPathForIndex(StringBuffer sb, int index) {
        sb.append(this.m_directoryPath);
        sb.append(File.separatorChar);
        sb.append(this.m_fileName);
        sb.append(this.m_numberFormat.format(index));
        sb.append(".");
        sb.append(this.m_extension);
    }

    public String getPathForIndex(int index) {
        StringBuffer sb = new StringBuffer();
        this.getPathForIndex(sb, index);
        return sb.toString();
    }

    @Override
    protected void handleRenderTarget(RenderTarget renderTarget) {
        super.handleRenderTarget(renderTarget);
        renderTarget.addRenderTargetListener(new RenderTargetListener(){
            private int m_index = 0;

            @Override
            public void cleared(RenderTargetEvent renderTargetEvent) {
            }

            @Override
            public void rendered(RenderTargetEvent renderTargetEvent) {
                Image image = renderTargetEvent.getRenderTarget().getOffscreenImage();
                String path = MovieMaker.this.getPathForIndex(this.m_index++);
                try {
                    ImageObserver observer = new ImageObserver(){

                        @Override
                        public boolean imageUpdate(Image arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
                            return false;
                        }
                    };
                    BufferedImage bi = new BufferedImage(image.getWidth(observer), image.getHeight(observer), 5);
                    bi.getGraphics().drawImage(image, 0, 0, observer);
                    ImageIO.store("bmp", new FileOutputStream(path), bi);
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                System.err.println(image);
            }
        });
    }
}

