/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.player;

import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.player.AbstractPlayer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.directx7renderer.Renderer;
import edu.cmu.cs.stage3.progress.ProgressCancelException;
import edu.cmu.cs.stage3.progress.ProgressObserver;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalSliderUI;

public class DefaultPlayer
extends AbstractPlayer {
    public static Class rendererClass = null;
    public static DefaultPlayer player = new DefaultPlayer(rendererClass);
    private Vector m_frames = new Vector();
    private JButton m_pauseButton = new JButton("pause");
    private JButton m_resumeButton = new JButton("resume");
    private JButton m_startButton = new JButton("restart");
    private JButton m_stopButton = new JButton("stop");
    private JSlider speedSlider;
    private JLabel speedLabel;

    public DefaultPlayer(Class rendererClass) {
        super(rendererClass);
    }

    @Override
    protected boolean isPreserveAndRestoreRequired() {
        return true;
    }

    protected int getDesiredFrameWidth() {
        return 800;
    }

    protected int getDesiredFrameHeight() {
        return 600;
    }

    public void updateSpeed(double newSpeed) {
        player.setSpeed(newSpeed);
        String speedText = NumberFormat.getInstance().format(newSpeed);
        if (newSpeed < 1.0) {
            if (newSpeed == 0.5) {
                speedText = "1/2";
            } else if (newSpeed == 0.25) {
                speedText = "1/4";
            } else if (newSpeed == 0.2) {
                speedText = "1/5";
            } else if (newSpeed > 0.3 && newSpeed < 0.34) {
                speedText = "1/3";
            } else if (newSpeed > 0.16 && newSpeed < 0.168) {
                speedText = "1/6";
            } else if (newSpeed > 0.14 && newSpeed < 0.143) {
                speedText = "1/7";
            }
        }
        this.speedLabel.setText(" Speed: " + speedText + "x");
        this.speedLabel.repaint();
    }

    @Override
    protected void handleRenderTarget(RenderTarget renderTarget) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        this.m_pauseButton.setEnabled(true);
        this.m_resumeButton.setEnabled(false);
        this.m_startButton.setEnabled(true);
        this.m_stopButton.setEnabled(true);
        this.speedLabel = new JLabel("  Speed: 1x    ");
        this.speedLabel.setFont(new Font("SansSerif", 1, 12));
        this.speedLabel.setSize(new Dimension(100, 12));
        this.speedSlider = new JSlider(0, 9, 0);
        this.speedSlider.setUI(new MetalSliderUI(){

            @Override
            public void paintTrack(Graphics g) {
                super.paintTrack(g);
            }
        });
        this.speedSlider.setSnapToTicks(true);
        this.speedSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                JSlider s = (JSlider)ce.getSource();
                int value = s.getValue();
                if (value >= 0) {
                    DefaultPlayer.this.updateSpeed((double)value + 1.0);
                } else if (value < 0) {
                    DefaultPlayer.this.updateSpeed(1.0 / (double)(1 + value * -1));
                }
            }
        });
        buttonPanel.add(this.speedLabel);
        buttonPanel.add(this.speedSlider);
        buttonPanel.add(this.m_pauseButton);
        buttonPanel.add(this.m_resumeButton);
        buttonPanel.add(this.m_startButton);
        buttonPanel.add(this.m_stopButton);
        Frame frame = new Frame("Alice .a2w player");
        frame.setSize(this.getDesiredFrameWidth(), this.getDesiredFrameHeight());
        frame.setLayout(new BorderLayout());
        frame.add((Component)buttonPanel, "North");
        frame.add(renderTarget.getAWTComponent(), "Center");
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                DefaultPlayer.this.m_frames.removeElement(ev.getSource());
                if (DefaultPlayer.this.m_frames.size() == 0) {
                    System.exit(0);
                }
            }
        });
        this.m_pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultPlayer.this.m_pauseButton.setEnabled(false);
                DefaultPlayer.this.m_resumeButton.setEnabled(true);
                player.pauseWorld();
            }
        });
        this.m_resumeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultPlayer.this.m_pauseButton.setEnabled(true);
                DefaultPlayer.this.m_resumeButton.setEnabled(false);
                player.resumeWorld();
            }
        });
        this.m_stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultPlayer.this.m_startButton.setText("start");
                DefaultPlayer.this.m_pauseButton.setEnabled(false);
                DefaultPlayer.this.m_stopButton.setEnabled(false);
                DefaultPlayer.this.m_resumeButton.setEnabled(false);
                player.stopWorld();
            }
        });
        this.m_startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                player.stopWorldIfNecessary();
                DefaultPlayer.this.m_startButton.setText("restart");
                DefaultPlayer.this.m_pauseButton.setEnabled(true);
                DefaultPlayer.this.m_stopButton.setEnabled(true);
                DefaultPlayer.this.m_resumeButton.setEnabled(false);
                player.startWorld();
            }
        });
        this.m_frames.add(frame);
        DialogManager.initialize(frame);
    }

    private static File getFileFromArgs(String[] args, int startFrom) {
        File file = null;
        String path = "";
        int i = startFrom;
        while (i < args.length) {
            path = String.valueOf(path) + args[i];
            ++i;
            file = new File(path);
            if (file.exists()) break;
            path = String.valueOf(path) + " ";
            file = null;
        }
        return file;
    }

    public static void main(String[] args) throws URISyntaxException {
        File file = null;
        if (args.length > 0) {
            int startFrom = 1;
            if (args[0].equals("-directx")) {
                rendererClass = Renderer.class;
            } else if (args[0].equals("-jogl")) {
                rendererClass = edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.Renderer.class;
            } else if (args[0].equals("-null")) {
                rendererClass = edu.cmu.cs.stage3.alice.scenegraph.renderer.nullrenderer.Renderer.class;
            } else {
                System.err.println(args[0]);
                startFrom = 0;
            }
            file = DefaultPlayer.getFileFromArgs(args, startFrom);
        }
        if (file == null) {
            String temp = player.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().toString();
            file = new File(temp = String.valueOf(temp.substring(5, temp.lastIndexOf("."))) + ".a2w");
            if (!file.exists()) {
                Frame frame = new Frame();
                FileDialog fd = new FileDialog(frame);
                fd.setVisible(true);
                if (fd.getDirectory() != null && fd.getFile() != null) {
                    file = new File(String.valueOf(fd.getDirectory()) + fd.getFile());
                }
                frame.dispose();
            }
        }
        try {
            player.loadWorld(file, new ProgressObserver(){
                private int i = 0;
                private int n = 80;
                private int m_total = -1;

                @Override
                public void progressBegin(int total) {
                    this.progressUpdateTotal(total);
                }

                @Override
                public void progressUpdateTotal(int total) {
                    this.m_total = total;
                }

                @Override
                public void progressUpdate(int current, String description) throws ProgressCancelException {
                    if (this.m_total == -1) {
                        System.out.print("?");
                    } else if (this.i < (int)((double)current / (double)this.m_total * (double)this.n)) {
                        System.out.print(".");
                        ++this.i;
                    }
                }

                @Override
                public void progressEnd() {
                }
            });
            player.startWorld();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

