/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.player;

import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.player.AbstractPlayer;
import edu.cmu.cs.stage3.progress.ProgressCancelException;
import edu.cmu.cs.stage3.progress.ProgressObserver;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.vecmath.Matrix4d;

public class PlayerApplet
extends Applet {
    private AbstractPlayer m_player = new AbstractPlayer(){

        @Override
        protected boolean isPreserveAndRestoreRequired() {
            return true;
        }

        @Override
        protected void handleRenderTarget(RenderTarget renderTarget) {
            PlayerApplet.this.handleRenderTarget(renderTarget);
        }
    };
    private JButton m_pauseButton = new JButton("pause");
    private JButton m_resumeButton = new JButton("resume");
    private JButton m_startButton = new JButton("restart");
    private JButton m_stopButton = new JButton("stop");
    private ProgressPanel m_progressPanel;
    private Runnable m_loadRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                Class<Matrix4d> clazz = Matrix4d.class;
            }
            catch (Throwable t) {
                PlayerApplet.this.remove(PlayerApplet.this.m_progressPanel);
                String initErrorMessage = PlayerApplet.this.getParameter("initializationErrorMessage");
                initErrorMessage = null;
                if (initErrorMessage == null) {
                    initErrorMessage = "Alice is unable to initialize.\n\nPlease click the link below.";
                }
                JTextArea errorTextArea = new JTextArea();
                errorTextArea.setText(initErrorMessage);
                PlayerApplet.this.add(errorTextArea);
                return;
            }
            try {
                byte[] content;
                URL url = this.getClass().getResource("My_Alice_World.a2w");
                URLConnection urlConnection = url.openConnection();
                InputStream is = urlConnection.getInputStream();
                int contentLength = urlConnection.getContentLength();
                PlayerApplet.this.m_progressPanel.setDownloadTotal(contentLength);
                int bufferLength = 2048;
                if (contentLength != -1) {
                    int offset = 0;
                    content = new byte[contentLength];
                    while (offset < contentLength) {
                        int actual = is.read(content, offset, Math.min(2048, contentLength - offset));
                        PlayerApplet.this.m_progressPanel.setDownloadCurrent(offset += actual);
                    }
                } else {
                    int actual;
                    byte[] buffer = new byte[2048];
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
                    while ((actual = is.read(buffer, 0, 2048)) != -1) {
                        baos.write(buffer, 0, actual);
                    }
                    content = baos.toByteArray();
                }
                is.close();
                urlConnection = null;
                ByteArrayInputStream bais = new ByteArrayInputStream(content);
                PlayerApplet.this.m_player.loadWorld(bais, new ProgressObserver(){

                    @Override
                    public void progressBegin(int total) {
                        this.progressUpdateTotal(total);
                    }

                    @Override
                    public void progressUpdateTotal(int total) {
                        PlayerApplet.this.m_progressPanel.setExtractTotal(total);
                    }

                    @Override
                    public void progressUpdate(int current, String description) throws ProgressCancelException {
                        PlayerApplet.this.m_progressPanel.setExtractCurrent(current);
                    }

                    @Override
                    public void progressEnd() {
                    }
                });
                PlayerApplet.this.m_startButton.setEnabled(true);
                PlayerApplet.this.startWorld();
            }
            catch (MalformedURLException murle) {
                murle.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    };

    private Color decodeColorParam(String name, Color valueIfNull) {
        String value = this.getParameter(name);
        if (value != null) {
            return Color.decode(value);
        }
        return valueIfNull;
    }

    private void startWorld() {
        this.m_player.stopWorldIfNecessary();
        this.m_startButton.setText("restart");
        this.m_pauseButton.setEnabled(true);
        this.m_stopButton.setEnabled(true);
        this.m_resumeButton.setEnabled(false);
        this.m_player.startWorld();
    }

    private void stopWorld() {
        this.m_startButton.setText("start");
        this.m_pauseButton.setEnabled(false);
        this.m_stopButton.setEnabled(false);
        this.m_resumeButton.setEnabled(false);
        this.m_player.stopWorld();
    }

    private void pauseWorld() {
        this.m_pauseButton.setEnabled(false);
        this.m_resumeButton.setEnabled(true);
        this.m_player.pauseWorld();
    }

    private void resumeWorld() {
        this.m_pauseButton.setEnabled(true);
        this.m_resumeButton.setEnabled(false);
        this.m_player.resumeWorld();
    }

    @Override
    public void init() {
        super.init();
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 4));
        this.m_pauseButton.setEnabled(false);
        this.m_resumeButton.setEnabled(false);
        this.m_startButton.setEnabled(false);
        this.m_stopButton.setEnabled(false);
        panel.add(this.m_pauseButton);
        panel.add(this.m_resumeButton);
        panel.add(this.m_startButton);
        panel.add(this.m_stopButton);
        this.add((Component)panel, "North");
        this.m_progressPanel = new ProgressPanel();
        this.add((Component)this.m_progressPanel, "Center");
        this.m_pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerApplet.this.pauseWorld();
            }
        });
        this.m_resumeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerApplet.this.resumeWorld();
            }
        });
        this.m_stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerApplet.this.stopWorld();
            }
        });
        this.m_startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerApplet.this.startWorld();
            }
        });
    }

    @Override
    public void start() {
        super.start();
        new Thread(this.m_loadRunnable).start();
    }

    @Override
    public void stop() {
        this.m_player.stopWorldIfNecessary();
        this.m_player.unloadWorld();
        super.stop();
    }

    protected void handleRenderTarget(RenderTarget renderTarget) {
        this.remove(this.m_progressPanel);
        this.add(renderTarget.getInternal().getAWTComponent(), "Center");
        this.doLayout();
        this.invalidate();
        this.repaint();
    }

    private class ProgressPanel
    extends Panel {
        private String m_worldName;
        private JProgressBar m_downloadProgressBar;
        private JProgressBar m_extractProgressBar;

        public ProgressPanel() {
            this.m_worldName = PlayerApplet.this.getParameter("world");
            this.setLayout(null);
            this.setForeground(PlayerApplet.this.decodeColorParam("boxfgcolor", Color.black));
            this.setBackground(PlayerApplet.this.decodeColorParam("boxbgcolor", Color.white));
            Color progressColor = PlayerApplet.this.decodeColorParam("progresscolor", Color.blue);
            String s = PlayerApplet.this.getParameter("WIDTH");
            int width = s != null ? Integer.parseInt(s) : 320;
            this.m_downloadProgressBar = new JProgressBar();
            this.m_downloadProgressBar.setLocation(40, 80);
            this.m_downloadProgressBar.setSize(width - 80, 32);
            this.m_downloadProgressBar.setString("downloading...");
            this.m_downloadProgressBar.setStringPainted(true);
            this.add(this.m_downloadProgressBar);
            this.m_extractProgressBar = new JProgressBar();
            this.m_extractProgressBar.setLocation(40, 120);
            this.m_extractProgressBar.setSize(width - 80, 32);
            this.m_extractProgressBar.setString("extracting...");
            this.m_extractProgressBar.setStringPainted(true);
            this.add(this.m_extractProgressBar);
        }

        public void setDownloadCurrent(int downloadCurrent) {
            this.m_downloadProgressBar.setValue(downloadCurrent);
        }

        public void setDownloadTotal(int downloadTotal) {
            this.m_downloadProgressBar.setMaximum(downloadTotal);
        }

        public void setExtractCurrent(int extractCurrent) {
            this.m_extractProgressBar.setValue(extractCurrent);
        }

        public void setExtractTotal(int extractTotal) {
            this.m_extractProgressBar.setMaximum(extractTotal);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.drawString("Alice world: " + this.m_worldName, 20, 40);
        }
    }
}

