/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.lang.Messages;

public class Appearance
extends Element {
    public static final Property AMBIENT_COLOR_PROPERTY = new Property(Appearance.class, "AMBIENT_COLOR");
    public static final Property DIFFUSE_COLOR_PROPERTY = new Property(Appearance.class, "DIFFUSE_COLOR");
    public static final Property FILLING_STYLE_PROPERTY = new Property(Appearance.class, "FILLING_STYLE");
    public static final Property SHADING_STYLE_PROPERTY = new Property(Appearance.class, "SHADING_STYLE");
    public static final Property OPACITY_PROPERTY = new Property(Appearance.class, "OPACITY");
    public static final Property SPECULAR_HIGHLIGHT_COLOR_PROPERTY = new Property(Appearance.class, "SPECULAR_HIGHLIGHT_COLOR");
    public static final Property SPECULAR_HIGHLIGHT_EXPONENT_PROPERTY = new Property(Appearance.class, "SPECULAR_HIGHLIGHT_EXPONENT");
    public static final Property EMISSIVE_COLOR_PROPERTY = new Property(Appearance.class, "EMISSIVE_COLOR");
    public static final Property DIFFUSE_COLOR_MAP_PROPERTY = new Property(Appearance.class, "DIFFUSE_COLOR_MAP");
    public static final Property OPACITY_MAP_PROPERTY = new Property(Appearance.class, "OPACITY_MAP");
    public static final Property EMISSIVE_COLOR_MAP_PROPERTY = new Property(Appearance.class, "EMISSIVE_COLOR_MAP");
    public static final Property SPECULAR_HIGHLIGHT_COLOR_MAP_PROPERTY = new Property(Appearance.class, "SPECULAR_HIGHLIGHT_COLOR_MAP");
    public static final Property BUMP_MAP_PROPERTY = new Property(Appearance.class, "BUMP_MAP");
    public static final Property DETAIL_MAP_PROPERTY = new Property(Appearance.class, "DETAIL_MAP");
    private Color m_ambientColor = null;
    private Color m_diffuseColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private FillingStyle m_fillingStyle = FillingStyle.SOLID;
    private ShadingStyle m_shadingStyle = ShadingStyle.SMOOTH;
    private double m_opacity = 1.0;
    private Color m_specularHighlightColor = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    private double m_specularHighlightExponent = 0.0;
    private Color m_emissiveColor = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    private TextureMap m_diffuseColorMap = null;
    private TextureMap m_opacityMap = null;
    private TextureMap m_emissiveColorMap = null;
    private TextureMap m_specularHighlightColorMap = null;
    private TextureMap m_bumpMap = null;
    private TextureMap m_detailMap = null;

    @Override
    protected void releasePass1() {
        if (this.m_diffuseColorMap != null) {
            Appearance.warnln(String.valueOf(Messages.getString("WARNING__released_appearence_")) + this + " " + Messages.getString("still_has_diffuse_color_map_") + this.m_diffuseColorMap + ".");
            this.setDiffuseColorMap(null);
        }
        if (this.m_opacityMap != null) {
            Appearance.warnln(String.valueOf(Messages.getString("WARNING__released_appearence_")) + this + " " + Messages.getString("still_has_opacity_map_") + this.m_opacityMap + ".");
            this.setOpacityMap(null);
        }
        if (this.m_emissiveColorMap != null) {
            Appearance.warnln(String.valueOf(Messages.getString("WARNING__released_appearence_")) + this + " " + Messages.getString("still_has_emissive_color_map_") + this.m_emissiveColorMap + ".");
            this.setEmissiveColorMap(null);
        }
        if (this.m_specularHighlightColorMap != null) {
            Appearance.warnln(String.valueOf(Messages.getString("WARNING__released_appearence_")) + this + " " + Messages.getString("still_has_specular_highlight_color_map_") + this.m_specularHighlightColorMap + ".");
            this.setSpecularHighlightColorMap(null);
        }
        if (this.m_bumpMap != null) {
            Appearance.warnln(String.valueOf(Messages.getString("WARNING__released_appearence_")) + this + " " + Messages.getString("still_has_bump_map_") + this.m_bumpMap + ".");
            this.setBumpMap(null);
        }
        if (this.m_detailMap != null) {
            Appearance.warnln(String.valueOf(Messages.getString("WARNING__released_appearence_")) + this + " " + Messages.getString("still_has_detail_map_") + this.m_detailMap + ".");
            this.setDetailMap(null);
        }
        super.releasePass1();
    }

    public Color getAmbientColor() {
        return this.m_ambientColor;
    }

    public void setAmbientColor(Color ambientColor) {
        if (Appearance.notequal(this.m_ambientColor, ambientColor)) {
            this.m_ambientColor = ambientColor;
            this.onPropertyChange(AMBIENT_COLOR_PROPERTY);
        }
    }

    public Color getDiffuseColor() {
        return this.m_diffuseColor;
    }

    public void setDiffuseColor(Color diffuseColor) {
        if (Appearance.notequal(this.m_diffuseColor, diffuseColor)) {
            this.m_diffuseColor = diffuseColor;
            this.onPropertyChange(DIFFUSE_COLOR_PROPERTY);
        }
    }

    public double getOpacity() {
        return this.m_opacity;
    }

    public void setOpacity(double opacity) {
        if (this.m_opacity != opacity) {
            this.m_opacity = opacity;
            this.onPropertyChange(OPACITY_PROPERTY);
        }
    }

    public double getSpecularHighlightExponent() {
        return this.m_specularHighlightExponent;
    }

    public void setSpecularHighlightExponent(double specularHighlightExponent) {
        if (this.m_specularHighlightExponent != specularHighlightExponent) {
            this.m_specularHighlightExponent = specularHighlightExponent;
            this.onPropertyChange(SPECULAR_HIGHLIGHT_EXPONENT_PROPERTY);
        }
    }

    public Color getSpecularHighlightColor() {
        return this.m_specularHighlightColor;
    }

    public void setSpecularHighlightColor(Color specularHighlightColor) {
        if (Appearance.notequal(this.m_specularHighlightColor, specularHighlightColor)) {
            this.m_specularHighlightColor = specularHighlightColor;
            this.onPropertyChange(SPECULAR_HIGHLIGHT_COLOR_PROPERTY);
        }
    }

    public Color getEmissiveColor() {
        return this.m_emissiveColor;
    }

    public void setEmissiveColor(Color emissiveColor) {
        if (Appearance.notequal(this.m_emissiveColor, emissiveColor)) {
            this.m_emissiveColor = emissiveColor;
            this.onPropertyChange(EMISSIVE_COLOR_PROPERTY);
        }
    }

    public FillingStyle getFillingStyle() {
        return this.m_fillingStyle;
    }

    public void setFillingStyle(FillingStyle fillingStyle) {
        if (this.m_fillingStyle != fillingStyle) {
            this.m_fillingStyle = fillingStyle;
            this.onPropertyChange(FILLING_STYLE_PROPERTY);
        }
    }

    public ShadingStyle getShadingStyle() {
        return this.m_shadingStyle;
    }

    public void setShadingStyle(ShadingStyle shadingStyle) {
        if (this.m_shadingStyle != shadingStyle) {
            this.m_shadingStyle = shadingStyle;
            this.onPropertyChange(SHADING_STYLE_PROPERTY);
        }
    }

    public TextureMap getDiffuseColorMap() {
        return this.m_diffuseColorMap;
    }

    public void setDiffuseColorMap(TextureMap diffuseColorMap) {
        if (Appearance.notequal(this.m_diffuseColorMap, diffuseColorMap)) {
            this.m_diffuseColorMap = diffuseColorMap;
            this.onPropertyChange(DIFFUSE_COLOR_MAP_PROPERTY);
        }
    }

    public TextureMap getOpacityMap() {
        return this.m_opacityMap;
    }

    public void setOpacityMap(TextureMap opacityMap) {
        if (Appearance.notequal(this.m_opacityMap, opacityMap)) {
            this.m_opacityMap = opacityMap;
            this.onPropertyChange(OPACITY_MAP_PROPERTY);
        }
    }

    public TextureMap getEmissiveColorMap() {
        return this.m_emissiveColorMap;
    }

    public void setEmissiveColorMap(TextureMap emissiveColorMap) {
        if (Appearance.notequal(this.m_emissiveColorMap, emissiveColorMap)) {
            this.m_emissiveColorMap = emissiveColorMap;
            this.onPropertyChange(EMISSIVE_COLOR_MAP_PROPERTY);
        }
    }

    public TextureMap getSpecularHighlightColorMap() {
        return this.m_emissiveColorMap;
    }

    public void setSpecularHighlightColorMap(TextureMap specularHighlightColorMap) {
        if (Appearance.notequal(this.m_specularHighlightColorMap, specularHighlightColorMap)) {
            this.m_specularHighlightColorMap = specularHighlightColorMap;
            this.onPropertyChange(SPECULAR_HIGHLIGHT_COLOR_MAP_PROPERTY);
        }
    }

    public TextureMap getBumpMap() {
        return this.m_bumpMap;
    }

    public void setBumpMap(TextureMap bumpMap) {
        if (Appearance.notequal(this.m_bumpMap, bumpMap)) {
            this.m_bumpMap = bumpMap;
            this.onPropertyChange(BUMP_MAP_PROPERTY);
        }
    }

    public TextureMap getDetailMap() {
        return this.m_detailMap;
    }

    public void setDetailMap(TextureMap detailMap) {
        if (Appearance.notequal(this.m_detailMap, detailMap)) {
            this.m_detailMap = detailMap;
            this.onPropertyChange(DETAIL_MAP_PROPERTY);
        }
    }
}

