/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.Shape;
import edu.cmu.cs.stage3.math.Sphere;

public class Box
extends Shape {
    public static final Property WIDTH_PROPERTY = new Property(Box.class, "WIDTH");
    public static final Property HEIGHT_PROPERTY = new Property(Box.class, "HEIGHT");
    public static final Property DEPTH_PROPERTY = new Property(Box.class, "DEPTH");
    private double m_width = 1.0;
    private double m_height = 1.0;
    private double m_depth = 1.0;

    public double getWidth() {
        return this.m_width;
    }

    public void setWidth(double width) {
        if (this.m_width != width) {
            this.m_width = width;
            this.onPropertyChange(WIDTH_PROPERTY);
            this.onBoundsChange();
        }
    }

    public double getHeight() {
        return this.m_height;
    }

    public void setHeight(double height) {
        if (this.m_height != height) {
            this.m_height = height;
            this.onPropertyChange(HEIGHT_PROPERTY);
            this.onBoundsChange();
        }
    }

    public double getDepth() {
        return this.m_depth;
    }

    public void setDepth(double depth) {
        if (this.m_depth != depth) {
            this.m_depth = depth;
            this.onPropertyChange(DEPTH_PROPERTY);
            this.onBoundsChange();
        }
    }

    @Override
    protected void updateBoundingBox() {
        double halfWidth = this.m_width * 0.5;
        double halfHeight = this.m_height * 0.5;
        double halfDepth = this.m_depth * 0.5;
        this.m_boundingBox = new edu.cmu.cs.stage3.math.Box(-halfWidth, -halfHeight, -halfDepth, halfWidth, halfHeight, halfDepth);
    }

    @Override
    protected void updateBoundingSphere() {
        double halfWidth = this.m_width * 0.5;
        double halfHeight = this.m_height * 0.5;
        double halfDepth = this.m_depth * 0.5;
        this.m_boundingSphere = new Sphere(0.0, 0.0, 0.0, Math.max(Math.max(halfWidth, halfHeight), halfDepth));
    }
}

