/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationListener;
import edu.cmu.cs.stage3.alice.scenegraph.event.HierarchyEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.HierarchyListener;
import edu.cmu.cs.stage3.lang.Messages;
import java.util.Enumeration;
import java.util.Vector;
import javax.vecmath.Matrix4d;

public abstract class Component
extends Element {
    public static final Property PARENT_PROPERTY = new Property(Component.class, "PARENT");
    private Container m_parent = null;
    private Vector m_absoluteTransformationListeners = new Vector();
    private Vector m_hierarchyListeners = new Vector();

    @Override
    protected void releasePass1() {
        if (this.m_parent != null) {
            Component.warnln(String.valueOf(Messages.getString("WARNING__released_component_")) + this + " " + Messages.getString("still_has_parent_") + this.m_parent + ".");
            this.setParent(null);
        }
        super.releasePass1();
    }

    @Override
    protected void releasePass3() {
        Enumeration enum0 = this.m_absoluteTransformationListeners.elements();
        while (enum0.hasMoreElements()) {
            AbsoluteTransformationListener absoluteTransformationListener = (AbsoluteTransformationListener)enum0.nextElement();
            Component.warnln(String.valueOf(Messages.getString("WARNING__released_component_")) + this + " " + Messages.getString("still_has_absoluteTransformationListener_") + absoluteTransformationListener + ".");
        }
        enum0 = this.m_hierarchyListeners.elements();
        while (enum0.hasMoreElements()) {
            HierarchyListener hierarchyListener = (HierarchyListener)enum0.nextElement();
            Component.warnln(String.valueOf(Messages.getString("WARNING__released_component_")) + this + " " + Messages.getString("still_has_hierarchyListener_") + hierarchyListener + ".");
        }
    }

    public Container getRoot() {
        if (this.m_parent != null) {
            return this.m_parent.getRoot();
        }
        return null;
    }

    public Matrix4d getAbsoluteTransformation() {
        if (this.m_parent != null) {
            return this.m_parent.getAbsoluteTransformation();
        }
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        return m;
    }

    public Matrix4d getInverseAbsoluteTransformation() {
        if (this.m_parent != null) {
            return this.m_parent.getInverseAbsoluteTransformation();
        }
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        return m;
    }

    public Container getParent() {
        return this.m_parent;
    }

    public void setParent(Container parent) {
        if (this.m_parent != parent) {
            if (this.m_parent != null) {
                this.m_parent.onRemoveChild(this);
            }
            this.m_parent = parent;
            if (this.m_parent != null) {
                this.m_parent.onAddChild(this);
            }
            this.onPropertyChange(PARENT_PROPERTY);
            this.onAbsoluteTransformationChange();
            this.onHierarchyChange();
        }
    }

    public boolean isDescendantOf(Container container) {
        if (container == null) {
            return false;
        }
        if (this.m_parent == container) {
            return true;
        }
        if (this.m_parent == null) {
            return false;
        }
        return this.m_parent.isDescendantOf(container);
    }

    public void addAbsoluteTransformationListener(AbsoluteTransformationListener absoluteTransformationListener) {
        this.m_absoluteTransformationListeners.addElement(absoluteTransformationListener);
    }

    public void removeAbsoluteTransformationListener(AbsoluteTransformationListener absoluteTransformationListener) {
        this.m_absoluteTransformationListeners.removeElement(absoluteTransformationListener);
    }

    public AbsoluteTransformationListener[] getAbsoluteTransformationListeners() {
        Object[] array = new AbsoluteTransformationListener[this.m_absoluteTransformationListeners.size()];
        this.m_absoluteTransformationListeners.copyInto(array);
        return array;
    }

    private void onAbsoluteTransformationChange(AbsoluteTransformationEvent absoluteTransformationEvent) {
        Enumeration enum0 = this.m_absoluteTransformationListeners.elements();
        while (enum0.hasMoreElements()) {
            ((AbsoluteTransformationListener)enum0.nextElement()).absoluteTransformationChanged(absoluteTransformationEvent);
        }
    }

    protected void onAbsoluteTransformationChange() {
        if (this.isReleased()) {
            Component.warnln(String.valueOf(Messages.getString("WARNING__absolute_transformation_change_on_already_released_")) + this + ".");
        } else {
            this.onAbsoluteTransformationChange(new AbsoluteTransformationEvent(this));
        }
    }

    public void addHierarchyListener(HierarchyListener hierarchyListener) {
        this.m_hierarchyListeners.addElement(hierarchyListener);
    }

    public void removeHierarchyListener(HierarchyListener hierarchyListener) {
        this.m_hierarchyListeners.removeElement(hierarchyListener);
    }

    public HierarchyListener[] getHierarchyListeners() {
        Object[] array = new HierarchyListener[this.m_hierarchyListeners.size()];
        this.m_hierarchyListeners.copyInto(array);
        return array;
    }

    private void onHierarchyChange(HierarchyEvent hierarchyEvent) {
        Enumeration enum0 = this.m_hierarchyListeners.elements();
        while (enum0.hasMoreElements()) {
            ((HierarchyListener)enum0.nextElement()).hierarchyChanged(hierarchyEvent);
        }
    }

    protected void onHierarchyChange() {
        if (this.isReleased()) {
            Component.warnln(String.valueOf(Messages.getString("WARNING__scenegraph_heirarchy_change_on_already_released_")) + this + ".");
        } else {
            this.onHierarchyChange(new HierarchyEvent(this));
        }
    }
}

