/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.PropertyListener;
import edu.cmu.cs.stage3.alice.scenegraph.event.ReleaseEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.ReleaseListener;
import edu.cmu.cs.stage3.lang.Messages;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Element {
    private static boolean s_printWarnings = false;
    public static final Property BONUS_PROPERTY;
    public static final Property NAME_PROPERTY;
    private Object m_bonus = null;
    private String m_name = null;
    private Vector m_releaseListeners = new Vector();
    private ReleaseListener[] m_releaseListenerArray = null;
    private Vector m_propertyListeners = new Vector();
    private PropertyListener[] m_propertyListenerArray = null;
    private boolean m_isReleased = false;

    static {
        try {
            s_printWarnings = Boolean.getBoolean("alice.printWarnings");
        }
        catch (Throwable t) {
            s_printWarnings = false;
        }
        BONUS_PROPERTY = new Property(Element.class, "BONUS");
        NAME_PROPERTY = new Property(Element.class, "NAME");
    }

    public static void warn(Object o) {
        if (s_printWarnings) {
            System.err.print(o);
        }
    }

    public static void warnln(Object o) {
        if (s_printWarnings) {
            System.err.println(o);
        }
    }

    public static void warnln() {
        if (s_printWarnings) {
            System.err.println();
        }
    }

    public boolean isReleased() {
        return this.m_isReleased;
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    protected void releasePass1() {
    }

    protected void releasePass2() {
        this.m_bonus = null;
        this.m_name = null;
    }

    protected void releasePass3() {
        Enumeration enum0 = this.m_propertyListeners.elements();
        while (enum0.hasMoreElements()) {
            PropertyListener propertyListener = (PropertyListener)enum0.nextElement();
            Element.warnln(String.valueOf(Messages.getString("WARNING__released_element_")) + this + " " + Messages.getString("still_has_propertyListener_") + propertyListener + ".");
        }
        this.m_propertyListeners = null;
        this.m_propertyListenerArray = null;
        enum0 = this.m_releaseListeners.elements();
        while (enum0.hasMoreElements()) {
            ReleaseListener releaseListener = (ReleaseListener)enum0.nextElement();
            Element.warnln(String.valueOf(Messages.getString("WARNING__released_element_")) + this + " " + Messages.getString("still_has_releaseListener_") + releaseListener + ".");
        }
        this.m_releaseListeners = null;
        this.m_releaseListenerArray = null;
    }

    public synchronized void release() {
        if (!this.m_isReleased) {
            ReleaseEvent releaseEvent = new ReleaseEvent(this);
            ReleaseListener[] releaseListenersArray = this.getReleaseListeners();
            int i = 0;
            while (i < releaseListenersArray.length) {
                releaseListenersArray[i].releasing(releaseEvent);
                ++i;
            }
            this.releasePass1();
            this.releasePass2();
            i = 0;
            while (i < releaseListenersArray.length) {
                releaseListenersArray[i].released(releaseEvent);
                ++i;
            }
            this.releasePass3();
            this.m_isReleased = true;
        }
    }

    public Object getBonus() {
        return this.m_bonus;
    }

    public void setBonus(Object bonus) {
        if (this.m_bonus != bonus) {
            this.m_bonus = bonus;
            this.onPropertyChange(BONUS_PROPERTY);
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        if (Element.notequal(this.m_name, name)) {
            this.m_name = name;
            this.onPropertyChange(NAME_PROPERTY);
        }
    }

    public void addPropertyListener(PropertyListener propertyListener) {
        this.m_propertyListeners.addElement(propertyListener);
        this.m_propertyListenerArray = null;
    }

    public void removePropertyListener(PropertyListener propertyListener) {
        this.m_propertyListeners.removeElement(propertyListener);
        this.m_propertyListenerArray = null;
    }

    public PropertyListener[] getPropertyListeners() {
        if (this.m_propertyListenerArray == null) {
            this.m_propertyListenerArray = new PropertyListener[this.m_propertyListeners.size()];
            this.m_propertyListeners.copyInto(this.m_propertyListenerArray);
        }
        return this.m_propertyListenerArray;
    }

    protected void onPropertyChange(PropertyEvent propertyEvent) {
        Enumeration enum0 = this.m_propertyListeners.elements();
        while (enum0.hasMoreElements()) {
            PropertyListener propertyListener = (PropertyListener)enum0.nextElement();
            propertyListener.changed(propertyEvent);
        }
    }

    protected void onPropertyChange(Property property) {
        if (this.isReleased()) {
            Element.warnln(String.valueOf(Messages.getString("WARNING__scenegraph_property_change_")) + property + " " + Messages.getString("on_already_released_") + this + ".");
        } else {
            this.onPropertyChange(new PropertyEvent(this, property));
        }
    }

    public void addReleaseListener(ReleaseListener releaseListener) {
        this.m_releaseListeners.addElement(releaseListener);
        this.m_releaseListenerArray = null;
    }

    public void removeReleaseListener(ReleaseListener releaseListener) {
        this.m_releaseListeners.removeElement(releaseListener);
        this.m_releaseListenerArray = null;
    }

    public ReleaseListener[] getReleaseListeners() {
        if (this.m_releaseListenerArray == null) {
            this.m_releaseListenerArray = new ReleaseListener[this.m_releaseListeners.size()];
            this.m_releaseListeners.copyInto(this.m_releaseListenerArray);
        }
        return this.m_releaseListenerArray;
    }

    protected static boolean notequal(Object a, Object b) {
        if (a == null) {
            return b != null;
        }
        return !a.equals(b);
    }

    public String toString() {
        if (this.m_name == null) {
            return super.toString();
        }
        return this.m_name;
    }
}

