/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Vector3d;

public class Transformable
extends ReferenceFrame {
    public static final Property LOCAL_TRANSFORMATION_PROPERTY = new Property(Transformable.class, "LOCAL_TRANSFORMATION");
    public static final Property IS_FIRST_CLASS_PROPERTY = new Property(Transformable.class, "IS_FIRST_CLASS");
    private Matrix4d m_localTransformation = null;
    private boolean m_isFirstClass = true;
    private static Transformable s_calculatePointAtHelperOffset = new Transformable();
    private static Transformable s_calculatePointAtHelperA = new Transformable();
    private static Transformable s_calculatePointAtHelperB = new Transformable();
    private Matrix4d m_absoluteTransformation = null;
    private Matrix4d m_inverseAbsoluteTransformation = null;
    private Object m_absoluteTransformationLock = new Object();
    private boolean m_isHelper = false;

    static {
        s_calculatePointAtHelperOffset.setName("s_calculatePointAtHelperOffset");
        s_calculatePointAtHelperA.setName("s_calculatePointAtHelperA");
        s_calculatePointAtHelperB.setName("s_calculatePointAtHelperB");
        s_calculatePointAtHelperOffset.setIsHelper(true);
        s_calculatePointAtHelperA.setIsHelper(true);
        s_calculatePointAtHelperB.setIsHelper(true);
    }

    public Transformable() {
        this.m_localTransformation = new Matrix4d();
        this.m_localTransformation.setIdentity();
    }

    public boolean isHelper() {
        return this.m_isHelper;
    }

    public void setIsHelper(boolean isHelper) {
        this.m_isHelper = isHelper;
    }

    public boolean getIsFirstClass() {
        return this.m_isFirstClass;
    }

    public void setIsFirstClass(boolean isFirstClass) {
        if (this.m_isFirstClass != isFirstClass) {
            this.m_isFirstClass = isFirstClass;
            this.onPropertyChange(IS_FIRST_CLASS_PROPERTY);
        }
    }

    public Matrix4d getLocalTransformation() {
        if (this.m_localTransformation == null) {
            throw new NullPointerException();
        }
        return new Matrix4d(this.m_localTransformation);
    }

    public void setLocalTransformation(Matrix4d localTransformation) {
        if (localTransformation == null) {
            throw new NullPointerException();
        }
        if (Transformable.notequal(this.m_localTransformation, localTransformation)) {
            this.m_localTransformation = localTransformation;
            this.onPropertyChange(LOCAL_TRANSFORMATION_PROPERTY);
            this.onAbsoluteTransformationChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Matrix4d getAbsoluteTransformation() {
        Object object = this.m_absoluteTransformationLock;
        synchronized (object) {
            if (this.m_absoluteTransformation == null) {
                Container parent = this.getParent();
                this.m_absoluteTransformation = parent != null ? MathUtilities.multiply(this.m_localTransformation, parent.getAbsoluteTransformation()) : new Matrix4d(this.m_localTransformation);
                if (Math.abs(this.m_absoluteTransformation.m33 - 1.0) > 0.01) {
                    System.err.println("JAVA SCENEGRAH LOCAL: holy corrupt matrix batman " + this.m_absoluteTransformation);
                }
            }
            return new Matrix4d(this.m_absoluteTransformation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Matrix4d getInverseAbsoluteTransformation() {
        Object object = this.m_absoluteTransformationLock;
        synchronized (object) {
            if (this.m_inverseAbsoluteTransformation == null) {
                this.m_inverseAbsoluteTransformation = this.getAbsoluteTransformation();
                try {
                    this.m_inverseAbsoluteTransformation.invert();
                }
                catch (SingularMatrixException sme) {
                    System.err.println("cannot invert: " + this.m_inverseAbsoluteTransformation);
                    throw sme;
                }
            }
            return new Matrix4d(this.m_inverseAbsoluteTransformation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onAbsoluteTransformationChange() {
        super.onAbsoluteTransformationChange();
        Object object = this.m_absoluteTransformationLock;
        synchronized (object) {
            this.m_absoluteTransformation = null;
            this.m_inverseAbsoluteTransformation = null;
        }
    }

    @Override
    public Matrix44 getTransformation(ReferenceFrame asSeenBy) {
        ReferenceFrame vehicle = (ReferenceFrame)this.getParent();
        if (asSeenBy == null) {
            asSeenBy = vehicle;
        }
        if (asSeenBy == vehicle) {
            return new Matrix44(this.getLocalTransformation());
        }
        if (asSeenBy instanceof Scene) {
            return new Matrix44(this.getAbsoluteTransformation());
        }
        return super.getTransformation(asSeenBy);
    }

    public Matrix44 calculateTransformation(Matrix4d m, ReferenceFrame asSeenBy) {
        Matrix4d vehicleInverse;
        ReferenceFrame vehicle = (ReferenceFrame)this.getParent();
        if (asSeenBy == null) {
            asSeenBy = vehicle;
        }
        if (asSeenBy == vehicle) {
            return new Matrix44(m);
        }
        if (vehicle != null) {
            vehicleInverse = vehicle.getInverseAbsoluteTransformation();
        } else {
            vehicleInverse = new Matrix4d();
            vehicleInverse.setIdentity();
        }
        return Matrix44.multiply(m, Matrix44.multiply(asSeenBy.getAbsoluteTransformation(), vehicleInverse));
    }

    public void setAbsoluteTransformation(Matrix4d m) {
        ReferenceFrame vehicle = (ReferenceFrame)this.getParent();
        this.setLocalTransformation(MathUtilities.multiply(m, vehicle.getInverseAbsoluteTransformation()));
    }

    public void setTransformation(Matrix4d m, ReferenceFrame asSeenBy) {
        this.setLocalTransformation(this.calculateTransformation(m, asSeenBy));
    }

    public void setPosition(Vector3d position, ReferenceFrame asSeenBy) {
        Matrix33 axes = this.getAxes(null);
        Matrix44 m = new Matrix44();
        m.setPosition(position);
        m = this.calculateTransformation(m, asSeenBy);
        m.setAxes(axes);
        this.setLocalTransformation(m);
    }

    public void setAxes(Matrix3d axes, ReferenceFrame asSeenBy) {
        Vector3 translation = this.getPosition(null);
        Matrix44 m = new Matrix44();
        m.setAxes(axes);
        m = this.calculateTransformation(m, asSeenBy);
        m.setPosition(translation);
        this.setLocalTransformation(m);
    }

    public void setQuaternion(Quaternion quaternion, ReferenceFrame asSeenBy) {
        this.setAxes(quaternion.getMatrix33(), asSeenBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matrix33 calculatePointAt(ReferenceFrame target, Vector3d offset, Vector3d upGuide, ReferenceFrame asSeenBy, boolean onlyAffectYaw) {
        Transformable transformable = s_calculatePointAtHelperOffset;
        synchronized (transformable) {
            Matrix33 result;
            ReferenceFrame actualTarget;
            if (upGuide == null) {
                upGuide = MathUtilities.getYAxis();
            }
            if (asSeenBy == null) {
                asSeenBy = (ReferenceFrame)this.getParent();
            }
            Matrix44 transform = this.getTransformation(asSeenBy);
            Vector3 position = transform.getPosition();
            if (offset == null) {
                actualTarget = target;
            } else {
                s_calculatePointAtHelperOffset.setParent(target);
                Matrix44 m = new Matrix44();
                m.m30 = offset.x;
                m.m31 = offset.y;
                m.m32 = offset.z;
                s_calculatePointAtHelperOffset.setLocalTransformation(m);
                actualTarget = s_calculatePointAtHelperOffset;
            }
            if (onlyAffectYaw) {
                s_calculatePointAtHelperA.setParent(asSeenBy);
                s_calculatePointAtHelperA.setLocalTransformation(new Matrix44());
                s_calculatePointAtHelperA.setPosition(Vector3.ZERO, this);
                Vector3 targetPosition = actualTarget.getPosition(s_calculatePointAtHelperA);
                double targetTheta = Math.atan2(targetPosition.x, targetPosition.z);
                s_calculatePointAtHelperB.setParent(this);
                s_calculatePointAtHelperB.setPosition(MathUtilities.getZAxis(), this);
                Vector3 forwardPosition = s_calculatePointAtHelperB.getPosition(s_calculatePointAtHelperA);
                double forwardTheta = Math.atan2(forwardPosition.x, forwardPosition.z);
                s_calculatePointAtHelperB.setLocalTransformation(new Matrix44());
                double deltaTheta = targetTheta - forwardTheta;
                s_calculatePointAtHelperB.rotate(MathUtilities.getYAxis(), deltaTheta, s_calculatePointAtHelperA);
                result = s_calculatePointAtHelperB.getAxes(asSeenBy);
                s_calculatePointAtHelperA.setParent(null);
                s_calculatePointAtHelperB.setParent(null);
            } else {
                Vector3 targetPosition = actualTarget.getPosition(asSeenBy);
                Vector3d zAxis = MathUtilities.normalizeV(MathUtilities.subtract(targetPosition, position));
                Vector3d xAxis = MathUtilities.normalizeV(MathUtilities.crossProduct(upGuide, zAxis));
                if (Double.isNaN(xAxis.lengthSquared())) {
                    xAxis.set(0.0, 0.0, 0.0);
                    zAxis.set(0.0, 0.0, 0.0);
                }
                Vector3d yAxis = MathUtilities.crossProduct(zAxis, xAxis);
                result = new Matrix33(xAxis, yAxis, zAxis);
            }
            if (offset == null) {
                s_calculatePointAtHelperOffset.setParent(null);
            }
            return result;
        }
    }

    public Matrix33 calculatePointAt(ReferenceFrame target, Vector3d offset, Vector3d upGuide, ReferenceFrame asSeenBy) {
        return this.calculatePointAt(target, offset, upGuide, asSeenBy, false);
    }

    public void pointAt(ReferenceFrame target, Vector3d offset, Vector3d upGuide, ReferenceFrame asSeenBy) {
        this.setAxes(this.calculatePointAt(target, offset, upGuide, asSeenBy), asSeenBy);
    }

    public static Matrix33 calculateOrientation(Vector3d forward, Vector3d upGuide) {
        Vector3d zAxis;
        Vector3d xAxis;
        if (upGuide == null) {
            upGuide = MathUtilities.getYAxis();
        }
        if (Double.isNaN((xAxis = MathUtilities.normalizeV(MathUtilities.crossProduct(upGuide, zAxis = MathUtilities.normalizeV(forward)))).lengthSquared())) {
            throw new RuntimeException("cannot calculate orientation: forward=" + forward + " upGuide=" + upGuide);
        }
        Vector3d yAxis = MathUtilities.crossProduct(zAxis, xAxis);
        return new Matrix33(xAxis, yAxis, zAxis);
    }

    public void setOrientation(Vector3d forward, Vector3d upGuide, ReferenceFrame asSeenBy) {
        this.setAxes(Transformable.calculateOrientation(forward, upGuide), asSeenBy);
    }

    public Matrix33 calculateStandUp(ReferenceFrame asSeenBy) {
        Matrix33 axes = this.getAxes(asSeenBy);
        Vector3d yAxis = MathUtilities.getYAxis();
        Vector3d zAxis = MathUtilities.normalizeV(MathUtilities.crossProduct(axes.getRow(0), yAxis));
        Vector3d xAxis = MathUtilities.crossProduct(yAxis, zAxis);
        return new Matrix33(xAxis, yAxis, zAxis);
    }

    public void standUp(ReferenceFrame asSeenBy) {
        this.setAxes(this.calculateStandUp(asSeenBy), asSeenBy);
    }

    public void translate(Vector3d vector, ReferenceFrame asSeenBy) {
        if (asSeenBy == null) {
            asSeenBy = this;
        }
        Matrix44 m = this.getTransformation(asSeenBy);
        m.translate(vector);
        this.setTransformation(m, asSeenBy);
    }

    public void rotate(Vector3d axis, double amount, ReferenceFrame asSeenBy) {
        if (asSeenBy == null) {
            asSeenBy = this;
        }
        Matrix44 m = this.getTransformation(asSeenBy);
        m.rotate(axis, amount);
        this.setTransformation(m, asSeenBy);
    }

    public void scale(Vector3d axis, ReferenceFrame asSeenBy) {
        if (asSeenBy == null) {
            asSeenBy = this;
        }
        Matrix44 m = this.getTransformation(asSeenBy);
        m.scale(axis);
        this.setTransformation(m, asSeenBy);
    }

    public void transform(Matrix4d trans, ReferenceFrame asSeenBy) {
        if (asSeenBy == null) {
            asSeenBy = this;
        }
        Matrix44 m = this.getTransformation(asSeenBy);
        m.transform(trans);
        this.setTransformation(m, asSeenBy);
    }

    public void setPivot(ReferenceFrame pivot) {
        Matrix44 m = this.getTransformation(pivot);
        Matrix44 mInverse = Matrix44.invert(m);
        this.transform(mInverse, this);
        int i = 0;
        while (i < this.getChildCount()) {
            Component child = this.getChildAt(i);
            if (child instanceof Transformable) {
                ((Transformable)child).transform(m, this);
            } else if (child instanceof Visual) {
                ((Visual)child).transform(m);
            }
            ++i;
        }
    }
}

