/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.io;

import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.MathUtilities;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.Vector;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector4d;

public class OBJ {
    private static double getNextNumber(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -2) {
                double f = streamTokenizer.nval;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -3 && streamTokenizer.sval.startsWith("E")) {
                    int exponent = Integer.parseInt(streamTokenizer.sval.substring(1));
                    return f * Math.pow(10.0, exponent);
                }
                streamTokenizer.pushBack();
                return f;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return Double.NaN;
    }

    public static Object[] load(InputStream is) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        StreamTokenizer st = new StreamTokenizer(r);
        st.commentChar(35);
        st.slashSlashComments(false);
        st.slashStarComments(false);
        st.whitespaceChars(47, 47);
        st.parseNumbers();
        Vector<double[]> xyzs = new Vector<double[]>();
        Vector<double[]> ijks = new Vector<double[]>();
        Vector<double[]> uvs = new Vector<double[]>();
        Vector fs = new Vector();
        while (st.nextToken() == -3) {
            if (st.sval.startsWith("vt")) {
                double[] uv = new double[3];
                uv[0] = OBJ.getNextNumber(st);
                uv[1] = OBJ.getNextNumber(st);
                uvs.addElement(uv);
                continue;
            }
            if (st.sval.startsWith("vn")) {
                double[] ijk = new double[]{OBJ.getNextNumber(st), OBJ.getNextNumber(st), OBJ.getNextNumber(st)};
                ijks.addElement(ijk);
                continue;
            }
            if (st.sval.startsWith("v")) {
                double[] xyz = new double[]{OBJ.getNextNumber(st), OBJ.getNextNumber(st), OBJ.getNextNumber(st)};
                xyzs.addElement(xyz);
                continue;
            }
            if (!st.sval.startsWith("f")) break;
            Vector<Integer> f = new Vector<Integer>();
            while (st.nextToken() == -2) {
                f.addElement(new Integer((int)st.nval - 1));
            }
            st.pushBack();
            fs.addElement(f);
        }
        int nVertexCount = xyzs.size();
        Vertex3d[] vertices = new Vertex3d[nVertexCount];
        double[] ijkDefault = new double[]{0.0, 1.0, 0.0};
        double[] uvDefault = new double[]{0.0, 0.0};
        int v = 0;
        while (v < nVertexCount) {
            double[] uv;
            double[] ijk;
            double[] xyz = (double[])xyzs.elementAt(v);
            try {
                ijk = (double[])ijks.elementAt(v);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                ijk = ijkDefault;
            }
            try {
                uv = (double[])uvs.elementAt(v);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                uv = uvDefault;
            }
            vertices[v] = Vertex3d.createXYZIJKUV(xyz[0], xyz[1], xyz[2], ijk[0], ijk[1], ijk[2], (float)uv[0], (float)uv[1]);
            ++v;
        }
        int[] indices = new int[fs.size() * 3];
        int i = 0;
        int f = 0;
        while (f < fs.size()) {
            Vector face = (Vector)fs.elementAt(f);
            switch (face.size()) {
                case 3: {
                    indices[i++] = (Integer)face.elementAt(0);
                    indices[i++] = (Integer)face.elementAt(1);
                    indices[i++] = (Integer)face.elementAt(2);
                    break;
                }
                case 6: {
                    indices[i++] = (Integer)face.elementAt(0);
                    indices[i++] = (Integer)face.elementAt(2);
                    indices[i++] = (Integer)face.elementAt(4);
                    break;
                }
                case 9: {
                    indices[i++] = (Integer)face.elementAt(0);
                    indices[i++] = (Integer)face.elementAt(3);
                    indices[i++] = (Integer)face.elementAt(6);
                    break;
                }
                default: {
                    throw new RuntimeException(Messages.getString("unhandled_face_index_size"));
                }
            }
            ++f;
        }
        Object[] array = new Object[]{vertices, indices};
        return array;
    }

    public static void store(OutputStream os, Vertex3d[] vertices, int[] indices, Matrix4d m, String groupNames) throws IOException {
        if (vertices != null && indices != null) {
            BufferedOutputStream bos = new BufferedOutputStream(os);
            PrintWriter pw = new PrintWriter(bos);
            if (groupNames != null) {
                pw.println("g " + groupNames);
            }
            int lcv = 0;
            while (lcv < vertices.length) {
                double x = vertices[lcv].position.x;
                double y = vertices[lcv].position.y;
                double z = vertices[lcv].position.z;
                double i = vertices[lcv].normal.x;
                double j = vertices[lcv].normal.y;
                double k = vertices[lcv].normal.z;
                double u = vertices[lcv].textureCoordinate0.x;
                double v = vertices[lcv].textureCoordinate0.y;
                if (m != null) {
                    Vector4d xyzw = MathUtilities.multiply(x, y, z, 1.0, m);
                    Vector4d ijkw = MathUtilities.multiply(i, j, k, 0.0, m);
                    x = xyzw.x;
                    y = xyzw.y;
                    z = xyzw.z;
                    i = ijkw.x;
                    j = ijkw.y;
                    k = ijkw.z;
                }
                pw.print("v ");
                pw.print(x);
                pw.print(" ");
                pw.print(y);
                pw.print(" ");
                pw.print(z);
                pw.println();
                pw.print("vt ");
                pw.print(u);
                pw.print(" ");
                pw.print(v);
                pw.println();
                pw.print("vn ");
                pw.print(i);
                pw.print(" ");
                pw.print(j);
                pw.print(" ");
                pw.print(k);
                pw.println();
                ++lcv;
            }
            int i = 0;
            while (i < indices.length) {
                pw.print("f ");
                int j = 0;
                while (j < 3) {
                    int a = indices[i + j] - vertices.length;
                    pw.print(String.valueOf(a) + "/" + a + "/" + a + " ");
                    ++j;
                }
                pw.println();
                i += 3;
            }
            pw.flush();
        }
    }

    private static void store(OutputStream os, IndexedTriangleArray ita, Matrix4d m, String groupNames) throws IOException {
        OBJ.store(os, ita.getVertices(), ita.getIndices(), m, groupNames);
    }

    private static void store(OutputStream os, Visual visual, Matrix4d m, String groupNames) throws IOException {
        Geometry geometry = visual.getGeometry();
        if (geometry instanceof IndexedTriangleArray) {
            OBJ.store(os, (IndexedTriangleArray)geometry, m, groupNames);
        }
    }

    private static void store(OutputStream os, Transformable transformable, ReferenceFrame root, String groupNames) throws IOException {
        String name = transformable.getName();
        if (name != null) {
            int k = name.indexOf(".m_sgTransformable");
            if (k != -1) {
                name = name.substring(0, k);
            }
        } else {
            name = "null";
        }
        groupNames = groupNames.length() > 0 ? String.valueOf(name) + "_" + groupNames : name;
        int i = 0;
        while (i < transformable.getChildCount()) {
            Component child = transformable.getChildAt(i);
            if (child instanceof Transformable) {
                OBJ.store(os, (Transformable)child, root, groupNames);
            } else if (child instanceof Visual) {
                OBJ.store(os, (Visual)child, (Matrix4d)transformable.getTransformation(root), groupNames);
            }
            ++i;
        }
    }

    public static void store(OutputStream os, Transformable transformable) throws IOException {
        OBJ.store(os, transformable, transformable, "");
    }
}

