/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer;

import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractRenderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.Renderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RenderTargetEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RenderTargetListener;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Ray;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public abstract class AbstractRenderTarget
implements RenderTarget {
    private AbstractRenderer m_abstractRenderer;
    private Vector m_sgCameras = new Vector();
    private Camera[] m_sgCameraArray = null;
    private Vector m_renderTargetListeners = new Vector();
    private RenderTargetListener[] m_renderTargetListenerArray = null;
    private String m_name = null;

    protected AbstractRenderTarget(AbstractRenderer abstractRenderer) {
        this.m_abstractRenderer = abstractRenderer;
        this.m_abstractRenderer.addRenderTarget(this);
    }

    @Override
    public void release() {
        this.m_abstractRenderer.removeRenderTarget(this);
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    @Override
    public Renderer getRenderer() {
        return this.m_abstractRenderer;
    }

    @Override
    public void markDirty() {
    }

    @Override
    public Dimension getSize() {
        Dimension size = new Dimension();
        return this.getSize(size);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public void addCamera(Camera camera) {
        if (!this.m_sgCameras.contains(camera)) {
            this.m_sgCameras.addElement(camera);
            this.m_sgCameraArray = null;
        }
        this.markDirty();
    }

    @Override
    public void removeCamera(Camera camera) {
        this.m_sgCameras.removeElement(camera);
        this.m_sgCameraArray = null;
        this.markDirty();
    }

    @Override
    public Camera[] getCameras() {
        if (this.m_sgCameraArray == null) {
            this.m_sgCameraArray = new Camera[this.m_sgCameras.size()];
            this.m_sgCameras.copyInto(this.m_sgCameraArray);
        }
        return this.m_sgCameraArray;
    }

    public void clearCameras() {
        this.m_sgCameras.removeAllElements();
        this.markDirty();
    }

    @Override
    public void addRenderTargetListener(RenderTargetListener renderTargetListener) {
        this.m_renderTargetListeners.addElement(renderTargetListener);
        this.m_renderTargetListenerArray = null;
    }

    @Override
    public void removeRenderTargetListener(RenderTargetListener renderTargetListener) {
        this.m_renderTargetListeners.removeElement(renderTargetListener);
        this.m_renderTargetListenerArray = null;
    }

    @Override
    public RenderTargetListener[] getRenderTargetListeners() {
        if (this.m_renderTargetListenerArray == null) {
            this.m_renderTargetListenerArray = new RenderTargetListener[this.m_renderTargetListeners.size()];
            this.m_renderTargetListeners.copyInto(this.m_renderTargetListenerArray);
        }
        return this.m_renderTargetListenerArray;
    }

    @Override
    public Vector4d transformFromViewportToProjection(Vector3d xyz, Camera camera) {
        Rectangle viewport = this.getActualViewport(camera);
        double halfWidth = (double)viewport.width / 2.0;
        double halfHeight = (double)viewport.height / 2.0;
        double x = (xyz.x - halfWidth) / halfWidth;
        double y = -(xyz.y - halfHeight) / halfHeight;
        return new Vector4d(x, y, xyz.z, 1.0);
    }

    @Override
    public Vector3d transformFromProjectionToCamera(Vector4d xyzw, Camera camera) {
        Matrix4d inverseProjectionMatrix = this.getProjectionMatrix(camera);
        inverseProjectionMatrix.invert();
        return MathUtilities.createVector3d((Tuple4d)MathUtilities.multiply(xyzw, inverseProjectionMatrix));
    }

    @Override
    public Vector3d transformFromViewportToCamera(Vector3d xyz, Camera camera) {
        return this.transformFromProjectionToCamera(this.transformFromViewportToProjection(xyz, camera), camera);
    }

    @Override
    public Vector4d transformFromCameraToProjection(Vector3d xyz, Camera camera) {
        Matrix4d projectionMatrix = this.getProjectionMatrix(camera);
        return MathUtilities.multiply(xyz, 1.0, projectionMatrix);
    }

    @Override
    public Vector3d transformFromProjectionToViewport(Vector4d xyzw, Camera camera) {
        Rectangle viewport = this.getActualViewport(camera);
        double halfWidth = (double)viewport.width / 2.0;
        double halfHeight = (double)viewport.height / 2.0;
        Vector3d xyz = MathUtilities.createVector3d((Tuple4d)xyzw);
        xyz.x = (xyz.x + 1.0) * halfWidth;
        xyz.y = (double)viewport.height - (xyz.y + 1.0) * halfHeight;
        return xyz;
    }

    @Override
    public Vector3d transformFromCameraToViewport(Vector3d xyz, Camera camera) {
        return this.transformFromProjectionToViewport(this.transformFromCameraToProjection(xyz, camera), camera);
    }

    @Override
    public Ray getRayAtPixel(Camera camera, int pixelX, int pixelY) {
        Matrix4d inverseProjection = this.getProjectionMatrix(camera);
        inverseProjection.invert();
        Point3d origin = new Point3d(inverseProjection.m20 / inverseProjection.m23, inverseProjection.m21 / inverseProjection.m23, inverseProjection.m22 / inverseProjection.m23);
        Rectangle viewport = this.getActualViewport(camera);
        double halfWidth = (double)viewport.width / 2.0;
        double halfHeight = (double)viewport.height / 2.0;
        double x = ((double)pixelX + 0.5 - halfWidth) / halfWidth;
        double y = -((double)pixelY + 0.5 - halfHeight) / halfHeight;
        Vector4d qs = new Vector4d(x, y, 0.0, 1.0);
        Vector4d qw = MathUtilities.multiply(qs, inverseProjection);
        Vector3d direction = new Vector3d(qw.x * inverseProjection.m23 - qw.w * inverseProjection.m20, qw.y * inverseProjection.m23 - qw.w * inverseProjection.m21, qw.z * inverseProjection.m23 - qw.w * inverseProjection.m22);
        direction.normalize();
        return new Ray(origin, direction);
    }

    protected void onClear() {
        this.m_abstractRenderer.enterIgnore();
        try {
            RenderTargetEvent renderTargetEvent = new RenderTargetEvent(this);
            RenderTargetListener[] rtls = this.getRenderTargetListeners();
            int i = 0;
            while (i < rtls.length) {
                rtls[i].cleared(renderTargetEvent);
                ++i;
            }
        }
        finally {
            this.m_abstractRenderer.leaveIgnore();
        }
    }

    protected void onRender() {
        this.m_abstractRenderer.enterIgnore();
        try {
            RenderTargetEvent renderTargetEvent = new RenderTargetEvent(this);
            RenderTargetListener[] rtls = this.getRenderTargetListeners();
            int i = 0;
            while (i < rtls.length) {
                rtls[i].rendered(renderTargetEvent);
                ++i;
            }
        }
        finally {
            this.m_abstractRenderer.leaveIgnore();
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getName() + "]";
    }
}

