/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer;

import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationListener;
import edu.cmu.cs.stage3.alice.scenegraph.event.BoundEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.BoundListener;
import edu.cmu.cs.stage3.alice.scenegraph.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.scenegraph.event.HierarchyEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.HierarchyListener;
import edu.cmu.cs.stage3.alice.scenegraph.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.PropertyListener;
import edu.cmu.cs.stage3.alice.scenegraph.event.ReleaseEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.ReleaseListener;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OffscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.Renderer;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.SwingUtilities;

public abstract class AbstractRenderer
implements Renderer,
AbsoluteTransformationListener,
BoundListener,
ChildrenListener,
HierarchyListener,
PropertyListener,
ReleaseListener {
    private boolean m_isSoftwareEmulationForced;
    private Vector m_onscreenRenderTargets = new Vector();
    private Vector m_offscreenRenderTargets = new Vector();
    private OnscreenRenderTarget[] m_onscreenRenderTargetArray = null;
    private OffscreenRenderTarget[] m_offscreenRenderTargetArray = null;
    private Vector m_rendererListeners = new Vector();
    private Vector m_pendingAbsoluteTransformationChanges = new Vector();
    private Vector m_pendingBoundChanges = new Vector();
    private Vector m_pendingChildChanges = new Vector();
    private Vector m_pendingHeirarchyChanges = new Vector();
    private Vector m_pendingPropertyChanges = new Vector();
    private Vector m_pendingReleases = new Vector();
    private int m_ignoreCount = 0;

    protected abstract void dispatchAbsoluteTransformationChange(AbsoluteTransformationEvent var1);

    protected abstract void dispatchBoundChange(BoundEvent var1);

    protected abstract void dispatchChildAdd(ChildrenEvent var1);

    protected abstract void dispatchChildRemove(ChildrenEvent var1);

    protected abstract void dispatchHierarchyChange(HierarchyEvent var1);

    protected abstract void dispatchPropertyChange(PropertyEvent var1);

    protected abstract void dispatchRelease(ReleaseEvent var1);

    protected abstract boolean requiresHierarchyAndAbsoluteTransformationListening();

    protected abstract boolean requiresBoundListening();

    public void enterIgnore() {
        ++this.m_ignoreCount;
    }

    public void leaveIgnore() {
        --this.m_ignoreCount;
    }

    private boolean ignore() {
        return this.m_ignoreCount > 0;
    }

    public void markAllRenderTargetsDirty() {
        if (this.m_ignoreCount <= 0) {
            RenderTarget[] renderTargets = this.getOffscreenRenderTargets();
            int i = 0;
            while (i < renderTargets.length) {
                renderTargets[i].markDirty();
                ++i;
            }
            renderTargets = this.getOnscreenRenderTargets();
            i = 0;
            while (i < renderTargets.length) {
                renderTargets[i].markDirty();
                ++i;
            }
        }
    }

    public void addListenersToSGElement(Element sgElement) {
        if (sgElement instanceof Geometry) {
            if (this.requiresBoundListening()) {
                ((Geometry)sgElement).addBoundListener(this);
            }
        } else if (sgElement instanceof Component) {
            if (sgElement instanceof Container) {
                ((Container)sgElement).addChildrenListener(this);
            }
            if (this.requiresHierarchyAndAbsoluteTransformationListening()) {
                ((Component)sgElement).addAbsoluteTransformationListener(this);
                ((Component)sgElement).addHierarchyListener(this);
            }
        }
        sgElement.addPropertyListener(this);
        sgElement.addReleaseListener(this);
    }

    public void removeListenersFromSGElement(Element sgElement) {
        if (sgElement instanceof Geometry) {
            if (this.requiresBoundListening()) {
                ((Geometry)sgElement).removeBoundListener(this);
            }
        } else if (sgElement instanceof Component) {
            if (sgElement instanceof Container) {
                ((Container)sgElement).removeChildrenListener(this);
            }
            if (this.requiresHierarchyAndAbsoluteTransformationListening()) {
                ((Component)sgElement).removeAbsoluteTransformationListener(this);
                ((Component)sgElement).removeHierarchyListener(this);
            }
        }
        sgElement.removePropertyListener(this);
        sgElement.removeReleaseListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitAnyPendingChanges() {
        Enumeration enum0;
        Vector vector;
        if (this.m_pendingAbsoluteTransformationChanges.size() > 0) {
            vector = this.m_pendingAbsoluteTransformationChanges;
            synchronized (vector) {
                enum0 = this.m_pendingAbsoluteTransformationChanges.elements();
                while (enum0.hasMoreElements()) {
                    this.dispatchAbsoluteTransformationChange((AbsoluteTransformationEvent)enum0.nextElement());
                }
                this.m_pendingAbsoluteTransformationChanges.clear();
            }
        }
        if (this.m_pendingBoundChanges.size() > 0) {
            vector = this.m_pendingBoundChanges;
            synchronized (vector) {
                enum0 = this.m_pendingBoundChanges.elements();
                while (enum0.hasMoreElements()) {
                    this.dispatchBoundChange((BoundEvent)enum0.nextElement());
                }
                this.m_pendingBoundChanges.clear();
            }
        }
        if (this.m_pendingChildChanges.size() > 0) {
            vector = this.m_pendingChildChanges;
            synchronized (vector) {
                enum0 = this.m_pendingChildChanges.elements();
                while (enum0.hasMoreElements()) {
                    ChildrenEvent e = (ChildrenEvent)enum0.nextElement();
                    if (e.getID() == 1) {
                        this.dispatchChildAdd(e);
                        continue;
                    }
                    this.dispatchChildRemove(e);
                }
                this.m_pendingChildChanges.clear();
            }
        }
        if (this.m_pendingHeirarchyChanges.size() > 0) {
            vector = this.m_pendingHeirarchyChanges;
            synchronized (vector) {
                enum0 = this.m_pendingHeirarchyChanges.elements();
                while (enum0.hasMoreElements()) {
                    this.dispatchHierarchyChange((HierarchyEvent)enum0.nextElement());
                }
                this.m_pendingHeirarchyChanges.clear();
            }
        }
        if (this.m_pendingPropertyChanges.size() > 0) {
            vector = this.m_pendingPropertyChanges;
            synchronized (vector) {
                enum0 = this.m_pendingPropertyChanges.elements();
                while (enum0.hasMoreElements()) {
                    this.dispatchPropertyChange((PropertyEvent)enum0.nextElement());
                }
                this.m_pendingPropertyChanges.clear();
            }
        }
    }

    private boolean isThreadOK() {
        return SwingUtilities.isEventDispatchThread();
    }

    @Override
    public void absoluteTransformationChanged(AbsoluteTransformationEvent absoluteTransformationEvent) {
        if (this.isThreadOK()) {
            this.dispatchAbsoluteTransformationChange(absoluteTransformationEvent);
            this.markAllRenderTargetsDirty();
        } else {
            this.m_pendingAbsoluteTransformationChanges.addElement(absoluteTransformationEvent);
        }
    }

    @Override
    public void boundChanged(BoundEvent boundEvent) {
        if (this.isThreadOK()) {
            this.dispatchBoundChange(boundEvent);
            this.markAllRenderTargetsDirty();
        } else {
            this.m_pendingBoundChanges.addElement(boundEvent);
        }
    }

    @Override
    public void childAdded(ChildrenEvent childrenEvent) {
        if (this.isThreadOK()) {
            this.dispatchChildAdd(childrenEvent);
            this.markAllRenderTargetsDirty();
        } else {
            this.m_pendingChildChanges.addElement(childrenEvent);
        }
    }

    @Override
    public void childRemoved(ChildrenEvent childrenEvent) {
        if (this.isThreadOK()) {
            this.dispatchChildRemove(childrenEvent);
            this.markAllRenderTargetsDirty();
        } else {
            this.m_pendingChildChanges.addElement(childrenEvent);
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if (this.isThreadOK()) {
            this.dispatchHierarchyChange(hierarchyEvent);
            this.markAllRenderTargetsDirty();
        } else {
            this.m_pendingHeirarchyChanges.addElement(hierarchyEvent);
        }
    }

    @Override
    public synchronized void changed(PropertyEvent propertyEvent) {
        if (this.isThreadOK()) {
            this.dispatchPropertyChange(propertyEvent);
            this.markAllRenderTargetsDirty();
        } else {
            this.m_pendingPropertyChanges.addElement(propertyEvent);
        }
    }

    @Override
    public synchronized void releasing(ReleaseEvent releaseEvent) {
    }

    @Override
    public synchronized void released(ReleaseEvent releaseEvent) {
        if (this.isThreadOK()) {
            this.dispatchRelease(releaseEvent);
            this.markAllRenderTargetsDirty();
        } else {
            this.m_pendingReleases.addElement(releaseEvent);
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public boolean addRenderTarget(RenderTarget renderTarget) {
        if (renderTarget instanceof OnscreenRenderTarget) {
            this.m_onscreenRenderTargetArray = null;
            this.m_onscreenRenderTargets.addElement(renderTarget);
        } else if (renderTarget instanceof OffscreenRenderTarget) {
            this.m_offscreenRenderTargetArray = null;
            this.m_offscreenRenderTargets.addElement(renderTarget);
        }
        return true;
    }

    public boolean removeRenderTarget(RenderTarget renderTarget) {
        if (renderTarget instanceof OnscreenRenderTarget) {
            this.m_onscreenRenderTargetArray = null;
            return this.m_onscreenRenderTargets.removeElement(renderTarget);
        }
        if (renderTarget instanceof OffscreenRenderTarget) {
            this.m_offscreenRenderTargetArray = null;
            return this.m_offscreenRenderTargets.removeElement(renderTarget);
        }
        return true;
    }

    @Override
    public OnscreenRenderTarget[] getOnscreenRenderTargets() {
        if (this.m_onscreenRenderTargetArray == null) {
            this.m_onscreenRenderTargetArray = new OnscreenRenderTarget[this.m_onscreenRenderTargets.size()];
            this.m_onscreenRenderTargets.copyInto(this.m_onscreenRenderTargetArray);
        }
        return this.m_onscreenRenderTargetArray;
    }

    @Override
    public OffscreenRenderTarget[] getOffscreenRenderTargets() {
        if (this.m_offscreenRenderTargetArray == null) {
            this.m_offscreenRenderTargetArray = new OffscreenRenderTarget[this.m_offscreenRenderTargets.size()];
            this.m_offscreenRenderTargets.copyInto(this.m_offscreenRenderTargetArray);
        }
        return this.m_offscreenRenderTargetArray;
    }

    @Override
    public synchronized void release() {
    }

    @Override
    public boolean isSoftwareEmulationForced() {
        return this.m_isSoftwareEmulationForced;
    }

    @Override
    public void setIsSoftwareEmulationForced(boolean isSoftwareEmulationForced) {
        this.m_isSoftwareEmulationForced = isSoftwareEmulationForced;
    }
}

