/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer;

import edu.cmu.cs.stage3.alice.authoringtool.AikMin;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OffscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTargetFactory;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.Renderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.util.DirectXVersion;
import java.util.Vector;

public class DefaultRenderTargetFactory
implements RenderTargetFactory {
    private Class m_rendererClass;
    private edu.cmu.cs.stage3.alice.scenegraph.renderer.Renderer m_renderer;

    public static Class[] getPotentialRendererClasses() {
        Vector<Class> vector = new Vector<Class>();
        if (AikMin.isWindows()) {
            try {
                if (DirectXVersion.getVersion() >= 7.0) {
                    vector.addElement(edu.cmu.cs.stage3.alice.scenegraph.renderer.directx7renderer.Renderer.class);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            vector.addElement(Renderer.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Object[] array = new Class[vector.size()];
        vector.copyInto(array);
        return array;
    }

    public DefaultRenderTargetFactory() {
        this(null);
    }

    public DefaultRenderTargetFactory(Class rendererClass) {
        if (rendererClass == null) {
            rendererClass = DefaultRenderTargetFactory.getPotentialRendererClasses()[0];
        }
        this.m_rendererClass = rendererClass;
    }

    @Override
    public boolean isSoftwareEmulationForced() {
        return this.getRenderer().isSoftwareEmulationForced();
    }

    @Override
    public void setIsSoftwareEmulationForced(boolean isSoftwareEmulationForced) {
        this.getRenderer().setIsSoftwareEmulationForced(isSoftwareEmulationForced);
    }

    private edu.cmu.cs.stage3.alice.scenegraph.renderer.Renderer getRenderer() {
        if (this.m_renderer == null) {
            try {
                this.m_renderer = (edu.cmu.cs.stage3.alice.scenegraph.renderer.Renderer)this.m_rendererClass.newInstance();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return this.m_renderer;
    }

    @Override
    public OffscreenRenderTarget createOffscreenRenderTarget() {
        return this.getRenderer().createOffscreenRenderTarget();
    }

    @Override
    public OnscreenRenderTarget createOnscreenRenderTarget() {
        return this.getRenderer().createOnscreenRenderTarget();
    }

    @Override
    public void releaseOffscreenRenderTarget(OffscreenRenderTarget offscreenRenderTarget) {
        offscreenRenderTarget.release();
    }

    @Override
    public void releaseOnscreenRenderTarget(OnscreenRenderTarget onscreenRenderTarget) {
        onscreenRenderTarget.release();
    }

    @Override
    public void release() {
    }
}

