/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.ElementProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.PickContext;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.PickParameters;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.RenderContext;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.SceneProxy;
import java.nio.DoubleBuffer;

abstract class ComponentProxy
extends ElementProxy {
    private double[] m_absolute = new double[16];
    private double[] m_inverseAbsolute = new double[16];
    private DoubleBuffer m_absoluteBuffer = DoubleBuffer.wrap(this.m_absolute);
    private DoubleBuffer m_inverseAbsoluteBuffer = DoubleBuffer.wrap(this.m_inverseAbsolute);

    ComponentProxy() {
        this.handleAbsoluteTransformationChange();
    }

    @Override
    protected void changed(Property property, Object value) {
        if (property != Component.PARENT_PROPERTY) {
            super.changed(property, value);
        }
    }

    public void handleAbsoluteTransformationChange() {
        this.m_absolute[0] = Double.NaN;
        this.m_inverseAbsolute[0] = Double.NaN;
    }

    private Component getSceneGraphComponent() {
        return (Component)this.getSceneGraphElement();
    }

    public SceneProxy getSceneProxy() {
        Component sgComponent = this.getSceneGraphComponent();
        Container sgRoot = sgComponent.getRoot();
        if (sgRoot instanceof Scene) {
            return (SceneProxy)this.getProxyFor(sgRoot);
        }
        return null;
    }

    public double[] getAbsoluteTransformation() {
        if (Double.isNaN(this.m_absolute[0])) {
            ComponentProxy.copy(this.m_absolute, this.getSceneGraphComponent().getAbsoluteTransformation());
        }
        return this.m_absolute;
    }

    public double[] getInverseAbsoluteTransformation() {
        if (Double.isNaN(this.m_inverseAbsolute[0])) {
            ComponentProxy.copy(this.m_inverseAbsolute, this.getSceneGraphComponent().getInverseAbsoluteTransformation());
        }
        return this.m_inverseAbsolute;
    }

    protected DoubleBuffer getAbsoluteTransformationAsBuffer() {
        this.getAbsoluteTransformation();
        return this.m_absoluteBuffer;
    }

    protected DoubleBuffer getInverseAbsoluteTransformationAsBuffer() {
        this.getInverseAbsoluteTransformation();
        return this.m_inverseAbsoluteBuffer;
    }

    public abstract void render(RenderContext var1);

    public abstract void setup(RenderContext var1);

    public abstract void pick(PickContext var1, PickParameters var2);
}

