/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer;

import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.PickContext;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.RenderContext;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.VertexGeometryProxy;

class IndexedTriangleArrayProxy
extends VertexGeometryProxy {
    private int[] m_indices;

    IndexedTriangleArrayProxy() {
    }

    @Override
    public void render(RenderContext context) {
        Integer id = context.getDisplayListID(this);
        if (id == null) {
            id = context.generateDisplayListID(this);
            this.setIsGeometryChanged(true);
        }
        if (this.isGeometryChanged()) {
            context.gl.glNewList(id.intValue(), 4865);
            context.gl.glBegin(4);
            if (this.m_indices != null) {
                int i = 0;
                while (i < this.m_indices.length) {
                    context.renderVertex(this.getVertexAt(this.m_indices[i + 2]));
                    context.renderVertex(this.getVertexAt(this.m_indices[i + 1]));
                    context.renderVertex(this.getVertexAt(this.m_indices[i + 0]));
                    i += 3;
                }
            }
            context.gl.glEnd();
            context.gl.glEndList();
            this.setIsGeometryChanged(false);
        } else {
            context.gl.glCallList(id.intValue());
        }
    }

    @Override
    public void pick(PickContext context, boolean isSubElementRequired) {
        context.gl.glPushName(-1);
        if (isSubElementRequired) {
            context.gl.glBegin(4);
            int i = 0;
            while (i < this.m_indices.length) {
                context.renderPickVertex(this.getVertexAt(this.m_indices[i + 2]));
                context.renderPickVertex(this.getVertexAt(this.m_indices[i + 1]));
                context.renderPickVertex(this.getVertexAt(this.m_indices[i + 0]));
                i += 3;
            }
            context.gl.glEnd();
        } else {
            int id = 0;
            if (this.m_indices != null) {
                int i = 0;
                while (i < this.m_indices.length) {
                    context.gl.glLoadName(id++);
                    context.gl.glBegin(4);
                    context.renderPickVertex(this.getVertexAt(this.m_indices[i + 2]));
                    context.renderPickVertex(this.getVertexAt(this.m_indices[i + 1]));
                    context.renderPickVertex(this.getVertexAt(this.m_indices[i + 0]));
                    context.gl.glEnd();
                    i += 3;
                }
            }
        }
        context.gl.glPopName();
    }

    @Override
    protected void changed(Property property, Object value) {
        if (property == IndexedTriangleArray.INDICES_PROPERTY) {
            this.m_indices = (int[])value;
            this.setIsGeometryChanged(true);
        } else if (property != IndexedTriangleArray.INDEX_LOWER_BOUND_PROPERTY && property != IndexedTriangleArray.INDEX_UPPER_BOUND_PROPERTY) {
            super.changed(property, value);
        }
    }
}

