/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.PickContext;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.VisualProxy;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Comparator;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public class PickInfo
implements edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo {
    private Component m_source;
    private Matrix4d m_projection;
    private Visual[] m_visuals;
    private boolean[] m_isFrontFacings;
    private Geometry[] m_geometries;
    private int[] m_subElements;
    private double[] m_zs;

    public PickInfo(PickContext context, IntBuffer pickBuffer, Component source) {
        this.m_source = source;
        int length = context.gl.glRenderMode(7168);
        if (length < 0) {
            length = 0;
        }
        pickBuffer.rewind();
        class PickItem {
            Visual visual;
            boolean isFrontFacing;
            Geometry geometry;
            int subElement;
            int zFront;

            PickItem(PickContext context, IntBuffer pickBuffer, int offset) {
                VisualProxy visualProxy;
                int nameCount = pickBuffer.get(offset + 0);
                this.zFront = pickBuffer.get(offset + 1);
                int zBack = pickBuffer.get(offset + 2);
                if (nameCount == 3 && (visualProxy = context.getPickVisualProxyForName(pickBuffer.get(offset + 3))) != null) {
                    this.visual = visualProxy.getSceneGraphVisual();
                    this.isFrontFacing = pickBuffer.get(offset + 4) == 1;
                    this.geometry = this.visual.getGeometry();
                    this.subElement = pickBuffer.get(offset + 5);
                }
            }
        }
        PickItem[] pickItems = new PickItem[length];
        int offset = 0;
        int i = 0;
        while (i < length) {
            pickItems[i] = new PickItem(context, pickBuffer, offset);
            offset += 6;
            ++i;
        }
        Arrays.sort(pickItems, new Comparator(){

            public int compare(Object o1, Object o2) {
                PickItem pi1 = (PickItem)o1;
                PickItem pi2 = (PickItem)o2;
                return pi1.zFront - pi2.zFront;
            }

            @Override
            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        });
        this.m_visuals = new Visual[length];
        this.m_isFrontFacings = new boolean[length];
        this.m_geometries = new Geometry[length];
        this.m_subElements = new int[length];
        this.m_zs = new double[length];
        i = 0;
        while (i < length) {
            this.m_visuals[i] = pickItems[i].visual;
            this.m_isFrontFacings[i] = pickItems[i].isFrontFacing;
            this.m_geometries[i] = pickItems[i].geometry;
            this.m_subElements[i] = pickItems[i].subElement;
            this.m_zs[i] = (float)pickItems[i].zFront / 2.1474836E9f;
            ++i;
        }
    }

    @Override
    public Component getSource() {
        return this.m_source;
    }

    @Override
    public Visual[] getVisuals() {
        return this.m_visuals;
    }

    @Override
    public Geometry[] getGeometries() {
        return this.m_geometries;
    }

    @Override
    public boolean[] isFrontFacings() {
        return this.m_isFrontFacings;
    }

    @Override
    public int[] getSubElements() {
        return this.m_subElements;
    }

    @Override
    public double[] getZs() {
        return this.m_zs;
    }

    @Override
    public int getCount() {
        if (this.m_visuals != null) {
            return this.m_visuals.length;
        }
        return 0;
    }

    @Override
    public Visual getVisualAt(int index) {
        return this.m_visuals[index];
    }

    @Override
    public boolean isFrontFacingAt(int index) {
        return this.m_isFrontFacings[index];
    }

    @Override
    public Geometry getGeometryAt(int index) {
        return this.m_geometries[index];
    }

    @Override
    public int getSubElementAt(int index) {
        return this.m_subElements[index];
    }

    @Override
    public double getZAt(int index) {
        return this.m_zs[index];
    }

    @Override
    public Vector3d getLocalPositionAt(int index) {
        return null;
    }
}

