/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.BackgroundProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.Context;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.GeometryProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.RenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.TextureMapProxy;
import java.awt.Rectangle;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.opengl.GLAutoDrawable;

class RenderContext
extends Context {
    private RenderTarget m_renderTarget;
    private int m_lastTime_nextLightID = 16384;
    private int m_nextLightID;
    private boolean m_isFogEnabled;
    private boolean m_renderOpaque;
    private float[] m_ambient = new float[4];
    private FloatBuffer m_ambientBuffer = FloatBuffer.wrap(this.m_ambient);
    private Hashtable m_displayListMap = new Hashtable();
    private Hashtable m_textureBindingMap = new Hashtable();
    private TextureMapProxy m_currTextureMapProxy;
    private boolean m_isShadingEnabled;
    private Rectangle m_clearRect = new Rectangle();

    public RenderContext(RenderTarget renderTarget) {
        this.m_renderTarget = renderTarget;
        this.m_renderOpaque = true;
    }

    @Override
    public void init(GLAutoDrawable drawable) {
        super.init(drawable);
        this.forgetAllTextureMapProxies();
        this.forgetAllGeometryProxies();
    }

    @Override
    public void display(GLAutoDrawable drawable) {
        super.display(drawable);
        this.m_renderTarget.commitAnyPendingChanges();
        this.m_clearRect.setBounds(0, 0, 0, 0);
        this.m_renderTarget.performClearAndRenderOffscreen(this);
        if (this.m_clearRect.x != 0 || this.m_clearRect.y != 0 || this.m_clearRect.width != this.m_width || this.m_clearRect.height != this.m_height) {
            this.gl.glEnable(3089);
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            try {
                if (this.m_clearRect.x > 0) {
                    this.gl.glScissor(0, 0, this.m_clearRect.x, this.m_height);
                    this.gl.glClear(16384);
                }
                if (this.m_clearRect.x + this.m_clearRect.width < this.m_width) {
                    this.gl.glScissor(this.m_clearRect.x + this.m_clearRect.width, 0, this.m_width - this.m_clearRect.width, this.m_height);
                    this.gl.glClear(16384);
                }
                if (this.m_clearRect.y > 0) {
                    this.gl.glScissor(0, 0, this.m_width, this.m_clearRect.y);
                    this.gl.glClear(16384);
                }
                if (this.m_clearRect.y + this.m_clearRect.height < this.m_height) {
                    this.gl.glScissor(0, this.m_clearRect.y + this.m_clearRect.height, this.m_width, this.m_height - this.m_clearRect.height);
                    this.gl.glClear(16384);
                }
            }
            finally {
                this.gl.glDisable(3089);
            }
        }
    }

    public void beginAffectorSetup() {
        this.m_ambient[0] = 0.0f;
        this.m_ambient[1] = 0.0f;
        this.m_ambient[2] = 0.0f;
        this.m_ambient[3] = 1.0f;
        this.m_nextLightID = 16384;
        this.m_isFogEnabled = false;
        this.m_currTextureMapProxy = null;
    }

    public void endAffectorSetup() {
        this.gl.glLightModelfv(2899, this.m_ambientBuffer);
        int id = this.m_nextLightID;
        while (id < this.m_lastTime_nextLightID) {
            this.gl.glDisable(id);
            ++id;
        }
        if (this.m_isFogEnabled) {
            this.gl.glEnable(2912);
        } else {
            this.gl.glDisable(2912);
        }
        this.m_lastTime_nextLightID = this.m_nextLightID;
        this.gl.glEnable(2929);
        this.gl.glEnable(2884);
        this.gl.glCullFace(1029);
    }

    public void clear(BackgroundProxy backgroundProxy, Rectangle viewport) {
        this.gl.glViewport(viewport.x, viewport.y, viewport.width, viewport.height);
        if (backgroundProxy != null) {
            backgroundProxy.clear(this);
        }
        if (this.m_clearRect.width == 0 || this.m_clearRect.height == 0) {
            this.m_clearRect.setBounds(viewport);
        } else {
            this.m_clearRect.union(viewport);
        }
    }

    public boolean isFogEnabled() {
        return this.m_isFogEnabled;
    }

    public void setRenderTransparent() {
        this.m_renderOpaque = false;
    }

    public void setRenderOpaque() {
        this.m_renderOpaque = true;
    }

    public boolean renderOpaque() {
        return this.m_renderOpaque;
    }

    public void setIsFogEnabled(boolean isFogEnabled) {
        this.m_isFogEnabled = isFogEnabled;
    }

    public void addAmbient(float[] color) {
        this.m_ambient[0] = this.m_ambient[0] + color[0];
        this.m_ambient[1] = this.m_ambient[1] + color[1];
        this.m_ambient[2] = this.m_ambient[2] + color[2];
    }

    public int getNextLightID() {
        int id = this.m_nextLightID++;
        return id;
    }

    public Integer getDisplayListID(GeometryProxy geometryProxy) {
        return (Integer)this.m_displayListMap.get(geometryProxy);
    }

    public Integer generateDisplayListID(GeometryProxy geometryProxy) {
        Integer id = new Integer(this.gl.glGenLists(1));
        this.m_displayListMap.put(geometryProxy, id);
        return id;
    }

    private void forgetAllGeometryProxies() {
        Enumeration enum0 = this.m_displayListMap.keys();
        while (enum0.hasMoreElements()) {
            this.forgetGeometryProxy((GeometryProxy)enum0.nextElement(), false);
        }
        this.m_displayListMap.clear();
    }

    public void forgetGeometryProxy(GeometryProxy geometryProxy, boolean removeFromMap) {
        Integer value = (Integer)this.m_displayListMap.get(geometryProxy);
        if (value != null) {
            this.gl.glDeleteLists(value.intValue(), 1);
            if (removeFromMap) {
                this.m_displayListMap.remove(geometryProxy);
            }
        }
    }

    public void forgetGeometryProxy(GeometryProxy geometryProxy) {
        this.forgetGeometryProxy(geometryProxy, true);
    }

    private void forgetAllTextureMapProxies() {
        Enumeration enum0 = this.m_textureBindingMap.keys();
        while (enum0.hasMoreElements()) {
            this.forgetTextureMapProxy((TextureMapProxy)enum0.nextElement(), false);
        }
        this.m_textureBindingMap.clear();
    }

    public void forgetTextureMapProxy(TextureMapProxy textureMapProxy, boolean removeFromMap) {
        Integer value = (Integer)this.m_textureBindingMap.get(textureMapProxy);
        if (value != null) {
            int id = value;
            IntBuffer atID = IntBuffer.allocate(1);
            atID.put(id);
            atID.rewind();
            this.gl.glDeleteTextures(atID.limit(), atID);
            if (removeFromMap) {
                this.m_textureBindingMap.remove(textureMapProxy);
            }
        }
    }

    public void forgetTextureMapProxy(TextureMapProxy textureMapProxy) {
        this.forgetTextureMapProxy(textureMapProxy, true);
    }

    public void setTextureMapProxy(TextureMapProxy textureMapProxy) {
        if (textureMapProxy != null && textureMapProxy.isImageSet()) {
            this.gl.glEnable(3553);
            if (this.m_currTextureMapProxy != textureMapProxy) {
                if (textureMapProxy != null) {
                    Integer value = (Integer)this.m_textureBindingMap.get(textureMapProxy);
                    if (textureMapProxy.prepareByteBufferIfNecessary() || value == null) {
                        int format;
                        int internalFormat;
                        if (value == null) {
                            IntBuffer atID = IntBuffer.allocate(1);
                            this.gl.glGenTextures(atID.limit(), atID);
                            value = new Integer(atID.get());
                            this.m_textureBindingMap.put(textureMapProxy, value);
                        }
                        this.gl.glBindTexture(3553, value.intValue());
                        if (textureMapProxy.isPotentiallyAlphaBlended()) {
                            internalFormat = 6408;
                            format = 6408;
                        } else {
                            internalFormat = 6407;
                            format = 6407;
                        }
                        ByteBuffer pixels = textureMapProxy.getPixels();
                        this.gl.glTexImage2D(3553, 0, internalFormat, textureMapProxy.getWidthPowerOf2(), textureMapProxy.getHeightPowerOf2(), 0, format, 5121, (Buffer)pixels);
                        this.gl.glTexParameterf(3553, 10242, 10497.0f);
                        this.gl.glTexParameterf(3553, 10243, 10497.0f);
                        this.gl.glTexParameterf(3553, 10240, 9729.0f);
                        this.gl.glTexParameterf(3553, 10241, 9729.0f);
                    } else {
                        this.gl.glBindTexture(3553, value.intValue());
                    }
                }
                this.m_currTextureMapProxy = textureMapProxy;
            }
        } else {
            this.gl.glDisable(3553);
        }
    }

    public boolean isShadingEnabled() {
        return this.m_isShadingEnabled;
    }

    public void setIsShadingEnabled(boolean isShadingEnabled) {
        this.m_isShadingEnabled = isShadingEnabled;
        if (this.m_isShadingEnabled) {
            this.gl.glEnable(2896);
        } else {
            this.gl.glDisable(2896);
        }
    }

    protected void renderVertex(Vertex3d vertex) {
        if (this.m_currTextureMapProxy != null && vertex.textureCoordinate0 != null) {
            double u = this.m_currTextureMapProxy.mapU(vertex.textureCoordinate0.x);
            double v = this.m_currTextureMapProxy.mapV(vertex.textureCoordinate0.y);
            this.gl.glTexCoord2d(u, v);
        }
        if (vertex.diffuseColor != null) {
            this.gl.glColor4f(vertex.diffuseColor.red, vertex.diffuseColor.green, vertex.diffuseColor.blue, vertex.diffuseColor.alpha);
        }
        if (this.m_isShadingEnabled) {
            this.gl.glNormal3d(vertex.normal.x, vertex.normal.y, -vertex.normal.z);
        }
        this.gl.glVertex3d(vertex.position.x, vertex.position.y, -vertex.position.z);
    }
}

