/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer;

import com.sun.opengl.util.GLUT;
import com.sun.opengl.util.Screenshot;
import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.OrthographicCamera;
import edu.cmu.cs.stage3.alice.scenegraph.PerspectiveCamera;
import edu.cmu.cs.stage3.alice.scenegraph.SymmetricPerspectiveCamera;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractProxyRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.CameraProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.Graphics;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.PickContext;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.PickInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.PickParameters;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.RenderContext;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.Renderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.SymmetricPerspectiveCameraProxy;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLPbuffer;
import javax.vecmath.Matrix4d;

public abstract class RenderTarget
extends AbstractProxyRenderTarget {
    private RenderContext m_renderContextForGetOffscreenGraphics = null;
    private IntBuffer m_pickBuffer;
    private IntBuffer m_viewportBuffer;
    GLPbuffer m_glPBuffer = null;
    private GLUT glut_ = new GLUT();
    private int displayList;

    protected RenderTarget(Renderer renderer) {
        super(renderer);
    }

    protected void performClearAndRenderOffscreen(RenderContext context) {
        this.commitAnyPendingChanges();
        this.onClear();
        context.gl.glBlendFunc(770, 771);
        context.gl.glEnable(3042);
        context.gl.glEnable(3008);
        context.gl.glAlphaFunc(516, 0.0f);
        Camera[] cameras = this.getCameras();
        int i = 0;
        while (i < cameras.length) {
            CameraProxy cameraProxyI = (CameraProxy)this.getProxyFor(cameras[i]);
            cameraProxyI.performClearAndRenderOffscreen(context);
            ++i;
        }
        try {
            this.m_renderContextForGetOffscreenGraphics = context;
            this.onRender();
        }
        finally {
            this.m_renderContextForGetOffscreenGraphics = null;
        }
        context.gl.glFlush();
    }

    public PickInfo performPick(PickContext context, PickParameters pickParameters) {
        int y;
        int x = pickParameters.getX();
        Camera sgCamera = this.getCameraAtPixel(x, y = pickParameters.getY());
        if (sgCamera != null) {
            int CAPACITY = 256;
            if (this.m_pickBuffer == null) {
                this.m_pickBuffer = ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder()).asIntBuffer();
            } else {
                this.m_pickBuffer.rewind();
            }
            context.gl.glSelectBuffer(256, this.m_pickBuffer);
            context.gl.glRenderMode(7170);
            context.gl.glInitNames();
            int width = context.getWidth();
            int height = context.getHeight();
            CameraProxy cameraProxy = (CameraProxy)this.getProxyFor(sgCamera);
            Rectangle viewport = cameraProxy.getActualViewport(width, height);
            int[] vp = new int[]{viewport.x, viewport.y, viewport.width, viewport.height};
            context.gl.glViewport(viewport.x, viewport.y, viewport.width, viewport.height);
            context.gl.glMatrixMode(5889);
            context.gl.glLoadIdentity();
            if (this.m_viewportBuffer == null) {
                this.m_viewportBuffer = IntBuffer.allocate(4);
            } else {
                this.m_viewportBuffer.rewind();
            }
            this.m_viewportBuffer.put(viewport.x);
            this.m_viewportBuffer.put(viewport.y);
            this.m_viewportBuffer.put(viewport.width);
            this.m_viewportBuffer.put(viewport.height);
            this.m_viewportBuffer.rewind();
            context.gl.glMatrixMode(5889);
            context.gl.glLoadIdentity();
            context.glu.gluPickMatrix((double)x, (double)(height - y), 1.0, 1.0, this.m_viewportBuffer);
            cameraProxy.performPick(context, pickParameters);
            context.gl.glFlush();
        }
        return new PickInfo(context, this.m_pickBuffer, sgCamera);
    }

    public void commitAnyPendingChanges() {
        ((Renderer)this.getRenderer()).commitAnyPendingChanges();
    }

    @Override
    public Matrix4d getProjectionMatrix(Camera sgCamera) {
        return sgCamera.getProjection();
    }

    @Override
    public double[] getActualPlane(OrthographicCamera sgOrthographicCamera) {
        return sgOrthographicCamera.getPlane();
    }

    @Override
    public double[] getActualPlane(PerspectiveCamera sgPerspectiveCamera) {
        return sgPerspectiveCamera.getPlane();
    }

    @Override
    public double getActualHorizontalViewingAngle(SymmetricPerspectiveCamera sgSymmetricPerspectiveCamera) {
        Dimension size = this.getSize();
        SymmetricPerspectiveCameraProxy symmetricPerspectiveCameraProxy = (SymmetricPerspectiveCameraProxy)this.getProxyFor(sgSymmetricPerspectiveCamera);
        return symmetricPerspectiveCameraProxy.getActualHorizontalViewingAngle(size.width, size.height);
    }

    @Override
    public double getActualVerticalViewingAngle(SymmetricPerspectiveCamera sgSymmetricPerspectiveCamera) {
        Dimension size = this.getSize();
        SymmetricPerspectiveCameraProxy symmetricPerspectiveCameraProxy = (SymmetricPerspectiveCameraProxy)this.getProxyFor(sgSymmetricPerspectiveCamera);
        return symmetricPerspectiveCameraProxy.getActualVerticalViewingAngle(size.width, size.height);
    }

    @Override
    public Rectangle getActualViewport(Camera sgCamera) {
        Dimension size = this.getSize();
        CameraProxy cameraProxy = (CameraProxy)this.getProxyFor(sgCamera);
        return cameraProxy.getActualViewport(size.width, size.height);
    }

    @Override
    public Rectangle getViewport(Camera sgCamera) {
        CameraProxy cameraProxy = (CameraProxy)this.getProxyFor(sgCamera);
        return cameraProxy.getViewport();
    }

    @Override
    public void setViewport(Camera sgCamera, Rectangle viewport) {
        CameraProxy cameraProxy = (CameraProxy)this.getProxyFor(sgCamera);
        cameraProxy.setViewport(viewport);
    }

    @Override
    public boolean isLetterboxedAsOpposedToDistorted(Camera sgCamera) {
        CameraProxy cameraProxy = (CameraProxy)this.getProxyFor(sgCamera);
        return cameraProxy.isLetterboxedAsOpposedToDistorted();
    }

    @Override
    public void setIsLetterboxedAsOpposedToDistorted(Camera sgCamera, boolean isLetterboxedAsOpposedToDistorted) {
        CameraProxy cameraProxy = (CameraProxy)this.getProxyFor(sgCamera);
        cameraProxy.setIsLetterboxedAsOpposedToDistorted(isLetterboxedAsOpposedToDistorted);
    }

    public void createGLBuffer(int width, int height) {
        GLDrawableFactory fac = GLDrawableFactory.getFactory();
        if (fac.canCreateGLPbuffer()) {
            GLCapabilities glCap = new GLCapabilities();
            glCap.setDoubleBuffered(false);
            glCap.setRedBits(8);
            glCap.setBlueBits(8);
            glCap.setGreenBits(8);
            glCap.setAlphaBits(8);
            this.m_glPBuffer = fac.createGLPbuffer(glCap, null, width, height, null);
        }
    }

    @Override
    public void clearAndRenderOffscreen() {
        RenderContext m_renderContext = new RenderContext(this);
        if (this.m_glPBuffer != null) {
            int height;
            GLContext context = this.m_glPBuffer.createContext(null);
            context.makeCurrent();
            context.getGL().glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            context.getGL().glClear(16640);
            Dimension d = this.getSize();
            int width = d.width;
            m_renderContext.m_height = height = d.height;
            m_renderContext.m_width = width;
            this.m_glPBuffer.addGLEventListener((GLEventListener)m_renderContext);
            this.m_glPBuffer.display();
        }
    }

    @Override
    public boolean rendersOnEdgeTrianglesAsLines(OrthographicCamera orthographicCamera) {
        return false;
    }

    @Override
    public void setRendersOnEdgeTrianglesAsLines(OrthographicCamera orthographicCamera, boolean rendersOnEdgeTrianglesAsLines) {
    }

    @Override
    public Image getOffscreenImage() {
        Dimension d = this.getSize();
        int width = d.width;
        int height = d.height;
        if (this.m_glPBuffer == null || this.m_glPBuffer.getWidth() != width || this.m_glPBuffer.getHeight() != height) {
            this.createGLBuffer(width, height);
            this.clearAndRenderOffscreen();
        }
        GLContext context = this.m_glPBuffer.createContext(null);
        context.makeCurrent();
        BufferedImage image = new BufferedImage(width, height, 2);
        image = Screenshot.readToBufferedImage((int)width, (int)height, (boolean)true);
        context.release();
        context.destroy();
        return image;
    }

    @Override
    public java.awt.Graphics getOffscreenGraphics() {
        return new Graphics(this.m_renderContextForGetOffscreenGraphics);
    }

    @Override
    public java.awt.Graphics getGraphics(TextureMap textureMap) {
        return null;
    }

    @Override
    public Image getZBufferImage() {
        return null;
    }

    @Override
    public Image getImage(TextureMap textureMap) {
        return null;
    }

    @Override
    public void copyOffscreenImageToTextureMap(TextureMap textureMap) {
    }

    public void setSilhouetteThickness(double silhouetteThickness) {
    }

    public double getSilhouetteThickness() {
        return 0.0;
    }

    private double[] getActualNearPlane(Camera sgCamera, int width, int height) {
        CameraProxy cameraProxy = (CameraProxy)this.getProxyFor(sgCamera);
        double[] ret = new double[4];
        return cameraProxy.getActualNearPlane(ret, width, height);
    }

    private Camera getCameraAtPixel(int x, int y) {
        Camera[] sgCameras = this.getCameras();
        int i = sgCameras.length - 1;
        while (i >= 0) {
            Camera sgCameraI = sgCameras[i];
            Rectangle viewportI = this.getActualViewport(sgCameraI);
            if (viewportI.contains(x, y)) {
                return sgCameraI;
            }
            --i;
        }
        return null;
    }

    private static boolean isNaN(double[] array) {
        int i = 0;
        while (i < array.length) {
            if (Double.isNaN(array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public class GLEListener
    implements GLEventListener {
        public void display(GLAutoDrawable drawable) {
            GL gl = drawable.getGL();
            gl.glClear(16640);
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
            gl.glTranslatef((float)(Math.random() - 0.5), (float)(Math.random() - 0.5), 0.0f);
            double d = 0.9 + 0.2 * Math.random();
            gl.glScaled(d, d, d);
            float[] c = new float[]{(float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f};
            gl.glMaterialfv(1032, 4609, c, 0);
            gl.glCallList(RenderTarget.this.displayList);
        }

        public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
        }

        public void init(GLAutoDrawable drawable) {
            GL gl = drawable.getGL();
            gl.glEnable(2929);
            gl.glDepthFunc(515);
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
            gl.glEnable(2896);
            gl.glEnable(16384);
            float[] ambient = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            float[] diffuse = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            float[] specular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            float[] position = new float[]{0.0f, 10.0f, -15.0f, 1.0f};
            gl.glLightfv(16384, 4611, position, 0);
            gl.glLightfv(16384, 4608, ambient, 0);
            gl.glLightfv(16384, 4609, diffuse, 0);
            gl.glLightfv(16384, 4610, specular, 0);
            gl.glClearColor(0.1f, 0.1f, 0.1f, 0.0f);
            RenderTarget.this.displayList = gl.glGenLists(1);
            gl.glNewList(RenderTarget.this.displayList, 4864);
            RenderTarget.this.glut_.glutSolidSphere(0.3, 16, 8);
            gl.glEndList();
        }

        public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
            GL gl = drawable.getGL();
            gl.glViewport(x, y, width, height);
        }
    }
}

