/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.SpotLight;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.PointLightProxy;

class SpotLightProxy
extends PointLightProxy {
    private float m_inner;
    private float m_outer;
    private float m_falloff;
    private static final float RADIANS_TO_DEGREES_FACTOR = 57.29578f;

    SpotLightProxy() {
    }

    @Override
    protected float[] getSpotDirection(float[] rv) {
        double[] absolute = this.getAbsoluteTransformation();
        rv[0] = (float)absolute[8];
        rv[1] = (float)absolute[9];
        rv[2] = (float)absolute[10];
        return rv;
    }

    @Override
    protected float getSpotCutoff() {
        return this.m_outer * 57.29578f;
    }

    @Override
    protected void changed(Property property, Object value) {
        if (property == SpotLight.INNER_BEAM_ANGLE_PROPERTY) {
            this.m_inner = ((Number)value).floatValue();
        } else if (property == SpotLight.OUTER_BEAM_ANGLE_PROPERTY) {
            this.m_outer = ((Number)value).floatValue();
        } else if (property == SpotLight.FALLOFF_PROPERTY) {
            this.m_falloff = ((Number)value).floatValue();
        } else {
            super.changed(property, value);
        }
    }
}

