/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.SymmetricPerspectiveCamera;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.CameraProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.Context;
import java.awt.Rectangle;

class SymmetricPerspectiveCameraProxy
extends CameraProxy {
    private double m_vertical;
    private double m_horizontal;
    private static final double DEFAULT_ACTUAL_VERTICAL = 0.5;
    private double[] reuse_actualNearPlane = new double[4];

    SymmetricPerspectiveCameraProxy() {
    }

    private static double radiansToDegrees(double radians) {
        return radians * 180.0 / Math.PI;
    }

    @Override
    protected Rectangle getActualLetterboxedViewport(int width, int height) {
        if (Double.isNaN(this.m_vertical) || Double.isNaN(this.m_vertical)) {
            return new Rectangle(0, 0, width, height);
        }
        double aspect = this.m_horizontal / this.m_vertical;
        double pixelAspect = (double)width / (double)height;
        if (aspect > pixelAspect) {
            int letterBoxedHeight = (int)((double)width / aspect + 0.5);
            return new Rectangle(0, (height - letterBoxedHeight) / 2, width, letterBoxedHeight);
        }
        if (aspect < pixelAspect) {
            int letterBoxedWidth = (int)((double)height * aspect + 0.5);
            return new Rectangle((width - letterBoxedWidth) / 2, 0, letterBoxedWidth, height);
        }
        return new Rectangle(0, 0, width, height);
    }

    public double getActualHorizontalViewingAngle(int width, int height) {
        if (Double.isNaN(this.m_horizontal)) {
            double aspect = (double)width / (double)height;
            if (Double.isNaN(this.m_vertical)) {
                return 0.5 * aspect;
            }
            return this.m_vertical * aspect;
        }
        return this.m_horizontal;
    }

    public double getActualVerticalViewingAngle(int width, int height) {
        if (Double.isNaN(this.m_vertical)) {
            double aspect = (double)width / (double)height;
            if (Double.isNaN(this.m_horizontal)) {
                return 0.5;
            }
            return this.m_horizontal / aspect;
        }
        return this.m_vertical;
    }

    @Override
    protected double[] getActualNearPlane(double[] ret, int width, int height, double near) {
        double vertical = this.m_vertical;
        double horizontal = this.m_horizontal;
        if (Double.isNaN(horizontal)) {
            if (Double.isNaN(vertical)) {
                vertical = 0.5;
            }
            horizontal = vertical * (double)width / (double)height;
        } else if (Double.isNaN(vertical)) {
            vertical = horizontal * (double)height / (double)width;
        }
        double y = Math.tan(vertical * 0.5) * near;
        double x = horizontal * y / vertical;
        ret[0] = -x;
        ret[1] = -y;
        ret[2] = x;
        ret[3] = y;
        return ret;
    }

    @Override
    protected void projection(Context context, int width, int height, float near, float far) {
        this.getActualNearPlane(this.reuse_actualNearPlane, width, height, near);
        context.gl.glFrustum(this.reuse_actualNearPlane[0], this.reuse_actualNearPlane[2], this.reuse_actualNearPlane[1], this.reuse_actualNearPlane[3], (double)near, (double)far);
    }

    @Override
    protected void changed(Property property, Object value) {
        if (property == SymmetricPerspectiveCamera.VERTICAL_VIEWING_ANGLE_PROPERTY) {
            this.m_vertical = ((Number)value).doubleValue();
        } else if (property == SymmetricPerspectiveCamera.HORIZONTAL_VIEWING_ANGLE_PROPERTY) {
            this.m_horizontal = ((Number)value).doubleValue();
        } else {
            super.changed(property, value);
        }
    }
}

