/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer;

import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.ElementProxy;
import edu.cmu.cs.stage3.image.ImageUtilities;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Hashtable;

class TextureMapProxy
extends ElementProxy {
    private int m_width;
    private int m_height;
    private int m_width2;
    private int m_height2;
    private float m_uFactor;
    private float m_vFactor;
    private ByteBuffer m_byteBuffer;
    private boolean m_isPrepared = false;

    TextureMapProxy() {
    }

    private TextureMap getSGTexture() {
        return (TextureMap)this.getSceneGraphElement();
    }

    public boolean isPotentiallyAlphaBlended() {
        return true;
    }

    public boolean isImageSet() {
        return this.getSGTexture().getImage() != null;
    }

    private static int getPowerOf2(int fold) {
        int ret = 2;
        while (ret < fold) {
            ret *= 2;
        }
        return ret;
    }

    public boolean prepareByteBufferIfNecessary() {
        if (this.m_isPrepared) {
            return false;
        }
        Image image = this.getSGTexture().getImage();
        if (image != null) {
            ComponentColorModel colorModel;
            boolean isPotentiallyAlphaBlended = this.isPotentiallyAlphaBlended();
            if (isPotentiallyAlphaBlended) {
                colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
            } else {
                int[] nArray = new int[4];
                nArray[0] = 8;
                nArray[1] = 8;
                nArray[2] = 8;
                colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nArray, false, false, 1, 0);
            }
            try {
                this.m_width = ImageUtilities.getWidth(image);
                this.m_height = ImageUtilities.getHeight(image);
            }
            catch (InterruptedException ie) {
                throw new ExceptionWrapper(ie, "");
            }
            this.m_width2 = TextureMapProxy.getPowerOf2(this.m_width);
            this.m_height2 = TextureMapProxy.getPowerOf2(this.m_height);
            this.m_uFactor = (float)this.m_width / (float)this.m_width2;
            this.m_vFactor = (float)this.m_height / (float)this.m_height2;
            int bands = isPotentiallyAlphaBlended ? 4 : 3;
            WritableRaster raster = Raster.createInterleavedRaster(0, this.m_width2, this.m_height2, bands, null);
            BufferedImage bufferedImage = new BufferedImage(colorModel, raster, false, new Hashtable());
            Graphics g = bufferedImage.getGraphics();
            g.drawImage(image, 0, 0, null);
            byte[] data = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            this.m_byteBuffer = ByteBuffer.allocateDirect(data.length);
            this.m_byteBuffer.order(ByteOrder.nativeOrder());
            this.m_byteBuffer.put(data, 0, data.length);
            this.m_byteBuffer.rewind();
        } else {
            this.m_byteBuffer = null;
            this.m_width = 0;
            this.m_height = 0;
        }
        this.m_isPrepared = true;
        return true;
    }

    public ByteBuffer getPixels() {
        return this.m_byteBuffer;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getWidthPowerOf2() {
        return this.m_width2;
    }

    public int getHeight() {
        return this.m_height;
    }

    public int getHeightPowerOf2() {
        return this.m_height2;
    }

    public float mapU(float u) {
        return u * this.m_uFactor;
    }

    public float mapV(float v) {
        return (1.0f - v) * this.m_vFactor;
    }

    @Override
    protected void changed(Property property, Object value) {
        if (property == TextureMap.IMAGE_PROPERTY) {
            this.m_isPrepared = false;
        } else if (property == TextureMap.FORMAT_PROPERTY) {
            this.m_isPrepared = false;
        } else {
            super.changed(property, value);
        }
    }
}

