/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.AppearanceProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.ComponentProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.GeometryProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.PickContext;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.PickParameters;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.RenderContext;
import java.nio.DoubleBuffer;
import javax.vecmath.Matrix3d;

class VisualProxy
extends ComponentProxy {
    private AppearanceProxy m_frontFacingAppearanceProxy = null;
    private AppearanceProxy m_backFacingAppearanceProxy = null;
    private GeometryProxy m_geometryProxy = null;
    private boolean m_isShowing = false;
    private double[] m_scale = new double[16];
    private DoubleBuffer m_scaleBuffer = DoubleBuffer.wrap(this.m_scale);

    VisualProxy() {
    }

    public Visual getSceneGraphVisual() {
        return (Visual)this.getSceneGraphElement();
    }

    @Override
    protected void changed(Property property, Object value) {
        if (property == Visual.FRONT_FACING_APPEARANCE_PROPERTY) {
            this.m_frontFacingAppearanceProxy = (AppearanceProxy)this.getProxyFor((Appearance)value);
        } else if (property == Visual.BACK_FACING_APPEARANCE_PROPERTY) {
            this.m_backFacingAppearanceProxy = (AppearanceProxy)this.getProxyFor((Appearance)value);
        } else if (property == Visual.GEOMETRY_PROPERTY) {
            this.m_geometryProxy = (GeometryProxy)this.getProxyFor((Geometry)value);
        } else if (property == Visual.SCALE_PROPERTY) {
            VisualProxy.copy(this.m_scale, (Matrix3d)value);
        } else if (property == Visual.IS_SHOWING_PROPERTY) {
            this.m_isShowing = value != null && (Boolean)value != false;
        } else if (property != Visual.DISABLED_AFFECTORS_PROPERTY) {
            super.changed(property, value);
        }
    }

    @Override
    public void setup(RenderContext context) {
    }

    private double opacity() {
        if (this.m_isShowing && this.m_geometryProxy != null) {
            if (this.m_frontFacingAppearanceProxy != null) {
                return this.m_frontFacingAppearanceProxy.Showing();
            }
            if (this.m_backFacingAppearanceProxy != null) {
                return this.m_backFacingAppearanceProxy.Showing();
            }
        }
        return 0.0;
    }

    @Override
    public void render(RenderContext context) {
        if (this.opacity() > 0.0) {
            if (this.opacity() < 1.0 && context.renderOpaque()) {
                return;
            }
            if (this.opacity() == 1.0 && !context.renderOpaque()) {
                return;
            }
            if (this.m_frontFacingAppearanceProxy != null) {
                if (this.m_backFacingAppearanceProxy != null) {
                    context.gl.glDisable(2884);
                } else {
                    context.gl.glEnable(2884);
                    context.gl.glCullFace(1029);
                }
            } else if (this.m_backFacingAppearanceProxy != null) {
                context.gl.glEnable(2884);
                context.gl.glCullFace(1028);
            }
            if (this.m_frontFacingAppearanceProxy == this.m_backFacingAppearanceProxy) {
                if (this.m_frontFacingAppearanceProxy != null) {
                    this.m_frontFacingAppearanceProxy.setPipelineState(context, 1032);
                }
            } else {
                if (this.m_frontFacingAppearanceProxy != null) {
                    this.m_frontFacingAppearanceProxy.setPipelineState(context, 1028);
                }
                if (this.m_backFacingAppearanceProxy != null) {
                    this.m_backFacingAppearanceProxy.setPipelineState(context, 1029);
                }
            }
            context.gl.glPushMatrix();
            context.gl.glMultMatrixd(this.m_scaleBuffer);
            this.m_geometryProxy.render(context);
            context.gl.glPopMatrix();
            context.gl.glDepthMask(true);
        }
    }

    @Override
    public void pick(PickContext context, PickParameters pickParameters) {
        if (this.opacity() > 0.0) {
            context.gl.glPushMatrix();
            context.gl.glMultMatrixd(this.m_scaleBuffer);
            context.gl.glPushName(context.getPickNameForVisualProxy(this));
            context.gl.glEnable(2884);
            if (this.m_backFacingAppearanceProxy != null) {
                context.gl.glCullFace(1028);
                context.gl.glPushName(0);
                this.m_geometryProxy.pick(context, pickParameters.isSubElementRequired());
                context.gl.glPopName();
            }
            if (this.m_frontFacingAppearanceProxy != null) {
                context.gl.glCullFace(1029);
                context.gl.glPushName(1);
                this.m_geometryProxy.pick(context, pickParameters.isSubElementRequired());
                context.gl.glPopName();
            }
            context.gl.glPopName();
            context.gl.glPopMatrix();
        }
    }
}

