/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer;

import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.RenderTargetAdapter;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public abstract class RenderCanvas
extends Canvas {
    private int m_nativeInstance;
    private int m_nativeDrawingSurfaceInfo = 0;
    private OnscreenRenderTarget m_onscreenRenderTarget;
    private boolean m_giveUp = false;
    private int count = 0;

    protected abstract void createNativeInstance(RenderTargetAdapter var1);

    protected abstract void releaseNativeInstance();

    protected abstract boolean acquireDrawingSurface();

    protected abstract void releaseDrawingSurface();

    protected abstract void swapBuffers();

    protected RenderCanvas(OnscreenRenderTarget onscreenRenderTarget) {
        this.m_onscreenRenderTarget = onscreenRenderTarget;
        this.createNativeInstance(this.m_onscreenRenderTarget.getAdapter());
        this.addKeyListener(new KeyAdapter(){});
    }

    protected void finalize() throws Throwable {
        this.releaseNativeInstance();
        super.finalize();
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        Container parent = this.getParent();
        if (parent != null) {
            parent.dispatchEvent(e);
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void paint(Graphics graphics) {
        if (this.m_giveUp) return;
        int width = this.getWidth();
        int height = this.getHeight();
        if (width != 0 && height != 0) {
            try {
                this.m_onscreenRenderTarget.getAdapter().setDesiredSize(width, height);
                this.m_onscreenRenderTarget.clearAndRenderOffscreen();
                this.m_onscreenRenderTarget.update();
                return;
            }
            catch (RuntimeException re) {
                if (this.count != 0) return;
                ++this.count;
                Object[] buttonLabels = new Object[]{"Retry", "Give up"};
                if (DialogManager.showOptionDialog("A error has occured in attempting to draw the scene.  Simply retrying might fix the problem.", "Potential Problem", 0, 2, null, buttonLabels, buttonLabels[0]) == 0) {
                    this.m_onscreenRenderTarget.getAdapter().reset();
                    this.repaint();
                    this.count = 0;
                    return;
                }
                this.m_giveUp = true;
                throw re;
            }
        } else {
            this.repaint();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }
}

