/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.OrthographicCamera;
import edu.cmu.cs.stage3.alice.scenegraph.PerspectiveCamera;
import edu.cmu.cs.stage3.alice.scenegraph.SymmetricPerspectiveCamera;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractProxyRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.CameraProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.ComponentProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.GeometryProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.OrthographicCameraProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.PerspectiveCameraProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.PickInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.RenderTargetAdapter;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.Renderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.SymmetricPerspectiveCameraProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.TextureMapProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.VisualProxy;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.vecmath.Matrix4d;

public abstract class RenderTarget
extends AbstractProxyRenderTarget {
    private RenderTargetAdapter m_adapter;
    private Dictionary m_cameraViewportMap = new Hashtable();

    protected RenderTargetAdapter getAdapter() {
        return this.m_adapter;
    }

    RenderTarget(Renderer renderer) {
        super(renderer);
        this.m_adapter = renderer.createRenderTargetAdapter(this);
    }

    @Override
    public void release() {
        super.release();
        this.m_adapter.release();
    }

    @Override
    public Graphics getOffscreenGraphics() {
        return this.m_adapter.getOffscreenGraphics();
    }

    @Override
    public Graphics getGraphics(TextureMap textureMap) {
        return this.m_adapter.getGraphics((TextureMapProxy)this.getProxyFor(textureMap));
    }

    @Override
    public Matrix4d getProjectionMatrix(Camera sgCamera) {
        return this.m_adapter.getProjectionMatrix((CameraProxy)this.getProxyFor(sgCamera));
    }

    @Override
    public double[] getActualPlane(OrthographicCamera sgOrthographicCamera) {
        return this.m_adapter.getActualPlane((OrthographicCameraProxy)this.getProxyFor(sgOrthographicCamera));
    }

    @Override
    public double[] getActualPlane(PerspectiveCamera sgPerspectiveCamera) {
        return this.m_adapter.getActualPlane((PerspectiveCameraProxy)this.getProxyFor(sgPerspectiveCamera));
    }

    @Override
    public double getActualHorizontalViewingAngle(SymmetricPerspectiveCamera sgSymmetricPerspectiveCamera) {
        return this.m_adapter.getActualHorizontalViewingAngle((SymmetricPerspectiveCameraProxy)this.getProxyFor(sgSymmetricPerspectiveCamera));
    }

    @Override
    public double getActualVerticalViewingAngle(SymmetricPerspectiveCamera sgSymmetricPerspectiveCamera) {
        return this.m_adapter.getActualVerticalViewingAngle((SymmetricPerspectiveCameraProxy)this.getProxyFor(sgSymmetricPerspectiveCamera));
    }

    @Override
    public Rectangle getActualViewport(Camera sgCamera) {
        return this.m_adapter.getActualViewport((CameraProxy)this.getProxyFor(sgCamera));
    }

    @Override
    public Rectangle getViewport(Camera sgCamera) {
        return (Rectangle)this.m_cameraViewportMap.get(sgCamera);
    }

    @Override
    public void setViewport(Camera sgCamera, Rectangle viewport) {
        CameraProxy cameraProxy = (CameraProxy)this.getProxyFor(sgCamera);
        if (viewport == null) {
            this.m_adapter.onViewportChange(cameraProxy, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.m_cameraViewportMap.remove(sgCamera);
        } else {
            this.m_adapter.onViewportChange(cameraProxy, viewport.x, viewport.y, viewport.width, viewport.height);
            this.m_cameraViewportMap.put(sgCamera, viewport);
        }
    }

    @Override
    public boolean rendersOnEdgeTrianglesAsLines(OrthographicCamera sgOrthographicCamera) {
        return this.m_adapter.rendersOnEdgeTrianglesAsLines((OrthographicCameraProxy)this.getProxyFor(sgOrthographicCamera));
    }

    @Override
    public void setRendersOnEdgeTrianglesAsLines(OrthographicCamera sgOrthographicCamera, boolean rendersOnEdgeTrianglesAsLines) {
        this.m_adapter.setRendersOnEdgeTrianglesAsLines((OrthographicCameraProxy)this.getProxyFor(sgOrthographicCamera), rendersOnEdgeTrianglesAsLines);
    }

    @Override
    public boolean isLetterboxedAsOpposedToDistorted(Camera sgCamera) {
        return this.m_adapter.isLetterboxedAsOpposedToDistorted((CameraProxy)this.getProxyFor(sgCamera));
    }

    @Override
    public void setIsLetterboxedAsOpposedToDistorted(Camera sgCamera, boolean isLetterboxedAsOpposedToDistorted) {
        this.m_adapter.setIsLetterboxedAsOpposedToDistorted((CameraProxy)this.getProxyFor(sgCamera), isLetterboxedAsOpposedToDistorted);
    }

    public void commitAnyPendingChanges() {
        ((Renderer)this.getRenderer()).commitAnyPendingChanges();
    }

    @Override
    public void clearAndRenderOffscreen() {
        this.commitAnyPendingChanges();
        Camera[] sgCameras = this.getCameras();
        if (sgCameras.length > 0) {
            int i = 0;
            while (i < sgCameras.length) {
                CameraProxy cameraProxy = (CameraProxy)this.getProxyFor(sgCameras[i]);
                this.m_adapter.clear(cameraProxy, i == 0);
                this.onClear();
                ComponentProxy.updateAbsoluteTransformationChanges();
                GeometryProxy.updateBoundChanges();
                this.m_adapter.render(cameraProxy);
                this.onRender();
                ++i;
            }
        }
    }

    private CameraProxy getCameraProxy(int x, int y) {
        Camera[] sgCameras;
        if (x >= 0 && y >= 0 && x < this.m_adapter.getWidth() && y < this.m_adapter.getHeight() && (sgCameras = this.getCameras()) != null) {
            int i = 0;
            while (i < sgCameras.length) {
                CameraProxy cameraProxy = (CameraProxy)this.getProxyFor(sgCameras[i]);
                Rectangle viewport = this.m_adapter.getActualViewport(cameraProxy);
                if (viewport != null) {
                    if (viewport.contains(x, y)) {
                        return cameraProxy;
                    }
                } else {
                    return cameraProxy;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo pick(int x, int y, boolean isSubElementRequired, boolean isOnlyFrontMostRequired) {
        this.commitAnyPendingChanges();
        CameraProxy cameraProxy = this.getCameraProxy(x, y);
        if (cameraProxy != null) {
            int[] atVisual = new int[1];
            boolean[] atIsFrontFacing = new boolean[]{true};
            int[] atSubElement = new int[]{-1};
            double[] atZ = new double[]{Double.NaN};
            this.m_adapter.pick(cameraProxy, x, y, isSubElementRequired, isOnlyFrontMostRequired, atVisual, atIsFrontFacing, atSubElement, atZ);
            Visual[] sgVisuals = null;
            Geometry[] sgGeometries = null;
            int[] subElements = null;
            boolean[] isFrontFacings = null;
            VisualProxy visualProxy = VisualProxy.map(atVisual[0]);
            if (visualProxy != null) {
                sgVisuals = new Visual[]{(Visual)visualProxy.getSceneGraphElement()};
                sgGeometries = new Geometry[]{sgVisuals[0].getGeometry()};
                subElements = new int[]{atSubElement[0]};
                isFrontFacings = new boolean[]{atIsFrontFacing[0]};
            }
            return new PickInfo(this, (Camera)cameraProxy.getSceneGraphElement(), x, y, sgVisuals, isFrontFacings, sgGeometries, subElements);
        }
        return null;
    }

    @Override
    public Image getOffscreenImage() {
        int width = this.m_adapter.getWidth();
        int height = this.m_adapter.getHeight();
        int pitch = this.m_adapter.getPitch();
        int bitCount = this.m_adapter.getBitCount();
        int redBitMask = this.m_adapter.getRedBitMask();
        int greenBitMask = this.m_adapter.getGreenBitMask();
        int blueBitMask = this.m_adapter.getBlueBitMask();
        int alphaBitMask = this.m_adapter.getAlphaBitMask();
        int[] pixels = new int[width * height];
        this.m_adapter.getPixels(0, 0, width, height, pitch, bitCount, redBitMask, greenBitMask, blueBitMask, alphaBitMask, pixels);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        bufferedImage.setRGB(0, 0, width, height, pixels, 0, width);
        return bufferedImage;
    }

    @Override
    public Image getZBufferImage() {
        int width = this.m_adapter.getWidth();
        int height = this.m_adapter.getHeight();
        int zPitch = this.m_adapter.getZBufferPitch();
        int zBitCount = this.m_adapter.getZBufferBitCount();
        int[] zPixels = new int[width * height];
        this.m_adapter.getZBufferPixels(0, 0, width, height, zPitch, zBitCount, zPixels);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        bufferedImage.setRGB(0, 0, width, height, zPixels, 0, width);
        return bufferedImage;
    }

    @Override
    public Image getImage(TextureMap textureMap) {
        TextureMapProxy textureMapProxy = (TextureMapProxy)this.getProxyFor(textureMap);
        int width = this.m_adapter.getWidth(textureMapProxy);
        int height = this.m_adapter.getHeight(textureMapProxy);
        int pitch = this.m_adapter.getPitch(textureMapProxy);
        int bitCount = this.m_adapter.getBitCount(textureMapProxy);
        int redBitMask = this.m_adapter.getRedBitMask(textureMapProxy);
        int greenBitMask = this.m_adapter.getGreenBitMask(textureMapProxy);
        int blueBitMask = this.m_adapter.getBlueBitMask(textureMapProxy);
        int alphaBitMask = this.m_adapter.getAlphaBitMask(textureMapProxy);
        int[] pixels = new int[width * height];
        this.m_adapter.getPixels(textureMapProxy, 0, 0, width, height, pitch, bitCount, redBitMask, greenBitMask, blueBitMask, alphaBitMask, pixels);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        bufferedImage.setRGB(0, 0, width, height, pixels, 0, width);
        return bufferedImage;
    }

    @Override
    public void copyOffscreenImageToTextureMap(TextureMap textureMap) {
        TextureMapProxy textureMapProxy = (TextureMapProxy)this.getProxyFor(textureMap);
        this.m_adapter.blt(textureMapProxy);
        this.markDirty();
    }

    public void setSilhouetteThickness(double silhouetteThickness) {
        this.m_adapter.setSilhouetteThickness(silhouetteThickness);
    }

    public double getSilhouetteThickness() {
        return this.m_adapter.getSilhouetteThickness();
    }
}

