/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.util;

import edu.cmu.cs.stage3.alice.scenegraph.util.Triangulator;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;

public class Triangle {
    public Point2d[] vertices = new Point2d[3];
    private static Point2d[] sorted = new Point2d[3];
    private static Vector2d[] sides = new Vector2d[2];

    public Triangle(Point2d a, Point2d b, Point2d c) {
        this.vertices[0] = a;
        this.vertices[1] = b;
        this.vertices[2] = c;
    }

    public static double signedArea(Point2d vertex0, Point2d vertex1, Point2d vertex2) {
        Point2d temp;
        Triangle.sorted[0] = vertex0;
        Triangle.sorted[1] = vertex1;
        Triangle.sorted[2] = vertex2;
        int sign = 1;
        if (Triangulator.pointCompare(sorted[0], sorted[1]) > 0) {
            sign = -sign;
            temp = sorted[0];
            Triangle.sorted[0] = sorted[1];
            Triangle.sorted[1] = temp;
        }
        if (Triangulator.pointCompare(sorted[1], sorted[2]) > 0) {
            sign = -sign;
            temp = sorted[1];
            Triangle.sorted[1] = sorted[2];
            Triangle.sorted[2] = temp;
        }
        if (Triangulator.pointCompare(sorted[0], sorted[1]) > 0) {
            sign = -sign;
            temp = sorted[0];
            Triangle.sorted[0] = sorted[1];
            Triangle.sorted[1] = temp;
        }
        return (double)sign * ((Triangle.sorted[0].x - Triangle.sorted[1].x) * (Triangle.sorted[1].y - Triangle.sorted[2].y) + (Triangle.sorted[1].y - Triangle.sorted[0].y) * (Triangle.sorted[1].x - Triangle.sorted[2].x));
    }

    public static int orientation(Point2d vertex0, Point2d vertex1, Point2d vertex2) {
        double sa = Triangle.signedArea(vertex0, vertex1, vertex2);
        if (sa < 0.0) {
            return -1;
        }
        if (sa > 0.0) {
            return 1;
        }
        return 0;
    }

    public static int convex(Point2d vertex0, Point2d vertex1, Point2d vertex2) {
        if (Triangulator.pointCompare(vertex0, vertex1) == 0) {
            return 1;
        }
        if (Triangulator.pointCompare(vertex1, vertex2) == 0) {
            return -1;
        }
        int o = Triangle.orientation(vertex0, vertex1, vertex2);
        if (o != 0) {
            return o;
        }
        Triangle.sides[0] = new Vector2d((Tuple2d)vertex0);
        sides[0].sub((Tuple2d)vertex1);
        Triangle.sides[1] = new Vector2d((Tuple2d)vertex2);
        sides[1].sub((Tuple2d)vertex1);
        if (sides[0].dot(sides[1]) < 0.0) {
            return 0;
        }
        return -2;
    }

    public static boolean inCone(Point2d vertex0, Point2d vertex1, Point2d vertex2, Point2d check) {
        if (Triangle.convex(vertex0, vertex1, vertex2) > 0) {
            int tri;
            if (Triangulator.pointCompare(vertex0, check) != 0 && Triangulator.pointCompare(vertex1, check) != 0) {
                tri = Triangle.orientation(vertex0, vertex1, check);
                if (tri < 0) {
                    return false;
                }
                if (tri == 0 && (Triangulator.pointCompare(vertex0, vertex1) < 0 ? Triangulator.pointCompare(check, vertex0) < 0 || Triangulator.pointCompare(check, vertex1) > 0 : Triangulator.pointCompare(check, vertex1) < 0 || Triangulator.pointCompare(check, vertex0) > 0)) {
                    return false;
                }
            }
            if (Triangulator.pointCompare(vertex2, check) != 0 && Triangulator.pointCompare(vertex1, vertex2) != 0) {
                tri = Triangle.orientation(vertex1, vertex2, check);
                if (tri < 0) {
                    return false;
                }
                if (tri == 0 && (Triangulator.pointCompare(vertex1, vertex2) < 0 ? Triangulator.pointCompare(check, vertex1) < 0 || Triangulator.pointCompare(check, vertex2) > 0 : Triangulator.pointCompare(check, vertex2) < 0 || Triangulator.pointCompare(check, vertex1) > 0)) {
                    return false;
                }
            }
        } else if (Triangle.orientation(vertex0, vertex1, check) <= 0 && Triangle.orientation(vertex1, vertex2, check) < 0) {
            return false;
        }
        return true;
    }
}

