/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.util;

import edu.cmu.cs.stage3.alice.scenegraph.util.DistanceComparator;
import edu.cmu.cs.stage3.alice.scenegraph.util.PointComparator;
import edu.cmu.cs.stage3.alice.scenegraph.util.PointNode;
import edu.cmu.cs.stage3.alice.scenegraph.util.SegmentBBox;
import edu.cmu.cs.stage3.alice.scenegraph.util.Triangle;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Vector;
import javax.vecmath.Point2d;

public class Triangulator {
    private Vector contours;
    public Vector points;
    public Vector triangles = new Vector();
    public static PointComparator pc = new PointComparator();

    public Triangulator() {
        this.contours = new Vector();
        this.points = new Vector();
    }

    private Vector linkedListToVector(PointNode head) {
        Vector<PointNode> returnVal = new Vector<PointNode>();
        PointNode cur = head;
        do {
            returnVal.add(cur);
        } while ((cur = cur.next) != head && cur != null);
        return returnVal;
    }

    private void reverseContour(PointNode first) {
        PointNode cur = first.next;
        first.next = first.prev;
        first.prev = cur;
        while (cur != first && cur != null) {
            PointNode temp = cur.next;
            cur.next = cur.prev;
            cur.prev = temp;
            cur = temp;
        }
        this.contours.setElementAt(first.next, this.contours.indexOf(first));
    }

    public int indexOfPoint(Point2d tofind) {
        ListIterator li = this.points.listIterator();
        int i = 0;
        while (li.hasNext()) {
            if (Triangulator.pointCompare((Point2d)li.next(), tofind) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int pointCompare(Point2d p1, Point2d p2) {
        if (p1.x < p2.x) {
            return -1;
        }
        if (p1.x > p2.x) {
            return 1;
        }
        if (p1.y < p2.y) {
            return -1;
        }
        if (p1.y > p2.y) {
            return 1;
        }
        return 0;
    }

    private boolean intersectsContour(PointNode head, SegmentBBox seg) {
        PointNode cur = head;
        do {
            if (!seg.segmentOverlaps(cur.data, cur.next.data)) continue;
            return true;
        } while ((cur = cur.next) != head && cur != null);
        return false;
    }

    private double polygonArea(PointNode head) {
        PointNode cur = head.next;
        double area = 0.0;
        while (cur.next != head && cur != null) {
            area += Triangle.signedArea(head.data, cur.data, cur.next.data);
            cur = cur.next;
        }
        return area;
    }

    public void addContour(Point2d[] contour) {
        PointNode first;
        if (contour.length < 1) {
            return;
        }
        int curpoint = this.points.size();
        first.next = first = new PointNode(contour[0]);
        first.prev = first;
        this.points.add(contour[0]);
        int i = 1;
        while (i < contour.length) {
            PointNode newPoint = new PointNode(contour[i]);
            first.prev.insertAfter(newPoint);
            this.points.add(contour[i]);
            ++i;
        }
        this.contours.add(first);
    }

    public void addContour(Vector contour) {
        PointNode first;
        if (contour.isEmpty()) {
            return;
        }
        int curpoint = this.points.size();
        first.next = first = new PointNode((Point2d)contour.firstElement());
        first.prev = first;
        this.points.add(contour.firstElement());
        ListIterator li = contour.listIterator(1);
        while (li.hasNext()) {
            Point2d cur = (Point2d)li.next();
            PointNode newPoint = new PointNode(cur);
            first.prev.insertAfter(newPoint);
            this.points.add(cur);
        }
        this.contours.add(first);
    }

    public void debug(String str) {
        System.out.println("-------------------------------------");
        System.out.println(str);
        System.out.println("-------------------------------------");
        System.out.println("Points");
        int i = 0;
        while (i < this.points.size()) {
            System.out.println(String.valueOf(String.valueOf(i)) + ": (" + String.valueOf(((Point2d)this.points.elementAt((int)i)).x) + "," + String.valueOf(((Point2d)this.points.elementAt((int)i)).y) + ")");
            ++i;
        }
        System.out.println();
        System.out.println("Contours");
        i = 0;
        while (i < this.contours.size()) {
            System.out.print("Contour " + String.valueOf(i) + ": ");
            PointNode cur = (PointNode)this.contours.elementAt(i);
            do {
                System.out.print(String.valueOf(String.valueOf(this.indexOfPoint(cur.data))) + ",");
            } while ((cur = cur.next) != this.contours.elementAt(i) && cur != null);
            System.out.println();
            ++i;
        }
    }

    public void debug2(String str) {
        System.out.println("-------------------------------------");
        System.out.println(str);
        System.out.println("-------------------------------------");
        System.out.println("Points");
        int i = 0;
        while (i < this.points.size()) {
            System.out.println(String.valueOf(String.valueOf(i)) + ": (" + String.valueOf(((Point2d)this.points.elementAt((int)i)).x) + "," + String.valueOf(((Point2d)this.points.elementAt((int)i)).y) + ")");
            ++i;
        }
        System.out.println();
        System.out.println("Contours");
        i = 0;
        while (i < this.contours.size()) {
            System.out.println("Contour " + String.valueOf(i));
            PointNode cur = (PointNode)this.contours.elementAt(i);
            do {
                System.out.println(String.valueOf(String.valueOf(this.indexOfPoint(cur.data))) + ": " + String.valueOf(this.isEar(cur)) + "," + String.valueOf(cur.convex()));
            } while ((cur = cur.next) != this.contours.elementAt(i) && cur != null);
            System.out.println();
            ++i;
        }
    }

    public Vector triangulate() {
        this.sortData();
        this.removeDuplicates();
        this.adjustOrientations();
        this.buildBridges();
        this.triangles.clear();
        boolean changed = true;
        while (changed) {
            changed = false;
            Vector ears = this.determineEars();
            ListIterator li = ears.listIterator();
            while (li.hasNext()) {
                if (!this.clipEar((PointNode)li.next())) continue;
                changed = true;
            }
        }
        if (this.linkedListToVector((PointNode)this.contours.firstElement()).size() == 3) {
            this.triangles.add(((PointNode)this.contours.firstElement()).triangle());
        }
        return this.triangles;
    }

    private void sortData() {
        if (this.points.isEmpty() || this.contours.isEmpty()) {
            return;
        }
        Collections.sort(this.points, pc);
        ListIterator li = this.contours.listIterator();
        int i = 0;
        while (li.hasNext()) {
            PointNode first;
            PointNode left = first = (PointNode)li.next();
            PointNode cur = first.next;
            while (cur != first && cur != null) {
                if (cur.compareTo(left) < 0) {
                    left = cur;
                }
                cur = cur.next;
            }
            this.contours.setElementAt(left, i);
            ++i;
        }
        Collections.sort(this.contours);
    }

    private void removeDuplicates() {
        Point2d prevPoint = (Point2d)this.points.firstElement();
        ListIterator li2 = this.points.listIterator(1);
        while (li2.hasNext()) {
            Point2d curPoint = (Point2d)li2.next();
            boolean makeChange = false;
            while (Triangulator.pointCompare(curPoint, prevPoint) == 0) {
                li2.remove();
                makeChange = true;
                if (!li2.hasNext()) break;
                curPoint = (Point2d)li2.next();
            }
            if (makeChange) {
                ListIterator li = this.contours.listIterator();
                while (li.hasNext()) {
                    PointNode first;
                    PointNode cur = first = (PointNode)li.next();
                    do {
                        if (cur.compareTo(prevPoint) != 0) continue;
                        cur.data = prevPoint;
                    } while ((cur = cur.next) != first && cur != null);
                }
                continue;
            }
            prevPoint = curPoint;
        }
    }

    private void adjustOrientations() {
        if (this.polygonArea((PointNode)this.contours.firstElement()) < 0.0) {
            this.reverseContour((PointNode)this.contours.firstElement());
        }
        ListIterator li = this.contours.listIterator(1);
        while (li.hasNext()) {
            PointNode cur = (PointNode)li.next();
            if (!(this.polygonArea(cur) > 0.0)) continue;
            this.reverseContour(cur);
        }
    }

    private void buildBridges() {
        DistanceComparator dc = new DistanceComparator();
        ListIterator li = this.contours.listIterator();
        block0: while (li.hasNext()) {
            PointNode cur = (PointNode)li.next();
            Vector outer = this.linkedListToVector((PointNode)this.contours.firstElement());
            dc.start = cur.data;
            Collections.sort(outer, dc);
            ListIterator li2 = outer.listIterator();
            while (li2.hasNext()) {
                PointNode n2;
                PointNode outerPoint = (PointNode)li2.next();
                if (outerPoint.compareTo(cur) == 0) {
                    cur.next.prev = outerPoint;
                    outerPoint.next.prev = cur;
                    PointNode temp = cur.next;
                    cur.next = outerPoint.next;
                    outerPoint.next = temp;
                    continue block0;
                }
                if (!outerPoint.inCone(cur.data) || this.intersectsContour((PointNode)this.contours.firstElement(), new SegmentBBox(cur.data, outerPoint.data))) continue;
                PointNode n1 = new PointNode(cur.data);
                n1.next = n2 = new PointNode(outerPoint.data);
                n1.prev = cur.prev;
                n2.next = outerPoint.next;
                n2.prev = n1;
                n1.prev.next = n1;
                n2.next.prev = n2;
                outerPoint.next = cur;
                cur.prev = outerPoint;
                continue block0;
            }
        }
        PointNode first = (PointNode)this.contours.firstElement();
        this.contours = new Vector(1);
        this.contours.add(first);
    }

    private boolean isEar(PointNode ear) {
        return ear.convex() > 0 && !this.intersectsContour((PointNode)this.contours.firstElement(), new SegmentBBox(ear.prev.data, ear.next.data)) && ear.next.inCone(ear.prev.data) && ear.prev.inCone(ear.next.data);
    }

    private Vector determineEars() {
        PointNode head;
        Vector<PointNode> ears = new Vector<PointNode>();
        PointNode cur = head = (PointNode)this.contours.firstElement();
        do {
            if (!this.isEar(cur)) continue;
            ears.add(cur);
        } while ((cur = cur.next) != head && cur != null);
        return ears;
    }

    private boolean clipEar(PointNode ear) {
        if (!this.isEar(ear)) {
            return false;
        }
        this.triangles.add(ear.triangle());
        ear.prev.next = ear.next;
        ear.next.prev = ear.prev;
        if (this.contours.firstElement() == ear) {
            this.contours.setElementAt(ear.next, 0);
        }
        return true;
    }
}

