/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scripting.jython;

import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.scripting.jython.Interpreter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.Properties;
import java.util.Vector;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyFile;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.__builtin__;

public class ScriptingFactory
implements edu.cmu.cs.stage3.alice.scripting.ScriptingFactory {
    private Vector m_interpreters = new Vector();
    private Interpreter[] m_interpreterArray = null;
    private OutputStream m_stdout = null;
    private OutputStream m_stderr = null;

    public ScriptingFactory() {
        Properties preProperties;
        try {
            preProperties = System.getProperties();
        }
        catch (AccessControlException ace) {
            preProperties = new Properties();
            preProperties.setProperty("python.home", System.getProperty("python.home"));
        }
        Properties postProperties = null;
        String[] argv = new String[]{""};
        PySystemState.initialize((Properties)preProperties, postProperties, (String[])argv, null);
        PySystemState systemState = Py.getSystemState();
        String pythonHome = preProperties.getProperty("python.home");
        String pathname = String.valueOf(pythonHome) + "/Lib/alice/__init__.py";
        try {
            String s;
            File f = new File(pathname);
            FileInputStream is = new FileInputStream(f.getAbsoluteFile());
            BufferedReader br = new BufferedReader(new InputStreamReader(new BufferedInputStream(is)));
            StringBuffer sb = new StringBuffer();
            while ((s = br.readLine()) != null) {
                sb.append(s);
                sb.append('\n');
            }
            if (sb.length() > 0) {
                String script = sb.substring(0, sb.length() - 1);
                PyCode code = __builtin__.compile((String)script, (String)pathname, (String)"exec");
                Py.exec((PyObject)code, (PyObject)systemState.builtins, (PyObject)systemState.builtins);
            }
        }
        catch (IOException ioe) {
            throw new ExceptionWrapper(ioe, "IOException attempting to load " + pathname);
        }
    }

    @Override
    public synchronized edu.cmu.cs.stage3.alice.scripting.Interpreter manufactureInterpreter() {
        Interpreter interpreter = new Interpreter(this);
        this.m_interpreters.addElement(interpreter);
        this.m_interpreterArray = null;
        return interpreter;
    }

    synchronized void releaseInterpreter(edu.cmu.cs.stage3.alice.scripting.Interpreter interpreter) {
        this.m_interpreterArray = null;
        this.m_interpreters.removeElement(interpreter);
    }

    @Override
    public synchronized edu.cmu.cs.stage3.alice.scripting.Interpreter[] getInterpreters() {
        if (this.m_interpreterArray == null) {
            this.m_interpreterArray = new Interpreter[this.m_interpreters.size()];
            this.m_interpreters.copyInto(this.m_interpreterArray);
        }
        return this.m_interpreterArray;
    }

    @Override
    public OutputStream getStdOut() {
        return this.m_stdout;
    }

    @Override
    public void setStdOut(OutputStream stdout) {
        this.m_stdout = stdout;
        Py.getSystemState().stdout = new PyFile(stdout);
    }

    @Override
    public OutputStream getStdErr() {
        return this.m_stderr;
    }

    @Override
    public void setStdErr(OutputStream stderr) {
        this.m_stderr = stderr;
        Py.getSystemState().stderr = new PyFile(stderr);
    }
}

