/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.awt;

import edu.cmu.cs.stage3.alice.authoringtool.AikMin;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Label;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class AWTUtilities {
    private static boolean s_successfullyLoadedLibrary;
    public static int key;
    public static int modifier;
    private static Vector s_mouseListeners;
    private static Vector s_mouseMotionListeners;
    private static Component s_source;
    private static int s_prevModifiers;
    private static int s_clickCount;
    private static Point s_prevCursorPos;
    private static Point s_currCursorPos;

    static {
        try {
            System.loadLibrary("jni_awtutilities");
            s_successfullyLoadedLibrary = true;
        }
        catch (Throwable t) {
            s_successfullyLoadedLibrary = false;
        }
        s_mouseListeners = new Vector();
        s_mouseMotionListeners = new Vector();
        s_source = new Label("edu.cmu.cs.stage3.io.toolkit.Toolkit");
        s_prevModifiers = 0;
        s_clickCount = 0;
        s_prevCursorPos = new Point();
        s_currCursorPos = new Point();
    }

    private static native boolean isGetCursorLocationSupportedNative();

    public static boolean isGetCursorLocationSupported() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.isGetCursorLocationSupportedNative();
        }
        return false;
    }

    private static native boolean isSetCursorLocationSupportedNative();

    public static boolean isSetCursorLocationSupported() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.isSetCursorLocationSupportedNative();
        }
        return false;
    }

    private static native boolean isIsKeyPressedSupportedNative();

    public static boolean isIsKeyPressedSupported() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.isIsKeyPressedSupportedNative();
        }
        return false;
    }

    private static native boolean isGetModifiersSupportedNative();

    public static boolean isGetModifiersSupported() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.isGetModifiersSupportedNative();
        }
        return false;
    }

    private static native boolean isPumpMessageQueueSupportedNative();

    public static boolean isPumpMessageQueueSupported() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.isPumpMessageQueueSupportedNative();
        }
        return false;
    }

    private static native void pumpMessageQueueNative();

    public static void pumpMessageQueue() {
        if (s_successfullyLoadedLibrary) {
            AWTUtilities.pumpMessageQueueNative();
        }
    }

    private static native void getCursorLocationNative(Point var0);

    public static Point getCursorLocation() {
        if (s_successfullyLoadedLibrary) {
            Point p = new Point();
            AWTUtilities.getCursorLocationNative(p);
            return p;
        }
        Point p = MouseInfo.getPointerInfo().getLocation().getLocation();
        return p;
    }

    private static native void setCursorLocationNative(int var0, int var1);

    public static void setCursorLocation(int x, int y) {
        if (s_successfullyLoadedLibrary) {
            AWTUtilities.setCursorLocationNative(x, y);
        } else {
            AWTUtilities.moveMouse(new Point(x, y));
        }
    }

    private static void moveMouse(Point p) {
        GraphicsDevice[] gs;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = gs = ge.getScreenDevices();
        int n = gs.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsConfiguration[] configurations;
            GraphicsDevice device = graphicsDeviceArray[n2];
            GraphicsConfiguration[] graphicsConfigurationArray = configurations = device.getConfigurations();
            int n3 = configurations.length;
            int n4 = 0;
            while (n4 < n3) {
                GraphicsConfiguration config = graphicsConfigurationArray[n4];
                Rectangle bounds = config.getBounds();
                if (bounds.contains(p)) {
                    Point b = bounds.getLocation();
                    Point s = new Point(p.x - b.x, p.y - b.y);
                    try {
                        Robot r = new Robot(device);
                        r.mouseMove(s.x, s.y);
                    }
                    catch (AWTException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void setCursorLocation(Point p) {
        AWTUtilities.setCursorLocation(p.x, p.y);
    }

    private static native boolean isCursorShowingNative();

    public static boolean isCursorShowing() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.isCursorShowingNative();
        }
        return true;
    }

    private static native void setIsCursorShowingNative(boolean var0);

    public static void setIsCursorShowing(boolean isCursorShowing) {
        if (s_successfullyLoadedLibrary) {
            AWTUtilities.setIsCursorShowingNative(isCursorShowing);
        }
    }

    private static native boolean isIsCursorShowingSupportedNative();

    public static boolean isIsCursorShowingSupported() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.isIsCursorShowingSupportedNative();
        }
        return false;
    }

    private static native boolean isSetIsCursorShowingSupportedNative();

    public static boolean isSetIsCursorShowingSupported() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.isSetIsCursorShowingSupportedNative();
        }
        return false;
    }

    private static native boolean isKeyPressedNative(int var0);

    public static boolean isKeyPressed(int keyCode) {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.isKeyPressedNative(keyCode);
        }
        if (keyCode == 17) {
            return AikMin.control;
        }
        if (keyCode == 16) {
            return AikMin.shift;
        }
        return false;
    }

    private static native int isKeyNative(int var0);

    public static int isKey(int keyCode) {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.isKeyNative(keyCode);
        }
        return 0;
    }

    private static native int getModifiersNative();

    public static int getModifiers() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.getModifiersNative();
        }
        return modifier;
    }

    public static boolean mouseListenersAreSupported() {
        return AWTUtilities.isGetModifiersSupported() && AWTUtilities.isGetCursorLocationSupported();
    }

    public static boolean mouseMotionListenersAreSupported() {
        return AWTUtilities.isGetModifiersSupported() && AWTUtilities.isGetCursorLocationSupported();
    }

    public static void addMouseListener(MouseListener mouseListener) {
        s_mouseListeners.addElement(mouseListener);
    }

    public static void removeMouseListener(MouseListener mouseListener) {
        s_mouseListeners.removeElement(mouseListener);
    }

    public static void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        s_mouseMotionListeners.addElement(mouseMotionListener);
    }

    public static void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        s_mouseMotionListeners.removeElement(mouseMotionListener);
    }

    private static boolean isButton1Pressed(int modifiers) {
        return (modifiers & 0x10) == 16;
    }

    private static boolean isButton2Pressed(int modifiers) {
        return (modifiers & 8) == 8;
    }

    private static boolean isButton3Pressed(int modifiers) {
        return (modifiers & 4) == 4;
    }

    public static void fireMouseAndMouseMotionListenersIfNecessary() {
        if (AWTUtilities.mouseListenersAreSupported()) {
            int id = 0;
            int currModifiers = AWTUtilities.getModifiers();
            boolean drag = false;
            if (AWTUtilities.isButton1Pressed(s_prevModifiers)) {
                if (AWTUtilities.isButton1Pressed(currModifiers)) {
                    drag = true;
                } else {
                    id = 502;
                }
            } else if (AWTUtilities.isButton1Pressed(currModifiers)) {
                id = 501;
                drag = true;
            }
            if (AWTUtilities.isButton2Pressed(s_prevModifiers)) {
                if (AWTUtilities.isButton2Pressed(currModifiers)) {
                    drag = true;
                } else {
                    id = 502;
                }
            } else if (AWTUtilities.isButton2Pressed(currModifiers)) {
                id = 501;
                drag = true;
            }
            if (AWTUtilities.isButton3Pressed(s_prevModifiers)) {
                if (AWTUtilities.isButton3Pressed(currModifiers)) {
                    drag = true;
                } else {
                    id = 502;
                }
            } else if (AWTUtilities.isButton3Pressed(currModifiers)) {
                id = 501;
                drag = true;
            }
            long when = System.currentTimeMillis();
            boolean isPopupTrigger = false;
            s_currCursorPos = AWTUtilities.getCursorLocation();
            if (id != 0) {
                if (s_mouseListeners.size() > 0) {
                    MouseEvent mouseEvent = new MouseEvent(s_source, id, when, currModifiers, AWTUtilities.s_currCursorPos.x, AWTUtilities.s_currCursorPos.y, s_clickCount, isPopupTrigger);
                    int i = 0;
                    while (i < s_mouseListeners.size()) {
                        MouseListener mouseListener = (MouseListener)s_mouseListeners.elementAt(i);
                        switch (id) {
                            case 500: {
                                mouseListener.mouseClicked(mouseEvent);
                                break;
                            }
                            case 504: {
                                mouseListener.mouseEntered(mouseEvent);
                                break;
                            }
                            case 505: {
                                mouseListener.mouseExited(mouseEvent);
                                break;
                            }
                            case 501: {
                                mouseListener.mousePressed(mouseEvent);
                                break;
                            }
                            case 502: {
                                mouseListener.mouseReleased(mouseEvent);
                            }
                        }
                        ++i;
                    }
                }
            } else if ((AWTUtilities.s_currCursorPos.x != AWTUtilities.s_prevCursorPos.x || AWTUtilities.s_currCursorPos.y != AWTUtilities.s_prevCursorPos.y) && s_mouseMotionListeners.size() > 0) {
                id = drag ? 506 : 503;
                MouseEvent mouseEvent = new MouseEvent(s_source, id, when, currModifiers, AWTUtilities.s_currCursorPos.x, AWTUtilities.s_currCursorPos.y, s_clickCount, isPopupTrigger);
                int i = 0;
                while (i < s_mouseMotionListeners.size()) {
                    MouseMotionListener mouseMotionListener = (MouseMotionListener)s_mouseMotionListeners.elementAt(i);
                    switch (id) {
                        case 503: {
                            mouseMotionListener.mouseMoved(mouseEvent);
                            break;
                        }
                        case 506: {
                            mouseMotionListener.mouseDragged(mouseEvent);
                        }
                    }
                    ++i;
                }
            }
            AWTUtilities.s_prevCursorPos.x = AWTUtilities.s_currCursorPos.x;
            AWTUtilities.s_prevCursorPos.y = AWTUtilities.s_currCursorPos.y;
            s_prevModifiers = currModifiers;
        }
    }
}

