/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.personbuilder;

import edu.cmu.cs.stage3.caitlin.personbuilder.AllStepsPanel;
import edu.cmu.cs.stage3.caitlin.personbuilder.XMLDirectoryUtilities;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Node;

public class NavigationPanel
extends JPanel
implements ActionListener {
    protected Vector stepButtons = new Vector();
    protected Vector stepImages = new Vector();
    protected Vector selStepImages = new Vector();
    protected JButton backButton = null;
    protected JButton nextButton = null;
    protected ImageIcon spacerIcon = null;
    protected ImageIcon noBackImage = null;
    protected ImageIcon noNextImage = null;
    protected ImageIcon backImage = null;
    protected ImageIcon nextImage = null;
    protected int stepIndex = 0;
    protected AllStepsPanel allStepsPanel;

    public NavigationPanel(Node root, AllStepsPanel allStepsPanel) {
        this.createGuiElements(root);
        this.allStepsPanel = allStepsPanel;
        this.addGuiElements();
        this.setSelectedStep(0, 1);
    }

    public void setFirstStep() {
        int index = this.allStepsPanel.getSelected();
        this.allStepsPanel.setSelected(0);
        this.setSelectedStep(0, index - 1);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object actionObj = ae.getSource();
        int index = this.stepButtons.indexOf(actionObj);
        if (index <= 0 || index >= this.stepButtons.size() - 1) {
            if (index == 0) {
                index = this.allStepsPanel.getSelected();
                --index;
            } else if (index == this.stepButtons.size() - 1) {
                index = this.allStepsPanel.getSelected();
                ++index;
            }
        }
        int prevStep = this.allStepsPanel.getSelected() - 1;
        this.allStepsPanel.setSelected(index);
        int curStep = this.allStepsPanel.getSelected() - 1;
        this.setSelectedStep(curStep, prevStep);
    }

    protected void setSelectedStep(int curStep, int prevStep) {
        if (prevStep >= 0 && curStep != prevStep) {
            JButton curButton = (JButton)this.stepButtons.elementAt(prevStep + 1);
            ImageIcon curImage = (ImageIcon)this.stepImages.elementAt(prevStep);
            curButton.setIcon(curImage);
        }
        if (prevStep < this.selStepImages.size() && curStep != prevStep) {
            JButton newButton = (JButton)this.stepButtons.elementAt(curStep + 1);
            ImageIcon newImage = (ImageIcon)this.selStepImages.elementAt(curStep);
            newButton.setIcon(newImage);
        }
        if (curStep == 0) {
            this.backButton.setIcon(this.noBackImage);
        } else {
            this.backButton.setIcon(this.backImage);
        }
        if (curStep == this.selStepImages.size() - 1) {
            this.nextButton.setIcon(this.noNextImage);
        } else {
            this.nextButton.setIcon(this.nextImage);
        }
    }

    private void addGuiElements() {
        this.setLayout(new FlowLayout(1, 0, 5));
        this.setBackground(new Color(155, 159, 206));
        int i = 0;
        while (i < this.stepButtons.size()) {
            this.add((JButton)this.stepButtons.elementAt(i));
            if (i != this.stepButtons.size() - 1) {
                JLabel spLabel = new JLabel(this.spacerIcon);
                this.add(spLabel);
            }
            ++i;
        }
    }

    private void createGuiElements(Node root) {
        Vector imageURLs = XMLDirectoryUtilities.getImageURLs(root);
        int i = 0;
        while (i < imageURLs.size()) {
            URL url = (URL)imageURLs.elementAt(i);
            if (url.toString().indexOf("nextBtn.jpg") != -1) {
                this.nextImage = new ImageIcon(url);
                this.nextButton = new JButton(this.nextImage);
                this.nextButton.setBorderPainted(false);
                this.nextButton.setBorder(null);
                this.nextButton.addActionListener(this);
            } else if (url.toString().indexOf("backBtn.jpg") != -1) {
                this.backImage = new ImageIcon(url);
                this.backButton = new JButton(this.backImage);
                this.backButton.setBorderPainted(false);
                this.backButton.setBorder(null);
                this.backButton.addActionListener(this);
                this.stepButtons.addElement(this.backButton);
            } else if (url.toString().indexOf("noBackBtn.jpg") != -1) {
                this.noBackImage = new ImageIcon(url);
            } else if (url.toString().indexOf("noNextBtn.jpg") != -1) {
                this.noNextImage = new ImageIcon(url);
            } else if (url.toString().indexOf("spacer.jpg") != -1) {
                this.spacerIcon = new ImageIcon(url);
            }
            ++i;
        }
        Vector stepNodes = XMLDirectoryUtilities.getDirectories(root);
        int i2 = 0;
        while (i2 < stepNodes.size()) {
            Node currentStepNode = (Node)stepNodes.elementAt(i2);
            Vector currentStepImages = XMLDirectoryUtilities.getImageURLs(currentStepNode);
            if (currentStepImages != null && currentStepImages.size() > 1) {
                ImageIcon icon = new ImageIcon((URL)currentStepImages.elementAt(0));
                ImageIcon selIcon = new ImageIcon((URL)currentStepImages.elementAt(1));
                this.stepImages.addElement(icon);
                this.selStepImages.addElement(selIcon);
                JButton stepBtn = new JButton(icon);
                stepBtn.setBorderPainted(false);
                stepBtn.addActionListener(this);
                stepBtn.setBorder(null);
                this.stepButtons.addElement(stepBtn);
            }
            ++i2;
        }
        this.stepButtons.addElement(this.nextButton);
    }
}

