/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.personbuilder;

import edu.cmu.cs.stage3.caitlin.personbuilder.ModelWrapper;
import edu.cmu.cs.stage3.caitlin.personbuilder.XMLDirectoryUtilities;
import java.awt.FlowLayout;
import java.net.URL;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StringPropertySetter
extends JPanel
implements DocumentListener {
    String propertyName = "";
    String labelText = "";
    String defaultValue = "";
    ModelWrapper modelWrapper = null;
    JTextField valueField = null;

    public StringPropertySetter(Node propNode, ModelWrapper modelWrapper) {
        this.modelWrapper = modelWrapper;
        Node propDetailsNode = this.loadPropertyXML(propNode);
        this.getPropertyInfo(propDetailsNode);
        this.createGUI();
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        this.modelWrapper.setProperty(this.propertyName, this.valueField.getText(), this.labelText);
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.modelWrapper.setProperty(this.propertyName, this.valueField.getText(), this.labelText);
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        String value = this.valueField.getText();
        if (value.equals("")) {
            value = "noname";
        }
        this.modelWrapper.setProperty(this.propertyName, value, this.labelText);
    }

    protected Node loadPropertyXML(Node propNode) {
        String path = "";
        Object propSetURL = null;
        Node propSetNode = propNode;
        URL xmlURL = null;
        Vector xmlFiles = XMLDirectoryUtilities.getXMLURLs(propSetNode);
        if (xmlFiles.size() == 1) {
            xmlURL = (URL)xmlFiles.elementAt(0);
        } else {
            System.out.println("Zero or Multiple xml files found");
        }
        if (xmlURL != null) {
            Document doc = (Document)XMLDirectoryUtilities.loadURL(xmlURL);
            return doc.getDocumentElement();
        }
        return null;
    }

    protected void getPropertyInfo(Node propNode) {
        NodeList nList = propNode.getChildNodes();
        int i = 0;
        while (i < nList.getLength()) {
            Node curNode = nList.item(i);
            if (curNode.getNodeName().equals("setProperty")) {
                NamedNodeMap attrs = curNode.getAttributes();
                int j = 0;
                while (j < attrs.getLength()) {
                    Node attr = attrs.item(j);
                    if (attr.getNodeName().equals("name")) {
                        this.propertyName = attr.getNodeValue();
                    } else if (attr.getNodeName().equals("description")) {
                        this.labelText = attr.getNodeValue();
                    } else if (attr.getNodeName().equals("defaultValue")) {
                        this.defaultValue = attr.getNodeValue();
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void createGUI() {
        this.setLayout(new FlowLayout());
        JLabel label = new JLabel(this.labelText);
        this.valueField = new JTextField(this.defaultValue);
        this.valueField.getDocument().addDocumentListener(this);
        this.add(label);
        this.add(this.valueField);
    }
}

