/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.personbuilder;

import edu.cmu.cs.stage3.caitlin.personbuilder.PersonBuilder;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLDirectoryUtilities {
    public static Node loadURL(URL url) {
        Document document = null;
        if (url != null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                document = builder.parse(url.openStream());
            }
            catch (IOException ioe) {
                document = null;
                ioe.printStackTrace();
            }
            catch (ParserConfigurationException pce) {
                document = null;
                pce.printStackTrace();
            }
            catch (SAXException se) {
                document = null;
                se.printStackTrace();
            }
            return document;
        }
        return null;
    }

    public static String getPath(Node node) {
        NamedNodeMap nodeMap = node.getAttributes();
        Node pathNode = nodeMap.getNamedItem("path");
        if (pathNode != null) {
            return pathNode.getNodeValue();
        }
        return null;
    }

    public static Node loadFile(String fileName) {
        URL url = XMLDirectoryUtilities.class.getResource(fileName);
        return XMLDirectoryUtilities.loadURL(url);
    }

    public static Vector getDirectories(Node node) {
        NodeList nList = node.getChildNodes();
        Vector<Node> directoryNodes = new Vector<Node>();
        int i = 0;
        while (i < nList.getLength()) {
            Node kidNode = nList.item(i);
            if (kidNode.getNodeName().equals("directory")) {
                directoryNodes.addElement(kidNode);
            }
            ++i;
        }
        return directoryNodes;
    }

    public static Vector getSetColorNodes(Node node) {
        NodeList nList = node.getChildNodes();
        Vector<Node> propertySetNodes = new Vector<Node>();
        int i = 0;
        while (i < nList.getLength()) {
            Node kidNode = nList.item(i);
            if (kidNode.getNodeName().equals("setColor")) {
                propertySetNodes.addElement(kidNode);
            }
            ++i;
        }
        return propertySetNodes;
    }

    protected static Vector getFilesOfType(String nodeType, Node node) {
        NodeList nList = node.getChildNodes();
        Vector<URL> files = new Vector<URL>();
        int i = 0;
        while (i < nList.getLength()) {
            Node kidNode = nList.item(i);
            if (kidNode.getNodeName().equals(nodeType)) {
                URL url;
                NamedNodeMap nodeMap = kidNode.getAttributes();
                Node pathNode = nodeMap.getNamedItem("path");
                String path = null;
                if (pathNode != null && (url = PersonBuilder.class.getResource(path = pathNode.getNodeValue())) != null) {
                    files.addElement(url);
                }
            }
            ++i;
        }
        return files;
    }

    public static Vector getImageURLs(Node node) {
        return XMLDirectoryUtilities.getFilesOfType("image", node);
    }

    public static Vector getImages(Node node) {
        Vector urls = XMLDirectoryUtilities.getImageURLs(node);
        Vector<Image> images = new Vector<Image>();
        Toolkit tk = Toolkit.getDefaultToolkit();
        int i = 0;
        while (i < urls.size()) {
            URL url = (URL)urls.elementAt(i);
            try {
                Image img = tk.createImage(url);
                if (img != null) {
                    images.addElement(img);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return images;
    }

    public static Vector getModelURLs(Node node) {
        return XMLDirectoryUtilities.getFilesOfType("model", node);
    }

    public static Vector getXMLURLs(Node node) {
        return XMLDirectoryUtilities.getFilesOfType("xml", node);
    }

    public static Vector getPropertySets(Node node) {
        return XMLDirectoryUtilities.getFilesOfType("propertySet", node);
    }
}

