/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.stencilhelp.client;

import edu.cmu.cs.stage3.caitlin.stencilhelp.client.LayoutChangeListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ObjectPositionManager;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ScreenShape;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilObject;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilObjectPositionListener;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Vector;

public class Frame
implements StencilObject,
LayoutChangeListener {
    protected Vector stencilObjectPositionListeners = new Vector();
    protected Vector shapes = new Vector();
    protected String id = null;
    protected boolean isModified = true;
    protected Rectangle previousRect = null;
    protected Rectangle2D.Double rect = null;
    protected boolean isInitialized = false;
    protected ObjectPositionManager positionManager = null;
    protected boolean missingID = false;

    public Frame(String id, ObjectPositionManager positionManager) {
        this.positionManager = positionManager;
        this.id = id;
    }

    public boolean updatePosition() {
        this.previousRect = this.getRectangle();
        if (this.shapes == null) {
            this.shapes = new Vector();
        }
        this.shapes.removeAllElements();
        Rectangle r = null;
        try {
            r = this.positionManager.getBoxForID(this.id);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (r != null) {
            this.rect = new Rectangle2D.Double(r.x - 3, r.y - 3, r.width + 6, r.height + 6);
            RoundRectangle2D.Double rr = new RoundRectangle2D.Double(r.x - 3, r.y - 3, r.width + 6, r.height + 6, 1.0, 1.0);
            this.shapes.addElement(new ScreenShape(null, rr, true, 0));
            Rectangle2D.Double temp = new Rectangle2D.Double(r.x - 6, r.y - 6, 3.0, r.height + 12);
            this.shapes.addElement(new ScreenShape(Color.red, temp, true, 1));
            temp = new Rectangle2D.Double(r.x - 6, r.y - 6, r.width + 12, 3.0);
            this.shapes.addElement(new ScreenShape(Color.red, temp, true, 2));
            temp = new Rectangle2D.Double(r.x + r.width + 3, r.y - 6, 3.0, r.height + 12);
            this.shapes.addElement(new ScreenShape(Color.red, temp, true, 3));
            temp = new Rectangle2D.Double(r.x - 6, r.y + r.height + 3, r.width + 12, 3.0);
            this.shapes.addElement(new ScreenShape(Color.red, temp, true, 4));
            temp = new Rectangle2D.Double(r.x - 3, r.y - 3, r.width + 6, r.height + 6);
            this.shapes.addElement(new ScreenShape(new Color(0, 100, 255, 50), temp, true, 5));
            this.isModified = true;
            return true;
        }
        this.isModified = true;
        return false;
    }

    protected void setInitialPosition() {
        this.previousRect = this.getRectangle();
        if (this.shapes == null) {
            this.shapes = new Vector();
        }
        this.shapes.removeAllElements();
        Rectangle r = this.positionManager.getInitialBox(this.id);
        if (r != null) {
            this.rect = new Rectangle2D.Double(r.x - 3, r.y - 3, r.width + 6, r.height + 6);
            RoundRectangle2D.Double rr = new RoundRectangle2D.Double(r.x - 3, r.y - 3, r.width + 6, r.height + 6, 1.0, 1.0);
            this.shapes.addElement(new ScreenShape(null, rr, true, 0));
            Rectangle2D.Double temp = new Rectangle2D.Double(r.x - 6, r.y - 6, 3.0, r.height + 12);
            this.shapes.addElement(new ScreenShape(Color.red, temp, true, 1));
            temp = new Rectangle2D.Double(r.x - 6, r.y - 6, r.width + 12, 3.0);
            this.shapes.addElement(new ScreenShape(Color.red, temp, true, 2));
            temp = new Rectangle2D.Double(r.x + r.width + 3, r.y - 6, 3.0, r.height + 12);
            this.shapes.addElement(new ScreenShape(Color.red, temp, true, 3));
            temp = new Rectangle2D.Double(r.x - 6, r.y + r.height + 3, r.width + 12, 3.0);
            this.shapes.addElement(new ScreenShape(Color.red, temp, true, 4));
            temp = new Rectangle2D.Double(r.x - 3, r.y - 3, r.width + 6, r.height + 6);
            this.shapes.addElement(new ScreenShape(new Color(0, 100, 255, 50), temp, true, 5));
        }
        this.isModified = true;
        this.isInitialized = true;
    }

    @Override
    public Vector getShapes() {
        return this.shapes;
    }

    @Override
    public Rectangle getRectangle() {
        if (this.rect != null) {
            return this.rect.getBounds();
        }
        return null;
    }

    @Override
    public Rectangle getPreviousRectangle() {
        if (this.previousRect == null && this.rect != null) {
            return this.rect.getBounds();
        }
        return this.previousRect;
    }

    @Override
    public boolean isModified() {
        if (this.isModified) {
            this.isModified = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersectsRectangle(Rectangle rect) {
        if (this.rect != null) {
            return rect.intersects(this.getRectangle());
        }
        return false;
    }

    public Point getNotePoint() {
        if (this.rect != null) {
            return new Point((int)this.rect.getX(), (int)this.rect.getY());
        }
        return new Point(0, 0);
    }

    @Override
    public void addStencilObjectPositionListener(StencilObjectPositionListener posListener) {
        this.stencilObjectPositionListeners.addElement(posListener);
    }

    @Override
    public void removeStencilObjectPositionListener(StencilObjectPositionListener posListener) {
        this.stencilObjectPositionListeners.remove(posListener);
    }

    @Override
    public String getComponentID() {
        return this.id;
    }

    @Override
    public boolean layoutChanged() {
        boolean success = true;
        success = this.updatePosition();
        return success;
    }
}

