/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.stencilhelp.client;

import edu.cmu.cs.stage3.caitlin.stencilhelp.application.StencilApplication;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.KeyEventListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.LayoutChangeListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.MouseEventListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ObjectPositionManager;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ScreenShape;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilManager;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilObject;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilObjectPositionListener;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.Vector;

public class Hole
implements StencilObject,
MouseEventListener,
KeyEventListener,
LayoutChangeListener {
    Vector shapes = new Vector();
    Vector stencilObjectPositionListeners = new Vector();
    ObjectPositionManager positionManager = null;
    StencilApplication stencilApp = null;
    StencilManager stencilManager = null;
    RoundRectangle2D.Double rect = null;
    String id = null;
    protected boolean isModified = true;
    protected boolean isInitialized = false;
    protected Rectangle previousRect = null;
    protected boolean autoAdvance = false;
    protected int advanceEvent = 0;
    public static final int ADVANCE_ON_CLICK = 0;
    public static final int ADVANCE_ON_PRESS = 1;
    public static final int ADVANCE_ON_ENTER = 2;

    public Hole(String id, ObjectPositionManager positionManager, StencilApplication stencilApp, StencilManager stencilManager) {
        this.positionManager = positionManager;
        this.stencilApp = stencilApp;
        this.id = id;
        this.stencilManager = stencilManager;
    }

    @Override
    public Vector getShapes() {
        return this.shapes;
    }

    @Override
    public Rectangle getRectangle() {
        if (this.rect != null) {
            return this.rect.getBounds();
        }
        return null;
    }

    @Override
    public Rectangle getPreviousRectangle() {
        if (this.previousRect != null) {
            return this.previousRect.union(this.rect.getBounds());
        }
        if (this.rect != null) {
            return this.rect.getBounds();
        }
        return null;
    }

    @Override
    public boolean isModified() {
        if (this.isModified) {
            this.isModified = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersectsRectangle(Rectangle rect) {
        if (this.rect != null) {
            return rect.intersects(this.getRectangle());
        }
        return false;
    }

    public Point getNotePoint() {
        if (this.rect != null) {
            return new Point((int)this.rect.getX(), (int)this.rect.getY());
        }
        return new Point(0, 0);
    }

    @Override
    public void addStencilObjectPositionListener(StencilObjectPositionListener posListener) {
        this.stencilObjectPositionListeners.addElement(posListener);
    }

    @Override
    public void removeStencilObjectPositionListener(StencilObjectPositionListener posListener) {
        this.stencilObjectPositionListeners.remove(posListener);
    }

    @Override
    public String getComponentID() {
        return this.id;
    }

    public void setAutoAdvance(boolean autoAdvance, int advanceEvent) {
        this.autoAdvance = autoAdvance;
        this.advanceEvent = advanceEvent;
    }

    public boolean getAutoAdvance() {
        return this.autoAdvance;
    }

    public int getAdvanceEvent() {
        return this.advanceEvent;
    }

    @Override
    public boolean contains(Point point) {
        if (this.rect != null) {
            Rectangle smallRect = this.rect.getBounds();
            smallRect.grow(-4, -4);
            return smallRect.contains(point.getX(), point.getY());
        }
        return false;
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        this.stencilApp.handleMouseEvent(e);
        if (this.autoAdvance && this.advanceEvent == 1 && (e.getModifiers() & 0x10) == 16) {
            this.stencilManager.showNextStencil();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(MouseEvent e) {
        this.stencilApp.handleMouseEvent(e);
        return false;
    }

    @Override
    public boolean mouseClicked(MouseEvent e) {
        this.stencilApp.handleMouseEvent(e);
        if (this.autoAdvance && this.advanceEvent == 0 && (e.getModifiers() & 0x10) == 16) {
            try {
                Thread.sleep(700L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.stencilManager.showNextStencil();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseEntered(MouseEvent e) {
        this.stencilApp.handleMouseEvent(e);
        return false;
    }

    @Override
    public boolean mouseExited(MouseEvent e) {
        this.stencilApp.handleMouseEvent(e);
        return false;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        this.stencilApp.handleMouseEvent(e);
        return false;
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        this.stencilApp.handleMouseEvent(e);
        return false;
    }

    @Override
    public boolean keyTyped(KeyEvent e) {
        return false;
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        return false;
    }

    @Override
    public boolean keyReleased(KeyEvent e) {
        if (this.autoAdvance && this.advanceEvent == 2 && e.getKeyCode() == 10) {
            this.stencilManager.showNextStencil();
            return true;
        }
        return false;
    }

    protected void setInitialPosition() {
        Rectangle r = this.positionManager.getInitialBox(this.id);
        if (r != null) {
            this.rect = new RoundRectangle2D.Double(r.x - 2, r.y - 2, r.width + 4, r.height + 4, 10.0, 10.0);
            this.shapes.removeAllElements();
            this.shapes.addElement(new ScreenShape(null, this.rect, false, 0));
        }
        this.isModified = true;
        this.isInitialized = true;
    }

    public boolean updatePosition() {
        this.previousRect = this.getRectangle();
        Rectangle r = this.positionManager.getBoxForID(this.id);
        if (r != null) {
            this.rect = new RoundRectangle2D.Double(r.x - 2, r.y - 2, r.width + 4, r.height + 4, 10.0, 10.0);
            this.shapes.removeAllElements();
            this.shapes.addElement(new ScreenShape(null, this.rect, false, 0));
            this.isModified = true;
            return true;
        }
        this.isModified = true;
        return false;
    }

    @Override
    public boolean layoutChanged() {
        boolean success = true;
        success = this.updatePosition();
        if (!success) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            success = this.updatePosition();
        }
        return success;
    }
}

