/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.stencilhelp.client;

import edu.cmu.cs.stage3.caitlin.stencilhelp.client.MouseEventListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ObjectPositionManager;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ScreenShape;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilManager;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilObject;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilObjectPositionListener;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.util.Vector;

public class Link
implements StencilObject,
MouseEventListener {
    protected StencilManager stencilManager = null;
    protected ObjectPositionManager posManager = null;
    protected boolean next = false;
    protected String message = null;
    protected RoundRectangle2D.Double underLink;
    protected RoundRectangle2D.Double bgLink;
    protected Shape messageShape = null;
    private Font font = new Font("Arial", 1, 16);
    protected boolean isModified = true;
    protected Vector shapes = null;

    public Link(StencilManager stencilManager, ObjectPositionManager posManager, boolean next) {
        this.stencilManager = stencilManager;
        this.posManager = posManager;
        this.next = next;
        this.shapes = new Vector();
        this.message = next ? Messages.getString("Load_Next_Chapter") : Messages.getString("Reload_Last_Chapter");
        this.createShapes();
    }

    protected void createShapes() {
        TextLayout wordLayout = new TextLayout(this.message, this.font, new FontRenderContext(null, false, false));
        AffineTransform textAt = new AffineTransform();
        int xStart = 10;
        int yStart = 10;
        int width = (int)wordLayout.getBounds().getWidth();
        if (this.next) {
            xStart = (int)this.posManager.getScreenWidth() - width - 50;
            yStart = (int)this.posManager.getScreenHeight() - 80;
        }
        textAt.translate(xStart + 5, yStart + 18);
        this.messageShape = wordLayout.getOutline(textAt);
        this.underLink = new RoundRectangle2D.Double(xStart + 2, yStart - 2, width + 10, 25.0, 10.0, 10.0);
        this.bgLink = new RoundRectangle2D.Double(xStart, yStart, width + 10, 25.0, 10.0, 10.0);
        ScreenShape shape = new ScreenShape(new Color(255, 200, 240, 100), this.underLink, true, 1);
        this.shapes.addElement(shape);
        shape = new ScreenShape(new Color(255, 180, 210, 150), this.bgLink, true, 2);
        this.shapes.addElement(shape);
        shape = new ScreenShape(new Color(0, 0, 180), this.messageShape, true, 0);
        this.shapes.addElement(shape);
    }

    @Override
    public Vector getShapes() {
        return this.shapes;
    }

    @Override
    public Rectangle getRectangle() {
        return this.bgLink.getBounds();
    }

    @Override
    public Rectangle getPreviousRectangle() {
        return this.bgLink.getBounds();
    }

    @Override
    public boolean isModified() {
        if (this.isModified) {
            this.isModified = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersectsRectangle(Rectangle rect) {
        return this.bgLink.getBounds().intersects(rect);
    }

    @Override
    public void addStencilObjectPositionListener(StencilObjectPositionListener posListener) {
    }

    @Override
    public void removeStencilObjectPositionListener(StencilObjectPositionListener posListener) {
    }

    @Override
    public String getComponentID() {
        return null;
    }

    @Override
    public boolean contains(Point point) {
        return this.bgLink.contains(point.getX(), point.getY());
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseReleased(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseClicked(MouseEvent e) {
        if (this.next) {
            this.stencilManager.showNextStack();
        } else {
            this.stencilManager.showPreviousStack();
        }
        return false;
    }

    @Override
    public boolean mouseEntered(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseExited(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        return false;
    }
}

