/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.stencilhelp.client;

import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ScreenShape;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Vector;

public class Paragraph {
    protected int textWidth = 100;
    protected Point textOrigin = new Point(0, 0);
    protected int cursorIndex = 0;
    protected Shape caretShape = null;
    protected float lineHeight = 0.0f;
    protected double lineAscent = 0.0;
    protected FontRenderContext frc = null;
    protected StringBuffer currentText = new StringBuffer("");
    protected Vector buffers = new Vector();
    protected Vector colors = new Vector();
    protected Vector iterators = new Vector();
    protected Vector measurers = new Vector();
    private int fontSize = 14;

    public Paragraph() {
        this.frc = new FontRenderContext(null, false, false);
        this.buffers.addElement(this.currentText);
        this.colors.addElement(Color.blue);
        this.regenerateLineBreakMeasurer();
    }

    public Paragraph(int textWidth, Point textOrigin) {
        this();
        this.textWidth = textWidth;
        this.textOrigin = textOrigin;
    }

    public void setTextWidth(int textWidth) {
        this.textWidth = textWidth;
    }

    public void setTextOrigin(Point textOrigin) {
        this.textOrigin = textOrigin;
    }

    public void addText(String textString, Color textColor) {
        this.buffers.addElement(new StringBuffer(textString));
        this.colors.addElement(textColor);
        this.currentText = (StringBuffer)this.buffers.elementAt(0);
        this.cursorIndex = 0;
        this.regenerateLineBreakMeasurer();
    }

    public void clearText() {
        this.buffers.removeAllElements();
        this.colors.removeAllElements();
        this.regenerateLineBreakMeasurer();
    }

    public void createNewLine() {
        StringBuffer lastBuffer = new StringBuffer();
        StringBuffer newBuffer = new StringBuffer();
        if (this.cursorIndex == this.currentText.length()) {
            lastBuffer = this.currentText;
            newBuffer = new StringBuffer(" ");
        } else {
            lastBuffer = new StringBuffer(this.currentText.substring(0, this.cursorIndex));
            newBuffer = new StringBuffer(this.currentText.substring(this.cursorIndex));
        }
        int index = this.buffers.indexOf(this.currentText);
        if (index != -1) {
            this.buffers.setElementAt(lastBuffer, index);
            this.currentText = newBuffer;
            this.cursorIndex = 0;
            this.buffers.insertElementAt(newBuffer, index + 1);
            Color textColor = (Color)this.colors.elementAt(index);
            this.colors.insertElementAt(textColor, index + 1);
        }
        this.regenerateLineBreakMeasurer();
    }

    public void insertChar(char c) {
        if (this.cursorIndex == this.currentText.length()) {
            this.currentText.append(c);
        } else {
            this.currentText.insert(this.cursorIndex, c);
        }
        ++this.cursorIndex;
        this.regenerateLineBreakMeasurer();
    }

    public void deleteChar() {
        int lineIndex = this.buffers.indexOf(this.currentText);
        if (this.cursorIndex > 0) {
            this.currentText.deleteCharAt(this.cursorIndex - 1);
            --this.cursorIndex;
            if (this.cursorIndex >= this.currentText.length()) {
                this.cursorIndex = this.currentText.length();
            } else if (this.cursorIndex < 0) {
                this.cursorIndex = 0;
            }
            this.regenerateLineBreakMeasurer();
        } else if (this.cursorIndex == 0 && lineIndex > 0) {
            StringBuffer previousLine = (StringBuffer)this.buffers.elementAt(lineIndex - 1);
            this.cursorIndex = previousLine.length();
            previousLine.append(this.currentText.toString());
            int index = this.buffers.indexOf(this.currentText);
            this.buffers.remove(this.currentText);
            this.colors.removeElementAt(index);
            this.currentText = previousLine;
            this.regenerateLineBreakMeasurer();
        }
    }

    protected void regenerateLineBreakMeasurer() {
        this.iterators = new Vector();
        this.measurers = new Vector();
        int i = 0;
        while (i < this.buffers.size()) {
            StringBuffer currBuffer = (StringBuffer)this.buffers.elementAt(i);
            AttributedString attrString = new AttributedString(currBuffer.toString());
            if (currBuffer.toString().length() > 0) {
                attrString.addAttribute(TextAttribute.SIZE, new Float(this.fontSize));
                Font font = new Font("Comic Sans MS", 1, this.fontSize);
                attrString.addAttribute(TextAttribute.FONT, font);
            }
            AttributedCharacterIterator itr = attrString.getIterator();
            this.iterators.addElement(itr);
            if (itr.getEndIndex() != 0) {
                this.measurers.addElement(new LineBreakMeasurer(itr, this.frc));
            } else {
                this.measurers.addElement(null);
            }
            ++i;
        }
    }

    public Shape getCaretShape() {
        return this.caretShape;
    }

    public int getStartY() {
        return (int)this.textOrigin.getY() + (int)this.lineAscent;
    }

    public int getNextY(int currentY) {
        return currentY + (int)this.lineHeight;
    }

    public Vector getShapes() {
        Vector<ScreenShape> shapes = new Vector<ScreenShape>();
        double line = 0.0;
        int i = 0;
        while (i < this.iterators.size()) {
            AttributedCharacterIterator itr = (AttributedCharacterIterator)this.iterators.elementAt(i);
            StringBuffer bfr = (StringBuffer)this.buffers.elementAt(i);
            Color color = (Color)this.colors.elementAt(i);
            int paragraphStart = itr.getBeginIndex();
            int paragraphEnd = itr.getEndIndex();
            LineBreakMeasurer msr = (LineBreakMeasurer)this.measurers.elementAt(i);
            if (msr != null) {
                msr.setPosition(paragraphStart);
                while (msr.getPosition() < paragraphEnd) {
                    int begin = msr.getPosition();
                    TextLayout layout = msr.nextLayout(this.textWidth);
                    int end = begin + layout.getCharacterCount();
                    this.lineHeight = layout.getAscent() + layout.getDescent() + layout.getLeading();
                    this.lineAscent = layout.getAscent();
                    if (this.currentText == bfr && this.cursorIndex >= begin && this.cursorIndex <= end) {
                        Shape[] carets = layout.getCaretShapes(this.cursorIndex - begin);
                        AffineTransform at = new AffineTransform();
                        at.translate(this.textOrigin.getX(), (double)this.getStartY() + line * (double)this.lineHeight);
                        this.caretShape = at.createTransformedShape(carets[0]);
                    }
                    AffineTransform at = new AffineTransform();
                    at.translate(this.textOrigin.getX(), (double)this.getStartY() + line * (double)this.lineHeight);
                    Shape s = layout.getOutline(at);
                    ScreenShape sShape = new ScreenShape(color, s, true, 5);
                    shapes.addElement(sShape);
                    line += 1.0;
                }
                line += 0.5;
            }
            ++i;
        }
        return shapes;
    }

    public Vector getText() {
        Vector<String> strings = new Vector<String>();
        int i = 0;
        while (i < this.buffers.size()) {
            String st = ((StringBuffer)this.buffers.elementAt(i)).toString();
            if (st.length() > 0) {
                strings.addElement(st);
            }
            ++i;
        }
        return strings;
    }

    public Vector getColors() {
        return this.colors;
    }

    public void updateCaretPosition(Point clickPos) {
        float clickX = (float)(clickPos.getX() - this.textOrigin.getX());
        float clickY = (float)(clickPos.getY() - this.textOrigin.getY());
        float bottomBoundary = 0.0f;
        float topBoundary = 0.0f;
        int i = 0;
        while (i < this.iterators.size()) {
            AttributedCharacterIterator iterator = (AttributedCharacterIterator)this.iterators.elementAt(i);
            LineBreakMeasurer measurer = (LineBreakMeasurer)this.measurers.elementAt(i);
            int paragraphStart = iterator.getBeginIndex();
            int paragraphEnd = iterator.getEndIndex();
            if (measurer != null) {
                measurer.setPosition(paragraphStart);
            }
            this.cursorIndex = 0;
            this.currentText = null;
            if (measurer != null) {
                while (measurer.getPosition() < paragraphEnd) {
                    TextLayout layout = measurer.nextLayout(this.textWidth);
                    bottomBoundary = topBoundary + this.lineHeight;
                    if (clickY > topBoundary && clickY < bottomBoundary) {
                        TextHitInfo currentHit = layout.hitTestChar(clickX, clickY);
                        if (currentHit != null) {
                            this.currentText = (StringBuffer)this.buffers.elementAt(i);
                            this.cursorIndex += currentHit.getInsertionIndex();
                            return;
                        }
                    } else {
                        this.cursorIndex = measurer.getPosition();
                    }
                    topBoundary = bottomBoundary;
                }
                topBoundary += this.lineHeight / 2.0f;
            }
            ++i;
        }
        if (this.currentText == null) {
            this.currentText = (StringBuffer)this.buffers.elementAt(0);
            this.cursorIndex = 0;
        }
    }
}

