/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.stencilhelp.client;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.caitlin.stencilhelp.application.StateCapsule;
import edu.cmu.cs.stage3.caitlin.stencilhelp.application.StencilApplication;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.Frame;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.Hole;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.KeyEventListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.LayoutChangeListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.Link;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.Menu;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.MouseEventListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.NavigationBar;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.Note;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ObjectPositionManager;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ReadWriteListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilClient;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilFocusListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilObject;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilPanel;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilPanelMessageListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilParser;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilStackChangeListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.TutorialEditor;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.TutorialEditorMenus;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.WaitAndUpdateThread;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.DialogManager;
import edu.cmu.cs.stage3.xml.Encoder;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StencilManager
implements MouseListener,
MouseMotionListener,
KeyListener,
StencilClient,
StencilStackChangeListener {
    StencilApplication stencilApp = null;
    StencilPanel stencilPanel = null;
    ObjectPositionManager positionManager = null;
    Vector updateShapes = null;
    Vector clearRegions = null;
    StencilParser stencilParser = null;
    Vector mouseEventListeners = new Vector();
    Vector keyEventListeners = new Vector();
    Vector stencilFocusListeners = new Vector();
    Vector layoutChangeListeners = new Vector();
    Vector stencilStackChangeListeners = new Vector();
    Vector readWriteListeners = new Vector();
    Vector stencilList = new Vector();
    int currentStencilIndex = 0;
    StencilObject focalObject = null;
    StencilMouseAdapter mouseAdapter = new StencilMouseAdapter();
    Stencil errorStencil = null;
    boolean writeEnabled = true;
    boolean stencilChanged = false;
    String worldToLoad = null;
    String nextStack = null;
    String previousStack = null;
    long lastRedrawTime = -1L;
    boolean overrideMinResolution = false;
    private NavigationBar navBar;
    private boolean editorDirty = false;
    private boolean captureMode = false;
    private File captureFolder;
    public static final boolean SHOW_TUTORIAL_MENUES = false;
    private TutorialEditorMenus tutorialEditorMenus;
    private TutorialEditor tutorialEditor;
    private File tutorialFile;

    public StencilManager(StencilApplication stencilApp) {
        this.stencilApp = stencilApp;
        this.stencilPanel = new StencilPanel(this);
        this.tutorialEditorMenus = new TutorialEditorMenus(this);
        this.stencilPanel.addMessageListener(this.tutorialEditorMenus);
        this.addMouseEventListener(this.stencilPanel);
        this.addReadWriteListener(this.stencilPanel);
        this.positionManager = new ObjectPositionManager(stencilApp);
        this.insertNewStencil(false);
        this.triggerRefresh();
        this.tutorialEditor = new TutorialEditor(this);
    }

    protected void createDefaultStencilObjects() {
        Stencil currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
        NavigationBar navBar = new NavigationBar(this, this.positionManager);
        this.addMouseEventListener(navBar);
        this.addStencilStackChangeListener(navBar);
        currentStencil.addObject(navBar);
        this.addStencilFocusListener(this.tutorialEditorMenus);
        currentStencil.addObject(this.tutorialEditorMenus);
    }

    protected void triggerRefresh() {
        this.stencilPanel.redraw();
    }

    protected void triggerRefresh(long time) {
        if (time > this.lastRedrawTime) {
            this.lastRedrawTime = time;
            this.stencilPanel.redraw();
        }
    }

    protected void requestFocus(StencilObject newFocalObject) {
        if (this.focalObject != null && this.focalObject instanceof StencilFocusListener && this.stencilFocusListeners.contains(this.focalObject)) {
            ((StencilFocusListener)((Object)this.focalObject)).focusLost();
        }
        if (newFocalObject != null && newFocalObject instanceof StencilFocusListener && this.stencilFocusListeners.contains(this.focalObject)) {
            ((StencilFocusListener)((Object)newFocalObject)).focusGained();
        }
        this.setNewFocalObject(newFocalObject);
    }

    protected String showDialog(FileFilter filter) {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        if (filter != null) {
            chooser.setFileFilter(filter);
        }
        if ((returnVal = chooser.showOpenDialog(this.stencilPanel)) == 0) {
            return chooser.getCurrentDirectory() + File.separator + chooser.getSelectedFile().getName();
        }
        return null;
    }

    public Stencil newStencil() {
        return new Stencil();
    }

    public Stencil newStencil(int stepsToGoBack) {
        Stencil newStencil = new Stencil();
        newStencil.setSteps(stepsToGoBack);
        return newStencil;
    }

    public void loadStencilsFile() {
        File loadFile = null;
        StencilFileFilter filter = new StencilFileFilter();
        while (loadFile == null) {
            String fileName = this.showDialog(filter);
            if (fileName != null) {
                loadFile = new File(fileName);
                if (loadFile.exists()) continue;
                int ans = DialogManager.showConfirmDialog(String.valueOf(Messages.getString("Can_t_find_")) + fileName + Messages.getString("__Please_choose_another"), Messages.getString("Can_t_find_file"), 2);
                if (ans == 2) {
                    return;
                }
                loadFile = null;
                continue;
            }
            return;
        }
        this.loadStencilTutorial(loadFile);
    }

    public void saveStencilsFile() {
        Document document;
        File saveFile = null;
        while (saveFile == null) {
            String fileName = this.showDialog(null);
            if (fileName != null) {
                String msg;
                int ans;
                saveFile = new File(fileName);
                if (!fileName.endsWith(".stl")) {
                    fileName = String.valueOf(fileName) + ".stl";
                }
                if (!saveFile.exists() || (ans = DialogManager.showConfirmDialog(msg = Messages.getString("This_file_already_exists__do_you_want_to_overwrite_it_"), Messages.getString("File_already_exists"), 1)) == 0) continue;
                if (ans == 1) {
                    saveFile = null;
                    continue;
                }
                if (ans != 2) continue;
                return;
            }
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            document = null;
        }
        if (document != null) {
            Element root = document.createElement("stencilStack");
            root.setAttribute("access", "read");
            if (this.worldToLoad != null) {
                root.setAttribute("world", this.worldToLoad);
            }
            if (this.nextStack != null) {
                root.setAttribute("nextStack", this.nextStack);
            }
            if (this.previousStack != null) {
                root.setAttribute("previousStack", this.previousStack);
            }
            int i = 0;
            while (i < this.stencilList.size()) {
                Stencil stencil = (Stencil)this.stencilList.elementAt(i);
                stencil.write(document, root);
                ++i;
            }
            document.appendChild(root);
            document.getDocumentElement().normalize();
            try {
                FileWriter fileWriter = new FileWriter(saveFile);
                Encoder.write(document, fileWriter);
                fileWriter.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void toggleLock() {
        this.setWriteEnabled(!this.writeEnabled);
    }

    public void createNewHole(Point p) {
        String id = this.stencilApp.getIDForPoint(p, false);
        if (id != null) {
            Hole h = new Hole(id, this.positionManager, this.stencilApp, this);
            this.addMouseEventListener(h);
            this.addLayoutChangeListener(h);
            Note n = new Note(p, new Point(30, 30), h, this.positionManager, this, false);
            this.addMouseEventListener(n);
            this.addKeyEventListener(n);
            Stencil currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
            currentStencil.addObject(h);
            currentStencil.addObject(n);
            this.setNewFocalObject(n);
            this.announceLayoutChange();
            n.initializeNote();
            this.triggerRefresh();
        }
    }

    public void createNewFrame(Point p) {
        String id = this.stencilApp.getIDForPoint(p, false);
        if (id != null) {
            Frame h = new Frame(id, this.positionManager);
            this.addLayoutChangeListener(h);
            Note n = new Note(p, new Point(30, 30), h, this.positionManager, this, false);
            this.addMouseEventListener(n);
            this.addKeyEventListener(n);
            Stencil currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
            currentStencil.addObject(h);
            currentStencil.addObject(n);
            this.setNewFocalObject(n);
            this.announceLayoutChange();
            n.initializeNote();
            this.triggerRefresh();
        }
    }

    public void createNewNote(Point p) {
        Note n = new Note(p, new Point(0, 0), null, this.positionManager, this, false);
        this.addMouseEventListener(n);
        this.addKeyEventListener(n);
        Stencil currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
        currentStencil.addObject(n);
        this.announceLayoutChange();
        n.initializeNote();
        this.triggerRefresh();
        this.setNewFocalObject(n);
    }

    public void removeAllObjects() {
        this.setNewFocalObject(null);
        Stencil currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
        currentStencil.removeAllObjects();
        this.stencilChanged = true;
    }

    protected Vector getShapesToDraw() {
        Vector shapes = new Vector();
        Stencil currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
        Vector currentObjects = currentStencil.getObjects();
        int i = 0;
        while (i < currentObjects.size()) {
            StencilObject screenObj = (StencilObject)currentObjects.elementAt(i);
            Vector temp = screenObj.getShapes();
            if (temp != null) {
                shapes.addAll(temp);
            }
            ++i;
        }
        return shapes;
    }

    public Vector getUpdateShapes() {
        this.updateDrawInfo();
        return this.updateShapes;
    }

    public Vector getClearRegions() {
        return this.clearRegions;
    }

    protected void updateDrawInfo() {
        StencilObject obj;
        int i;
        this.updateShapes = new Vector();
        this.clearRegions = new Vector();
        Stencil currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
        Vector currentObjects = currentStencil.getObjects();
        Vector<StencilObject> unmodifiedObjects = new Vector<StencilObject>();
        boolean overlapping = false;
        if (!this.stencilChanged) {
            i = 0;
            while (i < currentObjects.size()) {
                obj = (StencilObject)currentObjects.elementAt(i);
                if (obj.isModified()) {
                    Rectangle clear;
                    Vector objShapes = obj.getShapes();
                    if (objShapes != null) {
                        this.updateShapes.addAll(objShapes);
                    }
                    if ((clear = obj.getPreviousRectangle()) != null) {
                        this.clearRegions.addElement(clear);
                    }
                } else {
                    unmodifiedObjects.addElement(obj);
                }
                ++i;
            }
            i = 0;
            while (i < unmodifiedObjects.size()) {
                obj = (StencilObject)unmodifiedObjects.elementAt(i);
                Rectangle objRect = obj.getRectangle();
                Rectangle prevObjRect = obj.getPreviousRectangle();
                if (prevObjRect == null) {
                    prevObjRect = objRect;
                }
                if (objRect != null) {
                    int j = 0;
                    while (j < this.clearRegions.size()) {
                        Rectangle clearRect = (Rectangle)this.clearRegions.elementAt(j);
                        if (clearRect.intersects(objRect) || clearRect.intersects(prevObjRect)) {
                            overlapping = true;
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (overlapping || this.stencilChanged) {
            this.updateShapes = new Vector();
            this.clearRegions = new Vector();
            this.clearRegions.addElement(new Rectangle(0, 0, this.stencilPanel.getWidth(), this.stencilPanel.getHeight()));
            i = 0;
            while (i < currentObjects.size()) {
                obj = (StencilObject)currentObjects.elementAt(i);
                Vector newShapes = obj.getShapes();
                if (newShapes != null) {
                    this.updateShapes.addAll(obj.getShapes());
                }
                ++i;
            }
            this.stencilChanged = false;
        }
    }

    public boolean hasNext() {
        boolean autoAdvancingHole = false;
        Stencil currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
        if (currentStencil != null) {
            Vector stencilObjects = currentStencil.getObjects();
            int i = 0;
            while (i < stencilObjects.size()) {
                StencilObject stencilObj = (StencilObject)stencilObjects.elementAt(i);
                if (stencilObj instanceof Hole && ((Hole)stencilObj).getAutoAdvance() && ((Hole)stencilObj).getAdvanceEvent() != 2) {
                    autoAdvancingHole = true;
                }
                ++i;
            }
        }
        return this.currentStencilIndex < this.stencilList.size() - 1 && !autoAdvancingHole;
    }

    public boolean hasPrevious() {
        if (this.currentStencilIndex > 0) {
            Stencil currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
            return currentStencil.getStepsToGoBack() > 0;
        }
        return false;
    }

    public int getStencilNumber() {
        return this.currentStencilIndex;
    }

    public int getNumberOfStencils() {
        return this.stencilList.size();
    }

    public void reloadStencils() {
        this.loadWorld();
        Stencil currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
        currentStencil.setCurrentStencil(false);
        this.currentStencilIndex = 0;
        currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
        currentStencil.setCurrentStencil(true);
        this.broadcastStencilNumberChange();
        this.stencilApp.clearWayPoints();
        this.stencilApp.makeWayPoint();
        this.stencilChanged = true;
    }

    protected boolean checkState(Stencil currentStencil) {
        boolean appInRightState;
        if (this.writeEnabled) {
            currentStencil.setEndState(this.stencilApp.getCurrentState());
            return true;
        }
        return currentStencil.getEndState() == null || (appInRightState = this.stencilApp.doesStateMatch(currentStencil.getEndState()));
    }

    public void showNextStencil() {
        if (this.currentStencilIndex < this.stencilList.size() - 1) {
            Stencil currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
            boolean checkState = this.checkState(currentStencil);
            currentStencil.setCurrentStencil(false);
            ++this.currentStencilIndex;
            currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
            currentStencil.setCurrentStencil(true);
            if (!checkState) {
                currentStencil.setErrorStencil(true);
            }
            this.broadcastStencilNumberChange();
            this.stencilChanged = true;
            this.stencilApp.makeWayPoint();
        }
    }

    public void showPreviousStencil() {
        int stepsToGoBack;
        Stencil currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
        if (currentStencil != null && (stepsToGoBack = currentStencil.getStepsToGoBack()) > 0) {
            int i = 0;
            while (i < stepsToGoBack) {
                this.stencilApp.goToPreviousWayPoint();
                ++i;
            }
            if (this.currentStencilIndex > stepsToGoBack - 1) {
                currentStencil.setCurrentStencil(false);
                this.currentStencilIndex -= stepsToGoBack;
            }
            currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
            currentStencil.setCurrentStencil(true);
            this.broadcastStencilNumberChange();
            this.stencilChanged = true;
        }
    }

    protected File getFile(String fileName) {
        File file;
        int index = fileName.indexOf("/");
        int length = fileName.length();
        String fileString = null;
        if (index != -1) {
            fileString = String.valueOf(fileName.substring(0, index)) + File.separator + fileName.substring(index + 1, length);
        }
        if ((file = new File(fileString)).exists()) {
            return file;
        }
        return null;
    }

    public void showNextStack() {
        File nextFile = this.getFile(this.nextStack);
        if (nextFile != null) {
            this.loadStencilTutorial(nextFile);
        }
    }

    public void showPreviousStack() {
        File previousFile = this.getFile(this.previousStack);
        if (previousFile != null) {
            this.loadStencilTutorial(previousFile);
        }
    }

    public void insertNewStencil() {
        Stencil currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
        boolean checkState = this.checkState(currentStencil);
        currentStencil.setCurrentStencil(false);
        ++this.currentStencilIndex;
        currentStencil = new Stencil();
        this.stencilList.insertElementAt(currentStencil, this.currentStencilIndex);
        this.createDefaultStencilObjects();
        currentStencil.setCurrentStencil(true);
        this.broadcastStencilNumberChange();
        this.stencilChanged = true;
        this.stencilApp.makeWayPoint();
        this.triggerRefresh();
    }

    @Override
    public boolean isDropAccessible(Point p) {
        return false;
    }

    @Override
    public void update() {
        if (this.getIsShowing()) {
            this.announceLayoutChange();
        }
    }

    @Override
    public void stateChanged() {
    }

    @Override
    public Component getStencilComponent() {
        return this.stencilPanel;
    }

    @Override
    public void showStencils(boolean show) {
        this.stencilPanel.setIsDrawing(show);
        if (this.getIsShowing()) {
            this.stencilPanel.removeMouseListener(this.mouseAdapter);
            this.stencilPanel.removeMouseMotionListener(this);
            this.stencilPanel.addMouseListener(this.mouseAdapter);
            this.stencilPanel.addMouseMotionListener(this);
            if (this.writeEnabled) {
                this.addStencilStackChangeListener(this);
            }
            this.update();
        } else {
            this.stencilApp.setVisible(false);
            this.stencilPanel.removeMouseListener(this.mouseAdapter);
            this.stencilPanel.removeMouseMotionListener(this);
            this.currentStencilIndex = 0;
            this.stencilList.removeAllElements();
            this.stencilList.addElement(this.newStencil());
        }
    }

    @Override
    public boolean getIsShowing() {
        return this.stencilPanel.getIsDrawing();
    }

    @Override
    public void loadStencilTutorial(File tutorialFile) {
        this.showStencils(true);
        this.stencilParser = new StencilParser(this, this.positionManager, this.stencilApp);
        this.worldToLoad = null;
        this.nextStack = null;
        this.previousStack = null;
        Vector newStencilList = this.stencilParser.parseFile(tutorialFile);
        this.mouseEventListeners = new Vector();
        this.keyEventListeners = new Vector();
        this.stencilFocusListeners = new Vector();
        this.layoutChangeListeners = new Vector();
        this.stencilStackChangeListeners = new Vector();
        this.currentStencilIndex = 0;
        this.setNewFocalObject(null);
        this.stencilPanel.removeAllMessageListeners();
        this.addMouseEventListener(this.stencilPanel);
        this.addReadWriteListener(this.stencilPanel);
        if (this.stencilApp instanceof AuthoringTool) {
            ((AuthoringTool)this.stencilApp).stencilManagerReFocus();
        } else {
            this.stencilApp.deFocus();
        }
        this.stencilList = newStencilList;
        this.addLinks();
        if (tutorialFile == null) {
            this.insertNewStencil(true);
        }
        Stencil currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
        currentStencil.setCurrentStencil(true);
        this.broadcastCurrentStencilChange();
        this.broadcastStencilNumberChange();
        this.stencilChanged = true;
        this.triggerRefresh();
        this.stencilApp.clearWayPoints();
        this.stencilApp.makeWayPoint();
        this.tutorialFile = tutorialFile;
        this.tutorialEditor.update();
    }

    public void addStencilStackChangeListener(StencilStackChangeListener sscListener) {
        this.stencilStackChangeListeners.addElement(sscListener);
    }

    public void removeStencilStackChangeListener(StencilStackChangeListener sscListener) {
        this.stencilStackChangeListeners.remove(sscListener);
    }

    protected void broadcastStencilNumberChange() {
        int i = 0;
        while (i < this.stencilStackChangeListeners.size()) {
            ((StencilStackChangeListener)this.stencilStackChangeListeners.elementAt(i)).numberOfStencilsChanged(this.stencilList.size());
            ++i;
        }
    }

    protected void broadcastCurrentStencilChange() {
        int i = 0;
        while (i < this.stencilStackChangeListeners.size()) {
            ((StencilStackChangeListener)this.stencilStackChangeListeners.elementAt(i)).currentStencilChanged(this.currentStencilIndex);
            ++i;
        }
    }

    public void addReadWriteListener(ReadWriteListener rwListener) {
        this.readWriteListeners.addElement(rwListener);
    }

    public void removeReadWriteListener(ReadWriteListener rwListener) {
        this.readWriteListeners.removeElement(rwListener);
    }

    public void setWriteEnabled(boolean enabled) {
        this.writeEnabled = enabled;
        int i = 0;
        while (i < this.readWriteListeners.size()) {
            ReadWriteListener rwL = (ReadWriteListener)this.readWriteListeners.elementAt(i);
            rwL.setWriteEnabled(this.writeEnabled);
            ++i;
        }
        this.triggerRefresh();
    }

    protected void loadWorld() {
        if (this.worldToLoad != null) {
            int index = this.worldToLoad.indexOf("/");
            int length = this.worldToLoad.length();
            String worldString = null;
            if (index != -1) {
                worldString = String.valueOf(this.worldToLoad.substring(0, index)) + File.separator + this.worldToLoad.substring(index + 1, length);
            }
            if (worldString != null) {
                this.stencilApp.performTask("loadWorld<" + worldString + ">");
            }
        }
    }

    public void setWorld(String worldToLoad) {
        this.worldToLoad = worldToLoad;
        this.loadWorld();
    }

    public void setNextAndPreviousStacks(String previousStack, String nextStack) {
        this.previousStack = previousStack;
        this.nextStack = nextStack;
    }

    protected void addLinks() {
        Stencil stencil;
        if (this.previousStack != null && this.stencilList.size() > 0) {
            stencil = (Stencil)this.stencilList.elementAt(0);
            stencil.addObject(new Link(this, this.positionManager, false));
        }
        if (this.nextStack != null && this.stencilList.size() > 0) {
            stencil = (Stencil)this.stencilList.elementAt(this.stencilList.size() - 1);
            stencil.addObject(new Link(this, this.positionManager, true));
        }
    }

    public void addLayoutChangeListener(LayoutChangeListener lcListener) {
        this.layoutChangeListeners.addElement(lcListener);
    }

    public void removeLayoutChangeListener(LayoutChangeListener lcListener) {
        this.layoutChangeListeners.remove(lcListener);
    }

    protected void announceLayoutChange() {
        LayoutChangeListener lcListener;
        boolean error = false;
        int i = 0;
        while (i < this.layoutChangeListeners.size()) {
            lcListener = (LayoutChangeListener)this.layoutChangeListeners.elementAt(i);
            if (!(lcListener instanceof Note)) {
                boolean bl = error = !lcListener.layoutChanged();
            }
            if (error) {
                Stencil currentStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
                currentStencil.setErrorStencil(true);
            }
            ++i;
        }
        i = 0;
        while (i < this.layoutChangeListeners.size()) {
            lcListener = (LayoutChangeListener)this.layoutChangeListeners.elementAt(i);
            if (lcListener instanceof Note) {
                lcListener.layoutChanged();
            }
            this.stencilChanged = true;
            ++i;
        }
        this.triggerRefresh();
    }

    public void addStencilFocusListener(StencilFocusListener sfListener) {
        this.stencilFocusListeners.addElement(sfListener);
    }

    public void removeStencilFocusListener(StencilFocusListener sfListener) {
        this.stencilFocusListeners.remove(sfListener);
    }

    protected void setNewFocalListener(MouseEventListener meListener) {
        StencilObject newFocalObject = null;
        if (meListener instanceof StencilObject) {
            newFocalObject = (StencilObject)((Object)meListener);
        }
        if (this.focalObject != newFocalObject) {
            if (this.focalObject != null && this.focalObject instanceof StencilFocusListener && this.stencilFocusListeners.contains(this.focalObject)) {
                ((StencilFocusListener)((Object)this.focalObject)).focusLost();
            }
            if (newFocalObject != null && newFocalObject instanceof StencilFocusListener && this.stencilFocusListeners.contains(this.focalObject)) {
                ((StencilFocusListener)((Object)newFocalObject)).focusGained();
            }
            if (this.focalObject instanceof Hole) {
                this.stencilApp.deFocus();
            }
            this.setNewFocalObject(newFocalObject);
        }
    }

    public void addMouseEventListener(MouseEventListener meListener) {
        if (meListener instanceof StencilPanel) {
            this.mouseEventListeners.addElement(meListener);
        } else {
            this.mouseEventListeners.insertElementAt(meListener, 0);
        }
    }

    public void removeMouseEventListener(MouseEventListener meListener) {
        this.mouseEventListeners.removeElement(meListener);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int i = 0;
        while (i < this.mouseEventListeners.size()) {
            MouseEventListener meListener = (MouseEventListener)this.mouseEventListeners.elementAt(i);
            if (meListener.contains(e.getPoint())) {
                this.setNewFocalListener(meListener);
                boolean refresh = meListener.mousePressed(e);
                if (refresh) {
                    this.triggerRefresh(e.getWhen());
                }
                return;
            }
            ++i;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        boolean refresh;
        if (this.focalObject != null && this.focalObject instanceof MouseEventListener && (refresh = ((MouseEventListener)((Object)this.focalObject)).mouseReleased(e))) {
            this.triggerRefresh(e.getWhen());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int i = 0;
        while (i < this.mouseEventListeners.size()) {
            MouseEventListener meListener = (MouseEventListener)this.mouseEventListeners.elementAt(i);
            if (meListener.contains(e.getPoint())) {
                this.setNewFocalListener(meListener);
                boolean refresh = meListener.mouseClicked(e);
                if (refresh) {
                    this.triggerRefresh(e.getWhen());
                }
                return;
            }
            ++i;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int i = 0;
        while (i < this.mouseEventListeners.size()) {
            MouseEventListener meListener = (MouseEventListener)this.mouseEventListeners.elementAt(i);
            if (meListener.contains(e.getPoint())) {
                boolean refresh = meListener.mouseMoved(e);
                if (refresh) {
                    this.triggerRefresh(e.getWhen());
                }
                return;
            }
            ++i;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        boolean refresh;
        if (this.focalObject != null && this.focalObject instanceof MouseEventListener && (refresh = ((MouseEventListener)((Object)this.focalObject)).mouseDragged(e))) {
            this.triggerRefresh(e.getWhen());
        }
    }

    public void addKeyEventListener(KeyEventListener keListener) {
        this.keyEventListeners.addElement(keListener);
    }

    public void removeKeyEventListener(KeyEventListener keListener) {
        this.keyEventListeners.remove(keListener);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        boolean refresh;
        if (this.focalObject != null && this.focalObject instanceof KeyEventListener && (refresh = ((KeyEventListener)((Object)this.focalObject)).keyTyped(e))) {
            this.triggerRefresh(e.getWhen());
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        boolean refresh;
        if (this.focalObject != null && this.focalObject instanceof KeyEventListener && (refresh = ((KeyEventListener)((Object)this.focalObject)).keyPressed(e))) {
            this.triggerRefresh(e.getWhen());
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        boolean refresh;
        if (this.focalObject != null && this.focalObject instanceof KeyEventListener && (refresh = ((KeyEventListener)((Object)this.focalObject)).keyReleased(e))) {
            this.triggerRefresh(e.getWhen());
        }
    }

    @Override
    public void numberOfStencilsChanged(int newNumberOfStencils) {
        if (this.writeEnabled) {
            Stencil stencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
        }
    }

    @Override
    public void currentStencilChanged(int selectedStencil) {
        if (this.writeEnabled) {
            Stencil stencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
        }
    }

    protected void setNewFocalObject(StencilObject newFocalObject) {
        this.focalObject = newFocalObject;
        if (this.writeEnabled && newFocalObject instanceof Note) {
            StencilObject cfr_ignored_0 = ((Note)newFocalObject).scrObject;
        }
    }

    public boolean newTutorial() {
        if (this.editorDirty && !this.handleNonSaved()) {
            return false;
        }
        this.loadStencilTutorial(null);
        this.tutorialEditor.update();
        return true;
    }

    public void insertNewStencil(boolean paramBoolean) {
        Stencil localStencil;
        if (this.stencilList != null && this.stencilList.size() > 0) {
            localStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
            boolean bool = this.checkState(localStencil);
            if (!bool) {
                // empty if block
            }
            localStencil.setCurrentStencil(false);
            ++this.currentStencilIndex;
        }
        localStencil = new Stencil();
        this.stencilList.insertElementAt(localStencil, this.currentStencilIndex);
        this.createDefaultStencilObjects();
        localStencil.setCurrentStencil(true);
        this.broadcastStencilNumberChange();
        this.stencilChanged = true;
        this.stencilApp.makeWayPoint();
        this.editorDirty = paramBoolean;
        this.triggerRefresh();
    }

    public void addToCurrentStencil(StencilObject paramStencilObject) {
        if (paramStencilObject != null) {
            Stencil localStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
            localStencil.addObject(paramStencilObject);
        }
    }

    public void addStencilObject(Note paramNote, StencilObject paramStencilObject) {
        if (paramStencilObject != null) {
            if (paramStencilObject instanceof MouseEventListener) {
                this.addMouseEventListener((MouseEventListener)((Object)paramStencilObject));
            }
            this.addLayoutChangeListener((LayoutChangeListener)((Object)paramStencilObject));
        }
        this.addMouseEventListener(paramNote);
        this.addKeyEventListener(paramNote);
        this.addToCurrentStencil(paramStencilObject);
        this.addToCurrentStencil(paramNote);
        this.setNewFocalObject(paramNote);
        this.announceLayoutChange();
        paramNote.initializeNote();
        this.editorDirty = true;
        this.triggerRefresh();
    }

    public Note createNewHole(Point paramPoint, boolean paramBoolean) {
        String str = this.stencilApp.getIDForPoint(paramPoint, false);
        Note localNote = null;
        if (str != null) {
            Hole localHole = new Hole(str, this.positionManager, this.stencilApp, this);
            localHole.setAutoAdvance(paramBoolean, 4);
            localNote = new Note(paramPoint, new Point(30, 30), localHole, this.positionManager, this, false);
            this.addStencilObject(localNote, localHole);
        }
        return localNote;
    }

    public Note createNewFrame(Point paramPoint, boolean paramBoolean) {
        String str = this.stencilApp.getIDForPoint(paramPoint, false);
        Note localNote = null;
        if (str != null) {
            Frame localFrame = new Frame(str, this.positionManager);
            localNote = new Note(paramPoint, new Point(30, 30), localFrame, this.positionManager, this, paramBoolean);
            this.addStencilObject(localNote, localFrame);
        }
        return localNote;
    }

    public Note createNewNote(Point paramPoint, boolean paramBoolean) {
        Note localNote = new Note(paramPoint, new Point(0, 0), null, this.positionManager, this, paramBoolean);
        this.addStencilObject(localNote, null);
        return localNote;
    }

    public void removeLastStencilObject() {
        Stencil localStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
        localStencil.removeLastObject();
        this.stencilChanged = true;
        this.editorDirty = true;
    }

    public void removeAllObjectsFromCurrentStencil() {
        this.setNewFocalObject(null);
        Stencil localStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
        localStencil.removeAllObjects();
        this.stencilChanged = true;
        this.editorDirty = true;
    }

    public void gotoStencil(int paramInt) {
        Stencil localStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
        if (paramInt < this.stencilList.size() && paramInt != this.currentStencilIndex) {
            boolean bool = this.checkState(localStencil);
            localStencil.setCurrentStencil(false);
            this.currentStencilIndex = paramInt;
            localStencil = (Stencil)this.stencilList.elementAt(this.currentStencilIndex);
            localStencil.setCurrentStencil(true);
            this.broadcastStencilNumberChange();
            this.stencilChanged = true;
            this.stencilApp.makeWayPoint();
        }
    }

    public void showStencilPanel(boolean paramBoolean) {
        this.stencilPanel.setIsDrawing(paramBoolean);
    }

    public void setTutorialWorld(String paramString) {
        this.worldToLoad = paramString;
    }

    public void regainFocus() {
        if (this.stencilApp instanceof AuthoringTool) {
            ((AuthoringTool)this.stencilApp).stencilManagerReFocus();
        }
    }

    public void removeCurrStencil() {
        if (this.stencilList.size() > 1) {
            this.setNewFocalObject(null);
            ((Stencil)this.stencilList.get(this.currentStencilIndex)).setCurrentStencil(false);
            this.stencilList.remove(this.currentStencilIndex);
            if (this.currentStencilIndex == this.stencilList.size()) {
                --this.currentStencilIndex;
            }
            ((Stencil)this.stencilList.get(this.currentStencilIndex)).setCurrentStencil(true);
            this.broadcastStencilNumberChange();
            this.stencilChanged = true;
            this.stencilApp.makeWayPoint();
            this.editorDirty = true;
            this.triggerRefresh();
        } else {
            this.removeAllObjectsFromCurrentStencil();
        }
    }

    public boolean isWriteEnabled() {
        return this.writeEnabled;
    }

    public boolean handleNonSaved() {
        String str = "File not saved, save now?";
        int i = DialogManager.showConfirmDialog(str, "File not saved", 1);
        if (i == 0) {
            this.saveStencilsFile();
            return true;
        }
        return i == 1;
    }

    public boolean setInstructorMode(boolean paramBoolean) {
        if (this.editorDirty && this.writeEnabled != paramBoolean && !paramBoolean) {
            if (this.handleNonSaved()) {
                this.editorDirty = false;
            } else {
                return false;
            }
        }
        this.setWriteEnabled(paramBoolean);
        this.tutorialEditor.update();
        this.tutorialEditor.display(paramBoolean);
        return true;
    }

    public boolean isInstructorMode() {
        return this.writeEnabled;
    }

    public void setCaptureFolder(File paramFile) {
        this.captureFolder = paramFile;
    }

    public void setCaptureMode(boolean paramBoolean) {
        this.captureMode = paramBoolean;
    }

    public class Stencil {
        protected Vector stencilObjects = new Vector();
        protected StateCapsule endStateCapsule = null;
        protected boolean error = false;
        protected int goBackSteps = 1;

        public void setSteps(int goBackSteps) {
            this.goBackSteps = goBackSteps;
        }

        public int getStepsToGoBack() {
            return this.goBackSteps;
        }

        public StateCapsule getEndState() {
            return this.endStateCapsule;
        }

        public void setEndState(StateCapsule stateCapsule) {
            this.endStateCapsule = stateCapsule;
        }

        public void write(Document document, Element element) {
            Element stencilElement = document.createElement("stencil");
            String stencilTitle = null;
            if (this.endStateCapsule != null) {
                Element stateNode = document.createElement("stateCapsule");
                CDATASection stateDataSection = document.createCDATASection(this.endStateCapsule.getStorableRepr());
                stateNode.appendChild(stateDataSection);
                stencilElement.appendChild(stateNode);
            }
            int i = 0;
            while (i < this.stencilObjects.size()) {
                StencilObject stencilObj = (StencilObject)this.stencilObjects.elementAt(i);
                if (stencilObj instanceof Note) {
                    ((Note)stencilObj).write(document, stencilElement);
                } else if (stencilObj instanceof NavigationBar) {
                    stencilTitle = ((NavigationBar)stencilObj).getTitleString();
                }
                ++i;
            }
            if (stencilTitle != null) {
                stencilElement.setAttribute("title", stencilTitle);
            }
            stencilElement.setAttribute("stepsToGoBack", Integer.toString(this.goBackSteps));
            element.appendChild(stencilElement);
        }

        public void setErrorStencil(boolean idError) {
            StencilManager.this.stencilChanged = true;
            this.error = idError;
            StencilManager.this.triggerRefresh(System.currentTimeMillis());
        }

        public void setCurrentStencil(boolean currentStencil) {
            if (currentStencil) {
                StencilObject obj;
                this.error = false;
                this.addAllListeners();
                int i = 0;
                while (i < this.stencilObjects.size()) {
                    WaitAndUpdateThread godot;
                    boolean success;
                    obj = (StencilObject)this.stencilObjects.elementAt(i);
                    if (obj instanceof Hole) {
                        success = ((Hole)obj).layoutChanged();
                        godot = new WaitAndUpdateThread(1250L, this, (LayoutChangeListener)((Object)obj));
                        godot.start();
                    } else if (obj instanceof Frame) {
                        success = ((Frame)obj).layoutChanged();
                        godot = new WaitAndUpdateThread(1250L, this, (LayoutChangeListener)((Object)obj));
                        godot.start();
                    }
                    ++i;
                }
                i = 0;
                while (i < this.stencilObjects.size()) {
                    obj = (StencilObject)this.stencilObjects.elementAt(i);
                    if (obj instanceof Note) {
                        ((Note)obj).updatePosition();
                    }
                    ++i;
                }
            } else {
                if (this.error && StencilManager.this.errorStencil != null) {
                    StencilManager.this.errorStencil.removeAllListeners();
                }
                this.removeAllListeners();
            }
        }

        public void addObject(StencilObject stencilObject) {
            this.stencilObjects.addElement(stencilObject);
            if (stencilObject instanceof ReadWriteListener) {
                StencilManager.this.addReadWriteListener((ReadWriteListener)((Object)stencilObject));
                ((ReadWriteListener)((Object)stencilObject)).setWriteEnabled(StencilManager.this.writeEnabled);
            }
        }

        public void removeObject(StencilObject stencilObject) {
            this.stencilObjects.removeElement(stencilObject);
            if (stencilObject instanceof ReadWriteListener) {
                StencilManager.this.removeReadWriteListener((ReadWriteListener)((Object)stencilObject));
            }
        }

        protected void addAllListeners() {
            int i = 0;
            while (i < this.stencilObjects.size()) {
                StencilObject obj = (StencilObject)this.stencilObjects.elementAt(i);
                if (obj instanceof MouseEventListener) {
                    StencilManager.this.addMouseEventListener((MouseEventListener)((Object)obj));
                }
                if (obj instanceof KeyEventListener) {
                    StencilManager.this.addKeyEventListener((KeyEventListener)((Object)obj));
                }
                if (obj instanceof StencilFocusListener) {
                    StencilManager.this.addStencilFocusListener((StencilFocusListener)((Object)obj));
                }
                if (obj instanceof LayoutChangeListener) {
                    StencilManager.this.addLayoutChangeListener((LayoutChangeListener)((Object)obj));
                }
                if (obj instanceof StencilStackChangeListener) {
                    StencilManager.this.addStencilStackChangeListener((StencilStackChangeListener)((Object)obj));
                }
                if (obj instanceof StencilPanelMessageListener) {
                    StencilManager.this.stencilPanel.addMessageListener((StencilPanelMessageListener)((Object)obj));
                }
                ++i;
            }
        }

        protected void removeAllListeners() {
            int i = 0;
            while (i < this.stencilObjects.size()) {
                StencilObject obj = (StencilObject)this.stencilObjects.elementAt(i);
                if (obj instanceof MouseEventListener) {
                    StencilManager.this.removeMouseEventListener((MouseEventListener)((Object)obj));
                }
                if (obj instanceof KeyEventListener) {
                    StencilManager.this.removeKeyEventListener((KeyEventListener)((Object)obj));
                }
                if (obj instanceof StencilFocusListener) {
                    StencilManager.this.removeStencilFocusListener((StencilFocusListener)((Object)obj));
                }
                if (obj instanceof LayoutChangeListener) {
                    StencilManager.this.removeLayoutChangeListener((LayoutChangeListener)((Object)obj));
                }
                if (obj instanceof StencilStackChangeListener) {
                    StencilManager.this.removeStencilStackChangeListener((StencilStackChangeListener)((Object)obj));
                }
                if (obj instanceof StencilPanelMessageListener) {
                    StencilManager.this.stencilPanel.removeMessageListener((StencilPanelMessageListener)((Object)obj));
                }
                ++i;
            }
        }

        public void removeAllObjects() {
            Vector newStencilObjects = new Vector();
            int i = 0;
            while (i < this.stencilObjects.size()) {
                if (this.stencilObjects.elementAt(i) instanceof Menu || this.stencilObjects.elementAt(i) instanceof NavigationBar || this.stencilObjects.elementAt(i) instanceof Link) {
                    newStencilObjects.addElement(this.stencilObjects.elementAt(i));
                } else {
                    StencilObject obj = (StencilObject)this.stencilObjects.elementAt(i);
                    if (obj instanceof MouseEventListener) {
                        StencilManager.this.removeMouseEventListener((MouseEventListener)((Object)obj));
                    }
                    if (obj instanceof KeyEventListener) {
                        StencilManager.this.removeKeyEventListener((KeyEventListener)((Object)obj));
                    }
                    if (obj instanceof StencilFocusListener) {
                        StencilManager.this.removeStencilFocusListener((StencilFocusListener)((Object)obj));
                    }
                    if (obj instanceof LayoutChangeListener) {
                        StencilManager.this.removeLayoutChangeListener((LayoutChangeListener)((Object)obj));
                    }
                    if (obj instanceof StencilStackChangeListener) {
                        StencilManager.this.removeStencilStackChangeListener((StencilStackChangeListener)((Object)obj));
                    }
                    if (obj instanceof StencilPanelMessageListener) {
                        StencilManager.this.stencilPanel.removeAllMessageListeners();
                    }
                }
                ++i;
            }
            this.stencilObjects = newStencilObjects;
        }

        public Vector getObjects() {
            if (this.error) {
                if (StencilManager.this.errorStencil == null) {
                    StencilManager.this.errorStencil = StencilManager.this.stencilParser.getErrorStencil();
                }
                StencilManager.this.errorStencil.addAllListeners();
                return StencilManager.this.errorStencil.getObjects();
            }
            return this.stencilObjects;
        }

        public String getTitle() {
            String str = "";
            int i = 0;
            while (i < this.stencilObjects.size()) {
                StencilObject localStencilObject = (StencilObject)this.stencilObjects.elementAt(i);
                if (localStencilObject instanceof NavigationBar) {
                    str = ((NavigationBar)localStencilObject).getTitleString();
                    break;
                }
                ++i;
            }
            return str != null ? str : "";
        }

        public String getFirstNote() {
            String str = "";
            int i = 0;
            while (i < this.stencilObjects.size()) {
                StencilObject localStencilObject = (StencilObject)this.stencilObjects.elementAt(i);
                if (localStencilObject instanceof Note) {
                    str = ((Note)localStencilObject).getFirstNote();
                    break;
                }
                ++i;
            }
            return str != null ? str : "";
        }

        public void removeLastObject() {
            if (this.stencilObjects.size() > 0) {
                if (this.stencilObjects.size() == 1) {
                    this.removeAllObjects();
                } else {
                    StencilObject localStencilObject = (StencilObject)this.stencilObjects.get(this.stencilObjects.size() - 1);
                    this.stencilObjects.removeElementAt(this.stencilObjects.size() - 1);
                    if (localStencilObject instanceof ReadWriteListener) {
                        StencilManager.this.removeReadWriteListener((ReadWriteListener)((Object)localStencilObject));
                    }
                    if ((localStencilObject = (StencilObject)this.stencilObjects.get(this.stencilObjects.size() - 1)) instanceof Frame || localStencilObject instanceof Hole) {
                        this.stencilObjects.removeElementAt(this.stencilObjects.size() - 1);
                        if (localStencilObject instanceof ReadWriteListener) {
                            StencilManager.this.removeReadWriteListener((ReadWriteListener)((Object)localStencilObject));
                        }
                    }
                }
            }
        }
    }

    protected class StencilFileFilter
    extends FileFilter {
        protected StencilFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.getName().endsWith(".stl")) {
                return true;
            }
            return pathname.isDirectory();
        }

        @Override
        public String getDescription() {
            return "Stencil Files";
        }
    }

    protected class StencilMouseAdapter
    extends CustomMouseAdapter {
        protected StencilMouseAdapter() {
        }

        @Override
        protected void singleClickResponse(MouseEvent ev) {
            StencilManager.this.mouseClicked(ev);
        }

        @Override
        protected void doubleClickResponse(MouseEvent ev) {
            StencilManager.this.mouseClicked(ev);
        }

        @Override
        protected void mouseUpResponse(MouseEvent ev) {
            StencilManager.this.mouseReleased(ev);
        }

        @Override
        protected void mouseDownResponse(MouseEvent ev) {
            StencilManager.this.mousePressed(ev);
        }
    }
}

