/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.stencilhelp.client;

import edu.cmu.cs.stage3.caitlin.stencilhelp.client.Hole;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.MouseEventListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ReadWriteListener;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ScreenShape;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilManager;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilPanelMessageListener;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JPanel;

public class StencilPanel
extends JPanel
implements MouseEventListener,
ReadWriteListener {
    protected StencilManager stencilManager = null;
    protected boolean isDrawing = false;
    protected Vector holes = new Vector();
    protected Vector filledShapes = new Vector();
    protected Vector unfilledShapes = new Vector();
    protected Vector stencilPanelMessageListeners = new Vector();
    protected boolean writeEnabled = true;
    protected Vector holeRegions = new Vector();
    protected Vector clearRegions = new Vector();
    protected boolean nothingToDraw = true;
    protected Color bgColor = new Color(13, 99, 161, 150);
    protected Image img = null;
    protected BufferedImage bImg = null;
    protected BufferedImage screenBuffer = null;
    protected MediaTracker mTracker = null;
    protected TexturePaint tPaint = null;

    public StencilPanel(StencilManager stencilManager) {
        this.stencilManager = stencilManager;
        Toolkit toolKit = this.getToolkit();
        this.img = toolKit.getImage("blue2.png");
        this.mTracker = new MediaTracker(this);
        this.mTracker.addImage(this.img, 1);
    }

    public void setIsDrawing(boolean isDrawing) {
        this.isDrawing = isDrawing;
        this.setVisible(isDrawing);
    }

    public boolean getIsDrawing() {
        return this.isDrawing;
    }

    public void redraw() {
        this.repaint();
    }

    protected void categorizeShapes(Vector shapes, Vector allRegions) {
        this.holes = new Vector();
        this.filledShapes = new Vector();
        this.unfilledShapes = new Vector();
        this.holeRegions = new Vector();
        this.clearRegions = new Vector();
        int i = 0;
        while (i < shapes.size()) {
            ScreenShape currentShape = (ScreenShape)shapes.elementAt(i);
            if (currentShape.getColor() == null) {
                this.holes.addElement(currentShape);
                if (currentShape.getIndex() == 0) {
                    this.holeRegions.addElement(currentShape.getShape().getBounds());
                }
            } else {
                if (currentShape.getIndex() == 0 && allRegions.size() > 0) {
                    Rectangle r = (Rectangle)allRegions.remove(0);
                    this.clearRegions.addElement(r);
                }
                if (currentShape.getIsFilled()) {
                    this.filledShapes.addElement(currentShape);
                } else {
                    this.unfilledShapes.addElement(currentShape);
                }
            }
            ++i;
        }
        if (shapes.size() == 0 && allRegions.size() > 0) {
            this.clearRegions = allRegions;
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.screenBuffer == null || this.screenBuffer.getWidth() != this.getWidth() || this.screenBuffer.getHeight() != this.getHeight()) {
            this.screenBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics graphics = this.screenBuffer.getGraphics();
            graphics.setColor(this.bgColor);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Vector allShapes = this.stencilManager.getUpdateShapes();
        Vector allRegions = this.stencilManager.getClearRegions();
        this.categorizeShapes(allShapes, allRegions);
        Graphics2D bg2 = (Graphics2D)this.screenBuffer.getGraphics();
        bg2.setBackground(new Color(255, 255, 255, 0));
        Graphics2D g2 = (Graphics2D)g;
        if (this.isDrawing) {
            ScreenShape currentShape;
            Rectangle r;
            Object oldAntialiasing = null;
            if (g instanceof Graphics2D) {
                oldAntialiasing = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                ((Graphics2D)g).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
                bg2.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            }
            Area outside = null;
            Color outsideColor = this.bgColor;
            if (this.tPaint != null) {
                bg2.setPaint(this.tPaint);
            } else {
                bg2.setColor(outsideColor);
            }
            int i = 0;
            while (i < this.clearRegions.size()) {
                r = (Rectangle)this.clearRegions.elementAt(i);
                bg2.clearRect((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
                bg2.fillRect((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
                ++i;
            }
            i = 0;
            while (i < this.holeRegions.size()) {
                r = (Rectangle)this.holeRegions.elementAt(i);
                bg2.clearRect((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
                ++i;
            }
            i = 0;
            while (i < this.holes.size()) {
                outside = new Area((Rectangle)this.holeRegions.elementAt(i));
                ScreenShape scrShape = (ScreenShape)this.holes.elementAt(i);
                RoundRectangle2D.Double r2 = (RoundRectangle2D.Double)scrShape.getShape();
                RoundRectangle2D.Double upperShadow = new RoundRectangle2D.Double(r2.x - 2.0, r2.y - 2.0, r2.width + 2.0, r2.height + 2.0, r2.arcwidth, r2.archeight);
                RoundRectangle2D.Double lowerShadow = new RoundRectangle2D.Double(r2.x, r2.y, r2.width + 2.0, r2.height + 2.0, r2.arcwidth, r2.archeight);
                Area upperBorder = new Area(upperShadow);
                Area currentArea = new Area(r2);
                upperBorder.subtract(currentArea);
                bg2.setColor(Color.darkGray);
                bg2.fill(upperBorder);
                Area lowerBorder = new Area(lowerShadow);
                lowerBorder.subtract(currentArea);
                bg2.setColor(Color.lightGray);
                bg2.fill(lowerBorder);
                outside.subtract(currentArea);
                bg2.fill(outside);
                ++i;
            }
            bg2.setColor(outsideColor);
            i = 0;
            while (i < this.filledShapes.size()) {
                currentShape = (ScreenShape)this.filledShapes.elementAt(i);
                if (currentShape.shape instanceof Line2D) {
                    bg2.setColor(currentShape.color);
                    bg2.draw(currentShape.shape);
                } else {
                    bg2.setColor(currentShape.color);
                    bg2.fill(currentShape.shape);
                }
                ++i;
            }
            i = 0;
            while (i < this.unfilledShapes.size()) {
                currentShape = (ScreenShape)this.unfilledShapes.elementAt(i);
                bg2.setColor(currentShape.color);
                bg2.draw(currentShape.shape);
                ++i;
            }
            g2.drawImage(this.screenBuffer, null, null);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, oldAntialiasing));
            }
        }
    }

    public void addMessageListener(StencilPanelMessageListener spmListener) {
        this.stencilPanelMessageListeners.addElement(spmListener);
    }

    public void removeMessageListener(StencilPanelMessageListener spmListener) {
        this.stencilPanelMessageListeners.remove(spmListener);
    }

    public void removeAllMessageListeners() {
        this.stencilPanelMessageListeners.removeAllElements();
    }

    protected void broadCastMessage(int messageID, Object data) {
        int i = 0;
        while (i < this.stencilPanelMessageListeners.size()) {
            StencilPanelMessageListener spmListener = (StencilPanelMessageListener)this.stencilPanelMessageListeners.elementAt(i);
            spmListener.messageReceived(messageID, data);
            ++i;
        }
    }

    @Override
    public boolean contains(Point point) {
        return true;
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseReleased(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseClicked(MouseEvent e) {
        if (e.getModifiers() == 4) {
            this.broadCastMessage(1, e.getPoint());
            return true;
        }
        if (e.getClickCount() == 2 && this.writeEnabled) {
            this.stencilManager.createNewHole(e.getPoint());
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseEntered(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseExited(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    @Override
    public void setWriteEnabled(boolean enabled) {
        this.writeEnabled = enabled;
    }

    protected class HoleData {
        public Hole hole;
        public Rectangle clearRect;

        protected HoleData() {
        }
    }
}

